/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapstransectgenerator.core;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.preprocessing.sampling.AbsoluteSampling;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBAquamapsExtractor;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.DBPostGISExtractror;
import org.gcube.application.aquamaps.aquamapstransectgenerator.databases.tools.MapMerger;
import org.gcube.contentmanagement.graphtools.data.GraphSamplesTable;
import org.gcube.contentmanagement.graphtools.data.conversions.GraphConverter2D;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;

public class AquamapsProcessor {
    private static final String LogFile = "ALog.properties";
    private static final String OperatorsFile = "operators.xml";
    DBAquamapsExtractor dbaqua;
    DBPostGISExtractror dbGis;
    private ArrayList<String> longlatarray;
    private ArrayList<Double> biodivvalues;

    public void init(String cfg) {
        AnalysisLogger.setLogger((String)(cfg + LogFile));
        System.setProperty("rapidminer.init.operators", cfg + OperatorsFile);
        this.dbaqua = new DBAquamapsExtractor(cfg);
        this.dbGis = new DBPostGISExtractror(cfg);
        RapidMiner.init();
        AnalysisLogger.getLogger().info((Object)"AquamapsProcessor->Initialization Complete");
    }

    public GraphGroups calculateTransect(String x1, String y1, String x2, String y2, String SRID, String biodiversityTable, String biodiversityColumn, int maxElements) throws Exception {
        int minimumGap = maxElements / 100;
        return this.calculateTransect(x1, y1, x2, y2, SRID, biodiversityTable, biodiversityColumn, maxElements, minimumGap);
    }

    public GraphGroups calculateTransect(String x1, String y1, String x2, String y2, String SRID, String biodiversityTable, String biodiversityColumn, int maxElements, int minimumGap) throws Exception {
        GraphGroups graphgroups = new GraphGroups();
        List<String> csquarecodes = this.dbGis.getAllInfo(x1, y1, x2, y2, SRID, biodiversityTable, biodiversityColumn);
        int numbOfCodes = csquarecodes.size();
        if (numbOfCodes > 0) {
            Map<String, Double> biodiversityvalues = this.dbGis.getCalculatedBioValues();
            if (biodiversityvalues.size() > 0) {
                Map<String, String> longlat = this.dbaqua.getLongLatBioDiversity(csquarecodes, null);
                MapMerger mm = new MapMerger();
                mm.mergeMaps(longlat, biodiversityvalues);
                ArrayList longlatarray = mm.extractFirstVector();
                ArrayList biodivvalues = mm.extractSecondVector();
                GraphSamplesTable gts = null;
                GraphData grd = null;
                if (numbOfCodes > maxElements) {
                    AnalysisLogger.getLogger().trace((Object)"AquamapsProcessor->Resampling");
                    gts = new GraphSamplesTable("Biodiversity Transect", longlatarray, biodivvalues, false);
                    ExampleSet es = gts.generateExampleSet();
                    AbsoluteSampling asop = (AbsoluteSampling)OperatorService.createOperator((String)"AbsoluteSampling");
                    asop.setParameter("sample_size", "" + maxElements);
                    asop.setParameter("local_random_seed", "-1");
                    es = asop.apply(es);
                    gts = new GraphSamplesTable();
                    gts.generateSampleTable(es);
                    List singlegraph = GraphConverter2D.reorder((List)gts.getGraph());
                    grd = new GraphData(singlegraph, true);
                } else {
                    gts = new GraphSamplesTable("Biodiversity Transect", longlatarray, biodivvalues, true);
                    grd = new GraphData(gts.getGraph(), false);
                }
                graphgroups.addGraph("Distribution for " + biodiversityTable, grd);
                List pl = GraphConverter2D.getStationaryPoints((GraphData)grd);
                List lables = GraphConverter2D.getLablesFromPoints((Point)((Point)pl.get(0)));
                List<String> anotations = this.dbaqua.getAreaAnotations(lables);
                GraphConverter2D.anotateStationaryPoints((GraphGroups)graphgroups, anotations);
                GraphConverter2D.sampleAnotationBySameFollower((List)grd.getData());
                List zerosIndexes = MathFunctions.findZeros((double[])MathFunctions.points2Double((List)grd.getData(), (int)0, (int)((Point)grd.getData().get(0)).getEntries().size()));
                List zeroslabels = GraphConverter2D.getLabelsfromIndexes((List)grd.getData(), (List)zerosIndexes);
                List<String> zerosanotations = this.dbaqua.getAreaAnotations(zeroslabels);
                GraphConverter2D.anotatePoints((GraphGroups)graphgroups, (List)zerosIndexes, zerosanotations);
                GraphConverter2D.sampleAnotationByRange((List)grd.getData(), (int)minimumGap);
            } else {
                AnalysisLogger.getLogger().info((Object)"AquamapsProcessor->Empty Set Found for Biodiversity");
            }
        } else {
            AnalysisLogger.getLogger().info((Object)"AquamapsProcessor->Empty Set Found for Cells");
        }
        return graphgroups;
    }
}

