/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;
import org.gcube.contentmanagement.codelistmanager.util.opensdmx.SDMXImport;
import org.sdmx.resources.sdmxml.schemas.v2_0.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeRefType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.HierarchyType;

public class HCLSDMXImport
extends SDMXImport {
    private String childColumn = "hlchild_code";
    private String parentColumn = "hlparent_code";
    private HierarchicalCodelistType codeList;

    public HCLSDMXImport(HierarchicalCodelistType codelist) {
        this.codeList = codelist;
    }

    @Override
    public String getAgencyId() {
        return this.codeList.getAgencyID();
    }

    @Override
    public String getName() {
        if (this.codeList.getNames().size() > 0) {
            return ((TextType)this.codeList.getNames().get(0)).getValue();
        }
        return "undefined";
    }

    @Override
    public String getDescription() {
        if (this.codeList.getDescriptions().size() > 0) {
            return ((TextType)this.codeList.getDescriptions().get(0)).getValue();
        }
        return "undefined";
    }

    @Override
    public String getValidFrom() {
        if (this.codeList.getValidFrom() != null) {
            return this.codeList.getValidFrom();
        }
        return "undefined";
    }

    @Override
    public String getValidTo() {
        if (this.codeList.getValidTo() != null) {
            return this.codeList.getValidTo();
        }
        return "undefined";
    }

    @Override
    public float getVersion() {
        if (this.codeList.getVersion() != null) {
            return Float.parseFloat(this.codeList.getVersion());
        }
        return 0.0f;
    }

    @Override
    public boolean isFinal() {
        if (this.codeList.getIsFinal() == null) {
            return false;
        }
        return this.codeList.getIsFinal();
    }

    @Override
    protected List<SDMXImport.FieldDefinition> retrieveFieldsDefinition() {
        ArrayList<SDMXImport.FieldDefinition> fieldsDefinition = new ArrayList<SDMXImport.FieldDefinition>();
        this.parentColumn = ((CodelistRefType)this.codeList.getCodelistReves().get(0)).getAlias();
        this.childColumn = ((CodelistRefType)this.codeList.getCodelistReves().get(1)).getAlias();
        fieldsDefinition.add(new SDMXImport.FieldDefinition(this, this.parentColumn, new int[]{1, 0}, new ColumnReference(TableField.ColumnType.HLParentCode, ((CodelistRefType)this.codeList.getCodelistReves().get(0)).getAlias())));
        fieldsDefinition.add(new SDMXImport.FieldDefinition(this, this.childColumn, new int[]{1, 0}, new ColumnReference(TableField.ColumnType.HLChildCode, ((CodelistRefType)this.codeList.getCodelistReves().get(1)).getAlias())));
        for (HierarchyType hyType : this.codeList.getHierarchies()) {
            for (CodeRefType codeRef : hyType.getCodeReves()) {
                SDMXImport.FieldDefinition parentDef = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition(this, this.parentColumn)));
                if (codeRef.getCodeID().length() > parentDef.getLength()[0]) {
                    parentDef.setLength(new int[]{codeRef.getCodeID().length(), parentDef.getLength()[1]});
                }
                if (ImportUtil.getAfterDotLength(codeRef.getCodeID()) > parentDef.getLength()[1]) {
                    parentDef.setLength(new int[]{parentDef.getLength()[0], ImportUtil.getAfterDotLength(codeRef.getCodeID())});
                }
                SDMXImport.FieldDefinition childDef = (SDMXImport.FieldDefinition)fieldsDefinition.get(fieldsDefinition.indexOf(new SDMXImport.FieldDefinition(this, this.childColumn)));
                for (CodeRefType subCodeRef : codeRef.getCodeReves()) {
                    if (subCodeRef.getCodeID().length() > childDef.getLength()[0]) {
                        childDef.setLength(new int[]{subCodeRef.getCodeID().length(), childDef.getLength()[1]});
                    }
                    if (ImportUtil.getAfterDotLength(subCodeRef.getCodeID()) > childDef.getLength()[1]) {
                        childDef.setLength(new int[]{childDef.getLength()[0], ImportUtil.getAfterDotLength(subCodeRef.getCodeID())});
                    }
                    ++this.totalLine;
                }
            }
        }
        return fieldsDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(SimpleTable table, ProgresChangedEvent event) throws Exception {
        Insert insertQuery = (Insert)DBSession.getImplementation(Insert.class);
        insertQuery.setTable(table);
        DBSession session = DBSession.connect();
        session.disableAutoCommit();
        try {
            for (HierarchyType hyType : this.codeList.getHierarchies()) {
                Object[] line = new String[this.fieldsDefinition.size() + 1];
                line[0] = "DEFAULT";
                Arrays.fill(line, null);
                for (CodeRefType codeRef : hyType.getCodeReves()) {
                    line[this.fieldsDefinition.indexOf((Object)new SDMXImport.FieldDefinition((SDMXImport)this, (String)this.parentColumn)) + 1] = codeRef.getCodeID();
                    for (CodeRefType subCodeRef : codeRef.getCodeReves()) {
                        line[this.fieldsDefinition.indexOf((Object)new SDMXImport.FieldDefinition((SDMXImport)this, (String)this.childColumn)) + 1] = subCodeRef.getCodeID();
                        insertQuery.setInsertValues(line);
                        insertQuery.execute(session);
                        ++this.progress;
                        event.onProgresChanged(this.progress);
                    }
                }
            }
            session.commit();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }
}

