/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.entities;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.exception.CurationNotFinishedException;
import org.gcube.contentmanagement.codelistmanager.exception.SerializationException;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListCuration;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;

@TableRootDefinition
public class CodeList
extends ObjectStateControl {
    private static GCUBELog logger = new GCUBELog(CodeList.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String name;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String agency;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private boolean isFinal;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Calendar creationDate;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Calendar modificationDate;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private boolean approved;
    @FieldDefinition(precision={4, 2}, specifications={Specification.NOT_NULL})
    private float version = 0.0f;
    @FieldDefinition
    private String versionLog;
    @FieldDefinition(precision={40})
    private String parentCodeListId = null;
    @FieldDefinition
    private Hashtable<String, TableField> labelFieldMapping;
    @FieldDefinition
    private SimpleTable table;
    @FieldDefinition
    private CodeListType codelistType;
    @FieldDefinition(precision={60})
    private String tableName;

    private CodeList() {
    }

    public CodeList(String agencyId, String name, String description, boolean isFinal) {
        Calendar now;
        this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        this.version = 0.0f;
        this.approved = false;
        this.modificationDate = now = Calendar.getInstance();
        this.creationDate = now;
        this.name = name;
        this.isFinal = isFinal;
        this.description = description;
        this.agency = agencyId;
    }

    public boolean initialize(CodeListCuration mapper) {
        try {
            if (!mapper.isMappingFinished()) {
                throw new CurationNotFinishedException();
            }
            this.table = this.createTable(mapper.getTable());
            this.tableName = this.table.getTableName();
            this.table.initializeCount();
            this.table.initializeFieldMapping();
            this.parentCodeListId = mapper.getId();
            this.labelFieldMapping = mapper.getLabelFieldMapping();
            this.codelistType = mapper.getCodelistType();
            this.version = mapper.getVersion();
            if (!this.store()) {
                throw new SerializationException();
            }
        }
        catch (Exception e) {
            logger.error((Object)"error initializing the codelist", (Throwable)e);
            return false;
        }
        return true;
    }

    public CodeListType getCodelistType() {
        return this.codelistType;
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public float getVersion() {
        return this.version;
    }

    public String getParentCodeListId() {
        return this.parentCodeListId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agency) {
        this.agency = agency;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getRelatedTableName() {
        if (this.table == null) {
            return null;
        }
        return this.table.getTableName();
    }

    public Hashtable<String, TableField> getLabelFieldMapping() {
        return this.labelFieldMapping;
    }

    public Calendar getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Calendar modificationDate) {
        this.modificationDate = modificationDate;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public int getCount() throws Exception {
        SimpleTable table = new SimpleTable(this.getRelatedTableName());
        table.initializeCount();
        return table.getCount();
    }

    public String getCodeColumnId() {
        for (TableField tf : this.labelFieldMapping.values()) {
            if (tf.getColumnReference().getType() != TableField.ColumnType.Code) continue;
            return tf.getId();
        }
        return null;
    }

    public boolean addLine() {
        return false;
    }

    public boolean removeLine() {
        return false;
    }

    public void remove() throws Exception {
        ObjectPersistency.get(CodeList.class).deleteByKey((Object)this.id);
    }

    public boolean store() {
        try {
            ObjectPersistency pers = ObjectPersistency.get(CodeList.class);
            if (!pers.existsKey((Object)this.id)) {
                ObjectPersistency.get(CodeList.class).insert((Object)this);
            } else {
                this.modificationDate = Calendar.getInstance();
                ObjectPersistency.get(CodeList.class).update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    private SimpleTable createTable(SimpleTable mapperTable) throws SerializationException {
        DBSession session = null;
        try {
            SimpleTable table;
            session = DBSession.connect();
            CreateTableFromSelect createTable = (CreateTableFromSelect)DBSession.getImplementation(CreateTableFromSelect.class);
            createTable.setTableName("rdf" + this.id.replaceAll("-", ""));
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{mapperTable});
            select.setOrders(new Order[]{new Order(Order.OrderType.ASC, (Attribute)new SimpleAttribute("ID"))});
            createTable.setSelect(select);
            SimpleTable simpleTable = table = createTable.execute(session);
            return simpleTable;
        }
        catch (Exception e) {
            throw new SerializationException();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public static CodeList get(String id) throws Exception {
        return (CodeList)((Object)ObjectPersistency.get(CodeList.class).getByKey((Object)id));
    }

    public static Iterator<CodeList> getByName(String name) throws Exception {
        return ObjectPersistency.get(CodeList.class).getObjectByField("name", (Object)name);
    }

    public static Iterator<CodeList> getByType(CodeListType type) throws Exception {
        return ObjectPersistency.get(CodeList.class).getObjectByField("codelistType", (Object)type.toString());
    }

    public static Iterator<CodeList> getAll() throws Exception {
        return ObjectPersistency.get(CodeList.class).getAll();
    }

    public static String getTableName() throws Exception {
        return ObjectPersistency.get(CodeList.class).getTable().getTableName();
    }

    public static Map<String, String> getInfo() throws Exception {
        return ObjectPersistency.get(CodeList.class).getInfo();
    }
}

