/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.managers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.IntArray;
import org.gcube.common.dbinterface.conditions.IsInOperator;
import org.gcube.common.dbinterface.conditions.Listable;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListImport;
import org.gcube.contentmanagement.codelistmanager.managers.handlers.CodeListCurationHandler;
import org.gcube.contentmanagement.codelistmanager.managers.handlers.CodeListHandler;
import org.gcube.contentmanagement.codelistmanager.managers.handlers.HierarchicalCodeListHandler;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.RowIterator;

@TableRootDefinition
public class CodeListCuration
extends ObjectStateControl {
    private static GCUBELog logger = new GCUBELog(CodeListCuration.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    protected String id;
    @FieldDefinition
    protected Hashtable<String, TableField> labelFieldMapping;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    protected String agencyId;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    protected String name;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    protected String description;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    protected Calendar creationDate;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    protected Calendar lastModifyDate;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    protected boolean isFinal;
    @FieldDefinition(precision={4, 2}, specifications={Specification.NOT_NULL})
    protected float version;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    protected CodeListType codelistType;
    @FieldDefinition(precision={40})
    protected String codeListImportId;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    protected SimpleTable table;

    private CodeListCuration() {
    }

    public CodeListCuration(String name, String description, String agencyId, boolean isFinal, float version, CodeListType type) {
        Calendar now;
        this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        this.name = name;
        this.description = description;
        this.agencyId = agencyId;
        this.isFinal = isFinal;
        this.creationDate = now = Calendar.getInstance();
        this.lastModifyDate = now;
        this.codelistType = type;
        this.version = version;
    }

    public CodeListCuration(String name, String description, String agencyId, boolean isFinal, float version) {
        Calendar now;
        this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        this.name = name;
        this.description = description;
        this.agencyId = agencyId;
        this.isFinal = isFinal;
        this.creationDate = now = Calendar.getInstance();
        this.lastModifyDate = now;
        this.version = version;
        this.codelistType = CodeListType.Unknown;
    }

    public String getId() {
        return this.id;
    }

    protected CodeListCurationHandler getHandler() {
        if (this.codelistType == CodeListType.Hierarchical) {
            return HierarchicalCodeListHandler.get();
        }
        return CodeListHandler.get();
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public int getCount() {
        if (this.table == null) {
            return 0;
        }
        try {
            return this.table.getCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void updateCount() {
        try {
            this.table.initializeCount();
        }
        catch (Exception e) {
            logger.warn((Object)"error initiliazing count", (Throwable)e);
        }
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public CodeListType getCodelistType() {
        return this.codelistType;
    }

    public void setCodelistType(CodeListType codelistType) {
        this.codelistType = codelistType;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getCodeListImportId() {
        return this.codeListImportId;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public Hashtable<String, TableField> getLabelFieldMapping() {
        return this.labelFieldMapping;
    }

    public void setLabelFieldMapping(Hashtable<String, TableField> labelFieldMapping) {
        this.labelFieldMapping = labelFieldMapping;
    }

    public String getTableName() {
        if (this.table == null) {
            return null;
        }
        return this.table.getTableName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(CodeListImport importManager) {
        this.codeListImportId = importManager.getId();
        DBSession session = null;
        try {
            if (importManager.getStatus() == CodeListImport.Status.Failed) {
                throw new Exception("cannot start a curation from a failed import");
            }
            session = DBSession.connect();
            session.disableAutoCommit();
            CreateTableLike createLike = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
            createLike.setTableLike(new SimpleTable(importManager.getTableName()));
            createLike.setTableName("rdm" + this.id.replace("-", ""));
            try {
                this.table = createLike.execute(session);
            }
            catch (TableAlreadyExistsException e) {
                logger.info((Object)"the table already exist, recreating it");
                Utility.drop((String)importManager.getTableName()).execute(session);
                this.table = createLike.execute(session);
            }
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{new SimpleTable(importManager.getTableName())});
            select.setUseDistinct(true);
            InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
            insert.setSubQuery(select);
            insert.setTable(this.table);
            insert.execute(session);
            session.commit();
            logger.trace((Object)("the table name is:" + this.table.getTableName()));
            this.labelFieldMapping = importManager.getFieldsName();
            if (importManager.getCodelistType() == CodeListType.Hierarchical) {
                for (TableField tf : this.labelFieldMapping.values()) {
                    Iterator<CodeList> codelistIt;
                    if (tf.getColumnReference().getType() != TableField.ColumnType.HLParentCode && tf.getColumnReference().getType() != TableField.ColumnType.HLChildCode || !(codelistIt = CodeList.getByName(tf.getColumnReference().getCodelistReferenceName())).hasNext()) continue;
                    tf.getColumnReference().setCodelistReferenceId(codelistIt.next().getId());
                }
            }
            this.table.initializeCount();
            this.store();
            session.commit();
        }
        catch (Exception e) {
            logger.error((Object)"error starting the mapping ", (Throwable)e);
            try {
                if (session != null) {
                    session.rollback();
                }
            }
            catch (Exception e1) {
                logger.warn((Object)"error cleaning the table");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    public List<String> getFieldsIdByColumnType(TableField.ColumnType columnType) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (TableField tf : this.labelFieldMapping.values()) {
            if (tf.getColumnReference().getType() != columnType) continue;
            toReturn.add(tf.getId());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeColumn(String fieldId) {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Utility.dropColumn((String)fieldId, (Table)this.table).execute(session);
            this.getLabelFieldMapping().remove(fieldId);
            this.table.initializeFieldMapping(session);
        }
        catch (Exception e) {
            logger.error((Object)"error dropping column", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRows(int ... rowsId) {
        DBSession session = null;
        try {
            Delete deleteRows = (Delete)DBSession.getImplementation(Delete.class);
            deleteRows.setFilter((Condition)new IsInOperator(new SimpleAttribute("ID"), (Listable)new IntArray(rowsId)));
            deleteRows.setTable((Table)this.table);
            deleteRows.execute(session);
            this.table.initializeCount(session);
        }
        catch (Exception e) {
            logger.error((Object)"error deleting rows ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    public Iterator<List<String>> getData() throws Exception {
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.table});
        return this.getData(select);
    }

    public Iterator<List<String>> getRowsData(Integer ... rowsIds) throws Exception {
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.table});
        select.setFilter((Condition)new IsInOperator(new SimpleAttribute("ID"), (Listable)new IntArray(rowsIds)));
        return this.getData(select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<List<String>> getData(Select query) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            RowIterator rowIterator = new RowIterator(query);
            return rowIterator;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(CodeListCuration.class);
            if (!op.existsKey((Object)this.getId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean remove() {
        try {
            Utility.drop((String)this.getTableName());
            ObjectPersistency.get(CodeListCuration.class).deleteByKey((Object)this.id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isMappingFinished() {
        return this.getHandler().isMappingFinished(this.table, this.labelFieldMapping);
    }

    public static Iterator<CodeListCuration> getAll() throws Exception {
        return ObjectPersistency.get(CodeListCuration.class).getAll();
    }

    public static CodeListCuration get(String id) throws Exception {
        return (CodeListCuration)((Object)ObjectPersistency.get(CodeListCuration.class).getByKey((Object)id));
    }

    public static void destroy(String id) throws Exception {
        ObjectPersistency.get(CodeListCuration.class).deleteByKey((Object)id);
    }

    public void changeColumnType(String fieldId, TableField.ColumnType columnType, String ... codelistReferenceId) throws Exception {
        if (codelistReferenceId == null) {
            this.getHandler().changeColumnType(fieldId, columnType, this.table, this.labelFieldMapping, new String[0]);
        } else {
            this.getHandler().changeColumnType(fieldId, columnType, this.table, this.labelFieldMapping, codelistReferenceId);
        }
    }

    public Integer[] getInvalidRows(String fieldId, ColumnReference columnDefinition) throws Exception {
        return this.getHandler().checkInvalidValues(fieldId, columnDefinition, this.table, this.labelFieldMapping);
    }

    public Integer[] getInvalidRows(String fieldId, Type type) throws Exception {
        return this.getHandler().checkInvalidValues(fieldId, type, this.table, this.labelFieldMapping);
    }

    public void replaceValue(String fieldId, String newValue, int row) throws Exception {
        this.getHandler().replaceValue(fieldId, newValue, row, this.table, this.labelFieldMapping);
    }
}

