package org.gcube.contentmanagement.codelistmanager.entities;

import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;

public class TableField implements Comparable<TableField>{

	public enum ColumnType {Undefined, Code, Description, Annotation, ParentCode, HLChildCode, HLParentCode};
	
	private String id;
	private String fieldName;
	private ColumnReference columnReference; 
	private Types dataType;
	private int[] length;
	
	public TableField(String id, String fieldName, ColumnType columnType, Types dataType, int[] length) {
		super();
		this.id = id;
		this.fieldName = fieldName;
		this.columnReference = new ColumnReference(columnType);
		this.setDataType(dataType);
		this.setLength(length);
	}
	
	public TableField(String id, String fieldName, ColumnReference columnReference, Types dataType, int[] length) {
		super();
		this.id = id;
		this.fieldName = fieldName;
		this.columnReference = columnReference;
		this.setDataType(dataType);
		this.setLength(length);
	}
	
	public TableField(String id, String fieldName, ColumnReference columnReference, Types dataType) {
		super();
		this.id = id;
		this.fieldName = fieldName;
		this.columnReference = columnReference;
		this.setDataType(dataType);
		this.setLength(new int[]{1,0});
	}
	
	public TableField(String id, String fieldName, Types dataType) {
		super();
		this.id = id;
		this.fieldName = fieldName;
		this.columnReference = new ColumnReference(ColumnType.Undefined);
		this.setDataType(dataType);
		this.setLength(new int[]{1,0});
	}

	public String getId() {
		return id;
	}

	public String getFieldName() {
		return fieldName;
	}

	
	
	
	
	/**
	 * @param columnReference the columnReference to set
	 */
	public void setColumnReference(ColumnReference columnReference) {
		this.columnReference = columnReference;
	}

	/**
	 * @param fieldName the fieldName to set
	 */
	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	
	/**
	 * @return the columnReference
	 */
	public ColumnReference getColumnReference() {
		return columnReference;
	}

	
	
	/**
	 * @return the length
	 */
	public int[] getLength() {
		return length;
	}

	/**
	 * @param length the length to set
	 */
	public void setLength(int[] length) {
		this.length = length;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TableField other = (TableField) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

	public void setDataType(Types dataType) {
		this.dataType = dataType;
	}

	public Types getDataType() {
		return dataType;
	}

	public int compareTo(TableField tablefield) {
		return this.id.compareTo(tablefield.getId());
	}
	
	
	
}
