package org.gcube.contentmanagement.codelistmanager.util.csv;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.csv4j.CSVLineProcessor;

public class InitializerProcessor implements CSVLineProcessor {

	
	private static final Logger logger = LoggerFactory.getLogger(InitializerProcessor.class);
	private boolean tableCreated= false;
	private List<ColumnDefinition> tableDefinition= new ArrayList<ColumnDefinition>();
	private Hashtable<String, TableField> fieldsName;
	private int totalLines = 0;
	
	
	public List<ColumnDefinition> getTableDefinition() {
		return tableDefinition;
	}

	public Hashtable<String, TableField>  getFieldNames() {
		return fieldsName;
	}

	/**
	 * @return the totalLine
	 */
	public int getTotalLines() {
		return totalLines;
	}

	
	
	public void processHeaderLine(int lineNumber, List<String> fields) {
		this.onHeaderLine(lineNumber, fields);
	}

	public void processDataLine(int lineNumber, List<String> fields) {
		this.onDataLine(lineNumber, fields);
	}

	public boolean continueProcessing() {
		return true;
	}

	public void onHeaderLine(int lineNumber, List<String> fields) {
		try{
			ColumnDefinition colDef= DBSession.getImplementation(ColumnDefinition.class);
			colDef.setLabel(Constants.ID_LABEL);
			colDef.setType(new Type(Types.INTEGER,8));
			colDef.setSpecification(Specification.NOT_NULL, Specification.AUTO_INCREMENT); 
			tableDefinition.add(colDef);
			//creating the others fields
			fieldsName =new Hashtable<String, TableField>();			
			for (int i=0; i<fields.size(); i++){
				//logger.debug("the max for field"+(k)+" is "+fields.size());
				ColumnDefinition columnDef= DBSession.getImplementation(ColumnDefinition.class);
				columnDef.setLabel("field"+i);
				columnDef.setType(new Type(Types.STRING,1,0));
				if (fields!=null && fields.get(i)!="") fieldsName.put("field"+i, new TableField("field"+i,  fields.get(i),Types.STRING)); 
				else fieldsName.put("field"+i, new TableField("field"+i, "field"+i, Types.STRING));
				tableDefinition.add(columnDef);
			}
			tableCreated=true;
		}catch (Exception e) {
			logger.error("erorr reading the header line",e);
		}
	}

	
	public void onDataLine(int lineNumber, List<String> fields) {
		try{
			if (!tableCreated){
				ColumnDefinition colDef= DBSession.getImplementation(ColumnDefinition.class);
				colDef.setLabel(Constants.ID_LABEL);
				colDef.setType(new Type(Types.INTEGER,8));
				colDef.setSpecification(Specification.NOT_NULL, Specification.AUTO_INCREMENT); 
				tableDefinition.add(colDef);
				//creating the others fields
				fieldsName=new Hashtable<String, TableField>();
				
				for (int i=0; i<fields.size(); i++){
					//logger.debug("the max for field"+(k)+" is "+fields.size());
					ColumnDefinition columnDef= DBSession.getImplementation(ColumnDefinition.class);
					columnDef.setLabel("field"+i);
					columnDef.setType(new Type(Types.STRING,1,0));
					tableDefinition.add(columnDef);
					fieldsName.put("field"+i,new TableField("field"+i, "field"+i, Types.STRING));
				}
				tableCreated=true;
			}
			
			for (int i=0; i<fields.size(); i++){
				if (fields.get(i).length()>tableDefinition.get(i+1).getType().getPrecisionArray()[0]){
					tableDefinition.get(i+1).getType().getPrecisionArray()[0]= fields.get(i).length();
					fieldsName.get(tableDefinition.get(i+1).getLabel()).getLength()[0] = fields.get(i).length();
				}
				if (ImportUtil.getAfterDotLength(fields.get(i))>tableDefinition.get(i+1).getType().getPrecisionArray()[1]){
					tableDefinition.get(i+1).getType().getPrecisionArray()[1]= ImportUtil.getAfterDotLength(fields.get(i));
					fieldsName.get(tableDefinition.get(i+1).getLabel()).getLength()[1] = ImportUtil.getAfterDotLength(fields.get(i));
				}
			}
			totalLines++;
		}catch (Exception e) {
			logger.error("error reading data line", e);
		}
	}

}
