package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.codelistmanager.entities.TableField.ColumnType;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;
import org.sdmx.resources.sdmxml.schemas.v2_0.common.AnnotationType;
import org.sdmx.resources.sdmxml.schemas.v2_0.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeType;


public class CLSDMXImport extends SDMXImport {

	private final String CODECOLUMN="code";
	private final String PARENTCOLUMN="parent_code";
	
	
	private CodeListType codeList;
	
	public CLSDMXImport(CodeListType codelist) {
		super();
		this.codeList = codelist;
	}


	/**
	 * @return the agencyId
	 */
	public String getAgencyId() {
		return codeList.getAgencyID();
	}

	/**
	 * @return the name
	 */
	public String getName() {
		if (codeList.getNames().size()>0) return codeList.getNames().get(0).getValue();
		else return "undefined";
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		if (codeList.getDescriptions().size()>0) return codeList.getDescriptions().get(0).getValue();
		else return "undefined";
	}
	
	/**
	 * @return the validFrom
	 */
	public String getValidFrom() {
		if (codeList.getValidFrom()!=null) return codeList.getValidFrom();
		else return "undefined";
	}

	/**
	 * @return the validTo
	 */
	public String getValidTo() {
		if (codeList.getValidTo()!=null) return codeList.getValidTo();
		else return "undefined";
	}

	/**
	 * @return the version
	 */
	public float getVersion() {
		if (codeList.getVersion()!=null) return Float.parseFloat(codeList.getVersion());
		else return 0.0f;
	}

	/**
	 * @return the isFinal
	 */
	public boolean isFinal() {
		if(codeList.getIsFinal()==null) return false;
		 else return codeList.getIsFinal();
	}

	
	
	protected List<FieldDefinition> retrieveFieldsDefinition(){
		List<FieldDefinition> fieldsDefinition = new ArrayList<FieldDefinition>();
		for (CodeType code : codeList.getCodes()){
    		if (fieldsDefinition.contains(new FieldDefinition(CODECOLUMN))){
    			FieldDefinition codeDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(CODECOLUMN)));
    			if (code.getValue().length()>codeDef.getLength()[0]) codeDef.setLength(new int[]{code.getValue().length(), codeDef.getLength()[1]});
    			if (ImportUtil.getAfterDotLength(code.getValue())>codeDef.getLength()[1]) codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(code.getValue())});
    		}else
    			fieldsDefinition.add(new FieldDefinition(CODECOLUMN, new int[]{code.getValue().length(),ImportUtil.getAfterDotLength(code.getValue())}, new ColumnReference(ColumnType.Code)));
    		
    		if (code.getParentCode()!= null){
    			if (fieldsDefinition.contains(new FieldDefinition(PARENTCOLUMN))){
        			FieldDefinition codeDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(PARENTCOLUMN)));
        			if (code.getParentCode().length()>codeDef.getLength()[0]) codeDef.setLength(new int[]{code.getParentCode().length(), codeDef.getLength()[1]});
        			if (ImportUtil.getAfterDotLength(code.getParentCode())>codeDef.getLength()[1]) codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(code.getParentCode())});
    			}else
        			fieldsDefinition.add(new FieldDefinition(PARENTCOLUMN, new int[]{code.getParentCode().length(),ImportUtil.getAfterDotLength(code.getParentCode())}, new ColumnReference(ColumnType.ParentCode)));
    		}
    		
			for (TextType description : code.getDescriptions()){
				if (fieldsDefinition.contains(new FieldDefinition(description.getLang()))){
        			FieldDefinition codeDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(description.getLang())));
        			if (description.getValue().length()>codeDef.getLength()[0])
        				codeDef.setLength(new int[]{description.getValue().length(), codeDef.getLength()[1]});
        				
        			if (ImportUtil.getAfterDotLength(description.getValue())>codeDef.getLength()[1]) codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(description.getValue())});
				}else{
        			int descriptionLength= description.getValue().length()>0?description.getValue().length():1;
					fieldsDefinition.add(new FieldDefinition(description.getLang(), new int[]{descriptionLength,ImportUtil.getAfterDotLength(code.getValue())}, new ColumnReference(ColumnType.Description)));
				}
			}
			if (code.getAnnotations()!=null)
				for (AnnotationType annotation :code.getAnnotations().getAnnotations()){
					if (fieldsDefinition.contains(new FieldDefinition(annotation.getAnnotationTitle()))){
	        			FieldDefinition codeDef = fieldsDefinition.get(fieldsDefinition.indexOf(new FieldDefinition(annotation.getAnnotationTitle())));
	        			if (annotation.getAnnotationTexts().size()>0){
	        				if (annotation.getAnnotationTexts().get(0).getValue().length()>codeDef.getLength()[0]) 
	        									codeDef.setLength(new int[]{annotation.getAnnotationTexts().get(0).getValue().length(), codeDef.getLength()[1] });
	        				if (ImportUtil.getAfterDotLength(annotation.getAnnotationTexts().get(0).getValue())>codeDef.getLength()[1])
	        									codeDef.setLength(new int[]{codeDef.getLength()[0], ImportUtil.getAfterDotLength(annotation.getAnnotationTexts().get(0).getValue())});
	        			}
	        		}else
	        			if (annotation.getAnnotationTexts().size()>0){
	        				int annotationLength=annotation.getAnnotationTexts().get(0).getValue().length()>0?annotation.getAnnotationTexts().get(0).getValue().length():1;
	        				fieldsDefinition.add(new FieldDefinition(annotation.getAnnotationTitle(), new int[]{annotationLength,ImportUtil.getAfterDotLength(annotation.getAnnotationTexts().get(0).getValue())},
	        					new ColumnReference(ColumnType.Annotation)));
	        			
	        			}
	        	}
			totalLine++;
		}
		return fieldsDefinition;
	}
	
	
	
	
	@Override
	public void process(SimpleTable table, ProgresChangedEvent event)
			throws Exception {
		Insert insertQuery = DBSession.getImplementation(Insert.class);
		insertQuery.setTable(table);
		DBSession session = DBSession.connect()	;
		session.disableAutoCommit();
		try{

			for (CodeType code : codeList.getCodes()){
				String[] line = new String[this.fieldsDefinition.size()+1];
				line[0] ="DEFAULT";
				Arrays.fill(line, null);
				line[fieldsDefinition.indexOf(new FieldDefinition(CODECOLUMN))+1]= code.getValue();
				if (code.getParentCode()!= null) line[fieldsDefinition.indexOf(new FieldDefinition(PARENTCOLUMN))+1]= code.getParentCode();
				for (TextType description : code.getDescriptions())
					line[fieldsDefinition.indexOf(new FieldDefinition(description.getLang()))+1]=description.getValue();
				if (code.getAnnotations()!=null)
					for (AnnotationType annotation :code.getAnnotations().getAnnotations())
						line[fieldsDefinition.indexOf(new FieldDefinition(annotation.getAnnotationTitle()))+1]=annotation.getAnnotationTexts().size()>0?annotation.getAnnotationTexts().get(0).getValue():null;
								
				insertQuery.setInsertValues((Object[])line);
				insertQuery.execute(session);
				progress++;
				event.onProgresChanged(progress);
			}
			
			session.commit();
		}finally{
			if (session !=null) session.release();
		}
	}

	
}
