package org.gcube.contentmanagement.codelistmanager.util.opensdmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.entities.TableField.ColumnType;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.codelistmanager.util.Constants;
import org.gcube.contentmanagement.codelistmanager.util.ImporterInterface;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;

public abstract class SDMXImport extends ImporterInterface{

	protected int progress=0;
	protected int totalLine=0;
	protected List<ColumnDefinition> tableDefinition= new ArrayList<ColumnDefinition>();
	protected Hashtable<String, TableField > tableFields = new Hashtable<String, TableField >(); 
	protected List<FieldDefinition> fieldsDefinition;
		

	
	public abstract String getAgencyId();
	
	/**
	 * @return the name
	 */
	public abstract String getName();

	/**
	 * @return the description
	 */
	public abstract String getDescription();
	
	/**
	 * @return the validFrom
	 */
	public abstract String getValidFrom();

	/**
	 * @return the validTo
	 */
	public abstract String getValidTo();

	/**
	 * @return the version
	 */
	public abstract float getVersion();

	/**
	 * @return the isFinal
	 */
	public abstract boolean isFinal();
	
	
	@Override
	public int getTotalLines() {
		return totalLine;
	}

	@Override
	public List<ColumnDefinition> getTableDefinition() {
		return tableDefinition;
	}

	@Override
	public Hashtable<String, TableField > getFieldsName() {
		return this.tableFields;
	}

	protected abstract List<FieldDefinition> retrieveFieldsDefinition();
	
	@Override
	public abstract void process(SimpleTable table, ProgresChangedEvent event)
			throws Exception;
	
	@Override
	public void initialize() throws Exception {
		    	
    	 fieldsDefinition = retrieveFieldsDefinition();
    	    	
    	ColumnDefinition colDef= DBSession.getImplementation(ColumnDefinition.class);
		colDef.setLabel(Constants.ID_LABEL);
		colDef.setType(new Type(Types.INTEGER,8));
		colDef.setSpecification(Specification.NOT_NULL, Specification.AUTO_INCREMENT); 
		tableDefinition.add(colDef);
    	
		int i =0;
		for (FieldDefinition fieldDefinition : fieldsDefinition){
			colDef= DBSession.getImplementation(ColumnDefinition.class);
			colDef.setLabel("field"+i);
			colDef.setType(new Type(Types.STRING,fieldDefinition.getLength()));
			tableDefinition.add(colDef);
			tableFields.put("field"+i, new TableField("field"+i, fieldDefinition.getFieldname(), fieldDefinition.getType(), Types.STRING, fieldDefinition.getLength()));
			i++;
		}
    	
	}

	protected class FieldDefinition{
		
		private String fieldname;
		private int[] length;
		private ColumnReference type;
		
		public FieldDefinition(String fieldname) {
			super();
			this.fieldname = fieldname;
			this.length = new int[]{0,0};
			this.type = new ColumnReference(ColumnType.Undefined);
		}
		
		public FieldDefinition(String fieldname, int[] length, ColumnReference type) {
			super();
			this.fieldname = fieldname;
			this.length = length;
			this.type = type;
		}

		
		
		/**
		 * @return the fieldname
		 */
		public String getFieldname() {
			return fieldname;
		}

		/**
		 * @param fieldname the fieldname to set
		 */
		public void setFieldname(String fieldname) {
			this.fieldname = fieldname;
		}

		/**
		 * @return the type
		 */
		public ColumnReference getType() {
			return type;
		}

		/**
		 * @param type the type to set
		 */
		public void setType(ColumnReference type) {
			this.type = type;
		}

		/**
		 * @return the length
		 */
		public int[] getLength() {
			return length;
		}

		/**
		 * @param length the length to set
		 */
		public void setLength(int[] length) {
			this.length = length;
		}

		private SDMXImport getOuterType() {
			return SDMXImport.this;
		}
		
		/* (non-Javadoc)
		 * @see java.lang.Object#hashCode()
		 */
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + getOuterType().hashCode();
			result = prime * result
					+ ((fieldname == null) ? 0 : fieldname.hashCode());
			return result;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#equals(java.lang.Object)
		 */
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			FieldDefinition other = (FieldDefinition) obj;
			if (!getOuterType().equals(other.getOuterType()))
				return false;
			if (fieldname == null) {
				if (other.fieldname != null)
					return false;
			} else if (!fieldname.equals(other.fieldname))
				return false;
			return true;
		}
		
		
	}

}
