/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.servicehelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;

public abstract class PropertiesManager {
    private Properties props = new Properties();
    private Properties defaultProps = new Properties();
    protected Log log = this.getLog();

    protected PropertiesManager() {
        this.log.debug((Object)"Instantiated properties manager.");
        this.setDefaults();
    }

    public void loadFromDir(File configDir) {
        this.log.debug((Object)("Loading properties file from directory" + configDir.getAbsolutePath()));
        File propertiesFile = new File(configDir, this.getConfigFilename());
        this.load(propertiesFile);
        this.log.debug((Object)("done loading properties file from directory" + configDir.getAbsolutePath()));
    }

    private void load(File propertiesFile) {
        this.log.debug((Object)("Reading properties, configuration file is: " + propertiesFile.getAbsolutePath()));
        this.props = new Properties();
        try {
            this.props.load(new FileInputStream(propertiesFile));
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"Cannot find properties file");
        }
        catch (IOException e) {
            this.log.error((Object)"IO Error while reading properties file");
            e.printStackTrace();
        }
        this.log.debug((Object)"Finished Reading properties");
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName, this.getPropertyDefault(propertyName));
    }

    public String getPropertyDefault(String propertyName) {
        return this.defaultProps.getProperty(propertyName);
    }

    public boolean getBooleanProperty(String propertyName) {
        String propertyValue = this.getProperty(propertyName);
        return Boolean.parseBoolean(propertyValue);
    }

    public int getIntegerProperty(String propertyName) {
        String propertyValue = this.getProperty(propertyName);
        return Integer.parseInt(propertyValue);
    }

    public String[] getArrayProperty(String propertyName) {
        String propertyValue = this.getProperty(propertyName);
        propertyValue = propertyValue.replace('[', ' ');
        propertyValue = propertyValue.replace(']', ' ');
        propertyValue = propertyValue.trim();
        String[] values = propertyValue.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public void setPropertyDefault(String propertyName, String value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Setting default value of property " + propertyName + " to " + value));
        }
        this.defaultProps.setProperty(propertyName, value);
    }

    public abstract String getConfigFilename();

    protected abstract Log getLog();

    protected abstract void setDefaults();
}

