/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.servicehelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.naming.Context;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.jndi.JNDIUtils;

public class ConfigUtils {
    public static final String JNDI_SERVICE_CTX_LOOKUP_PREFIX = "java:comp/env/services/";
    public static final String CONFIG_DIRECTORY_VARIABLE_NAME = "/configDir";

    public static File getConfigDir() throws Exception {
        Context ctx = JNDIUtils.initJNDI();
        String lookup = JNDI_SERVICE_CTX_LOOKUP_PREFIX;
        lookup = lookup + ResourceContext.getResourceContext().getService();
        lookup = lookup + CONFIG_DIRECTORY_VARIABLE_NAME;
        String configPath = ContainerConfig.getBaseDirectory() + File.separator + ctx.lookup(lookup) + File.separator;
        File theConfigDir = new File(configPath);
        if (!theConfigDir.exists()) {
            throw new IOException("The specified configuration directory " + configPath + " does not exist!");
        }
        if (!theConfigDir.isDirectory()) {
            throw new IOException("The specified configuration directory " + configPath + " does is not a directory!");
        }
        if (!theConfigDir.canRead()) {
            throw new IOException("The specified configuration directory " + configPath + " cannot be read!");
        }
        return theConfigDir;
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties config = new Properties();
        config.load(new FileInputStream(propertiesFile));
        return config;
    }
}

