/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.calls;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.discovery.DiscoveryException;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.BaseCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ReadManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.calls.WriteManagerCall;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AnyHelper;

public class AdminCalls {
    private static GCUBELog logger = new GCUBEClientLog(AdminCalls.class, new Properties[0]);
    private static ISClient isClient;

    public static List<Future<?>> deleteManagers(String collectionID, URI uri, GCUBEScope scope, GCUBESecurityManager ... manager) throws Exception {
        logger.info((Object)("deleting all collection managers at " + uri + " for collection " + collectionID));
        ArrayList outcome = new ArrayList();
        ReadManagerCall readCall = new ReadManagerCall(collectionID, scope, manager);
        readCall.setEndpointReference(AdminCalls.getManagerEpr(readCall, uri));
        outcome.add(AdminCalls.deleteManager(readCall));
        WriteManagerCall writeCall = new WriteManagerCall(collectionID, scope, manager);
        writeCall.setEndpointReference(AdminCalls.getManagerEpr(writeCall, uri));
        outcome.add(AdminCalls.deleteManager(writeCall));
        return outcome;
    }

    public static List<Future<RPDocument>> deleteAllManagers(String collectionID, GCUBEScope scope, GCUBESecurityManager ... manager) throws DiscoveryException, Exception {
        logger.info((Object)("deleting all collection managers for collection " + collectionID));
        ReadManagerCall readCall = new ReadManagerCall(collectionID, scope, manager);
        List<Future<RPDocument>> outcome = AdminCalls.deleteAllManagersByType(readCall);
        WriteManagerCall writeCall = new WriteManagerCall(collectionID, scope, manager);
        outcome.addAll(AdminCalls.deleteAllManagersByType(writeCall));
        return outcome;
    }

    public static Future<?> deleteManager(final ManagerCall call) throws IllegalArgumentException {
        AdminCalls.checkCollectionIsConfigured(call);
        AdminCalls.checkEndpointIsConfigured(call);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> outcome = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug((Object)("deleting " + call.getPortTypeName() + "s @ " + call.getEndpointReference()));
                if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
                    call.delete();
                }
                return null;
            }
        });
        executor.shutdown();
        return outcome;
    }

    public static List<Future<RPDocument>> deleteAllManagersByType(final ManagerCall call) throws IllegalArgumentException, DiscoveryException {
        AdminCalls.checkCollectionIsConfigured(call);
        logger.info((Object)("deleting all " + call.getPortTypeName() + "s for collection " + call.getCollectionID()));
        List results = null;
        try {
            results = isClient.execute(call.getQuery(), call.getScopeManager().getScope());
        }
        catch (ISException e) {
            throw new DiscoveryException((Throwable)e);
        }
        ArrayList<RPDocument> documents = new ArrayList<RPDocument>();
        for (RPDocument d : results) {
            if (!d.getEndpoint().getAddress().getPath().endsWith(call.getPortTypeName())) continue;
            documents.add(d);
        }
        ArrayList<Future<RPDocument>> output = new ArrayList<Future<RPDocument>>();
        if (documents.size() > 0) {
            EndpointReferenceType currentEpr = call.getEndpointReference();
            ExecutorService executor = Executors.newFixedThreadPool(documents.size());
            for (final RPDocument doc : documents) {
                output.add(executor.submit(new Callable<RPDocument>(){

                    @Override
                    public RPDocument call() throws Exception {
                        call.setEndpointReference(doc.getEndpoint());
                        AdminCalls.deleteManager(call);
                        return doc;
                    }
                }));
            }
            executor.shutdown();
            call.setEndpointReference(currentEpr);
        }
        return output;
    }

    private static EndpointReferenceType getManagerEpr(ManagerCall call, URI uri) throws Exception {
        EndpointReferenceType epr = new EndpointReferenceType();
        epr.setAddress(new AttributedURI("http://" + uri.getHost() + ":" + uri.getPort() + "/wsrf/services/" + call.getPortTypeName()));
        ReferencePropertiesType props = new ReferencePropertiesType();
        SimpleResourceKey key = new SimpleResourceKey(new QName("http://gcube-system.org/namespaces/contentmanagement/contentmanager", "ResourceKey"), (Object)call.getCollectionID());
        AnyHelper.setAny((AnyContentType)props, (SOAPElement)key.toSOAPElement());
        epr.setProperties(props);
        return epr;
    }

    private static void checkCollectionIsConfigured(ManagerCall call) throws IllegalArgumentException {
        if (call.getCollectionID() == null) {
            throw new IllegalArgumentException("the call has no target collection");
        }
    }

    private static void checkEndpointIsConfigured(BaseCall call) throws IllegalArgumentException {
        if (call.getEndpointReference() == null) {
            throw new IllegalArgumentException("the call has no target endpoint");
        }
    }

    static {
        try {
            isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }
}

