/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.protocol;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.contentmanagement.contentmanager.stubs.Path;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicates;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.cms.Handler;
import org.globus.wsrf.encoding.ObjectSerializer;

public class URIs {
    public static final String PROTOCOL = "cms";

    public static void validate(URI uri) throws URISyntaxException {
        if (!PROTOCOL.equals(uri.getScheme()) || uri.getAuthority() == null || uri.getPath() == null || uri.getPath().length() < 2) {
            throw new IllegalArgumentException(new URISyntaxException(uri.toString(), "uri is not a well-formed content URI"));
        }
    }

    public static URI make(String collectionID, String ... identifiers) throws IllegalArgumentException {
        if (collectionID == null || identifiers == null || identifiers.length == 0) {
            throw new IllegalArgumentException("null or empty input");
        }
        StringBuilder path = new StringBuilder();
        for (String id : identifiers) {
            path.append("/" + URIs.encode(id.toString()));
        }
        URI uri = null;
        try {
            uri = new URI(PROTOCOL, URIs.encode(collectionID), path.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("error in generation uri with cms," + URIs.encode(collectionID) + "," + path, e);
        }
        return uri;
    }

    public static String collectionID(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return URIs.decode(uri.getAuthority());
    }

    public static String documentID(URI uri) throws URISyntaxException {
        int index;
        URIs.validate(uri);
        String p = uri.getPath().substring(1);
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return URIs.decode(p.substring(0, (index = p.indexOf("/")) > 0 ? index : p.length()));
    }

    public static String nodeID(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return URIs.decode(uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1));
    }

    public static String[] nodeIDs(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        ArrayList<String> ids = new ArrayList<String>();
        for (String s : uri.getPath().substring(1).split("/")) {
            ids.add(URIs.decode(s));
        }
        return ids.toArray(new String[0]);
    }

    public static URI parentURI(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        String u = uri.getPath();
        return URIs.make(uri.getAuthority(), u.substring(1, u.lastIndexOf("/")).split("/"));
    }

    public static URI documentURI(URI uri) throws URISyntaxException {
        URIs.validate(uri);
        return URIs.make(uri.getAuthority(), URIs.documentID(uri));
    }

    private static String decode(String s) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    private static String encode(String s) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    public static final TreePredicate predicate(URI uri) throws URISyntaxException {
        return Predicates.hasPath(URIs.nodeIDs(uri));
    }

    public static final GenericRecord toRSElement(URI uri) throws URISyntaxException, Exception {
        StringWriter writer = new StringWriter();
        ObjectSerializer.serialize((Writer)writer, (Object)new Path(URIs.nodeIDs(uri)), (QName)Path.getTypeDesc().getXmlType());
        GenericRecord record = new GenericRecord();
        record.setFields(new Field[]{new StringField(writer.toString())});
        return record;
    }

    public static URLConnection connection(URI uri, String scope) throws IOException, URISyntaxException {
        URIs.validate(uri);
        URLConnection connection = uri.toURL().openConnection();
        GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope((String)scope));
        return connection;
    }

    static {
        Handler.activateProtocol();
    }
}

