/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.predicates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.AnyPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Bool;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Calendar;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.CutTreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Date;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Num;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.RID;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Text;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;

@XmlRootElement
@XmlType(propOrder={"label", "predicate", "condition"})
public abstract class EdgePredicate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(type=TreePredicate.class), @XmlElementRef(type=CutTreePredicate.class), @XmlElementRef(type=Num.class), @XmlElementRef(type=Bool.class), @XmlElementRef(type=Text.class), @XmlElementRef(type=Date.class), @XmlElementRef(type=Calendar.class), @XmlElementRef(type=RID.class), @XmlElementRef(type=AnyPredicate.class)})
    private Predicate predicate;
    @XmlElement(name="l")
    private QName label;
    @XmlAttribute(name="cond")
    private boolean condition;

    public void setAsCondition() {
        this.condition = true;
    }

    public void unsetAsCondition() {
        this.condition = false;
    }

    public boolean isCondition() {
        return this.condition;
    }

    EdgePredicate() {
    }

    EdgePredicate(QName l, Predicate p) {
        this.predicate = p;
        this.label = l;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate p) {
        this.predicate = p;
    }

    public QName label() {
        return this.label;
    }

    abstract boolean matches(List<Edge> var1);

    abstract List<Edge> prune(List<Edge> var1) throws Exception;

    protected List<Edge> matchLabels(List<Edge> edges) {
        ArrayList<Edge> matches = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (!Nodes.matches(edge.label(), this.label())) continue;
            matches.add(edge);
        }
        return matches;
    }

    public abstract Range range();

    public String toString() {
        return (this.isCondition() ? "[COND]" : "") + this.getClass().getSimpleName().toLowerCase() + " " + this.label + ":" + this.predicate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition ? 1231 : 1237);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePredicate)) {
            return false;
        }
        EdgePredicate other = (EdgePredicate)obj;
        if (this.condition != other.condition) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate));
    }

    public static class Range {
        int min;
        int max;

        Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean includes(Range other) {
            return this.min <= other.min && this.max >= other.max;
        }
    }
}

