/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.connectors;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspen;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.OccurrencePointSets;
import org.gcube.application.aquamaps.ecomodelling.generators.processing.EnvelopeGenerator;

public class EnvelopeGeneratorInterface {
    double status = 0.0;
    EnvelopeModel model;
    String configPath;

    public EnvelopeGeneratorInterface(EnvelopeModel model, String configPath) {
        this.model = model;
        this.configPath = configPath;
    }

    public double getStatus() {
        return this.status;
    }

    public Hspen reCalculateEnvelope(EngineConfiguration configuration, Hspen previousHspen) {
        Hspen newHspen = null;
        try {
            configuration.setConfigPath(this.configPath);
            configuration.setUseDB(true);
            configuration.setEnvelopeGenerator(this.model);
            EnvelopeGenerator eg = new EnvelopeGenerator(configuration);
            newHspen = eg.calcEnvelopes(previousHspen, configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newHspen;
    }

    public List<Hspen> reCalculateEnvelope(EngineConfiguration configuration, List<Hspen> previousHspenList) {
        ArrayList<Hspen> hspenArray = new ArrayList<Hspen>();
        try {
            int size = previousHspenList.size();
            int i = 0;
            configuration.setConfigPath(this.configPath);
            configuration.setUseDB(true);
            configuration.setEnvelopeGenerator(this.model);
            for (Hspen previousHspen : previousHspenList) {
                hspenArray.add(this.reCalculateEnvelope(configuration, previousHspen));
                this.status = Double.valueOf(i) / Double.valueOf(size);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hspenArray;
    }

    public Hspen reCalculateEnvelope(Hspen previousHspen, OccurrencePointSets occPointLists) {
        Hspen newHspen = null;
        try {
            EngineConfiguration configuration = new EngineConfiguration();
            configuration.setConfigPath(this.configPath);
            configuration.setUseDB(false);
            configuration.setCreateTable(false);
            configuration.setEnvelopeGenerator(this.model);
            EnvelopeGenerator eg = new EnvelopeGenerator(configuration);
            newHspen = eg.calcEnvelopes(previousHspen, occPointLists);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newHspen;
    }
}

