/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg;

import java.util.HashMap;
import org.gcube.application.aquamaps.ecomodelling.generators.abstracts.AbstractGenerationAlgorithm;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class AquamapsAlgorithm
extends AbstractGenerationAlgorithm {
    float avgTime = 0.0f;
    int totalcounter = 0;

    @Override
    public HashMap<String, String> getBoundingBoxInfo(String $paramData_NMostLat, String $paramData_SMostLat, String $paramData_WMostLong, String $paramData_EMostLong, Object[] maxMinLat, String $type) {
        String $southern_hemisphere_adjusted = "n";
        String $northern_hemisphere_adjusted = "n";
        String $pass_NS = "n";
        String $pass_N = "n";
        String $pass_S = "n";
        HashMap<String, String> boundingInfo = new HashMap<String, String>();
        if ($type != null && $type.equals("2050")) {
            double $Wmost = $paramData_WMostLong == null ? -9999.0 : Double.parseDouble($paramData_WMostLong);
            double $Emost = $paramData_EMostLong == null ? -9999.0 : Double.parseDouble($paramData_EMostLong);
            double $n = 0.0;
            if ($paramData_NMostLat != null && $paramData_NMostLat.length() > 0 && $paramData_SMostLat != null && $paramData_SMostLat.length() > 0 && $paramData_WMostLong != null && $paramData_WMostLong.length() > 0 && $paramData_EMostLong != null && $paramData_EMostLong.length() > 0) {
                $paramData_NMostLat = "" + (Double.parseDouble($paramData_NMostLat) + 10.0);
                if (Double.parseDouble($paramData_NMostLat) > 90.0) {
                    $paramData_NMostLat = "90";
                }
                if (Double.parseDouble($paramData_SMostLat = "" + (Double.parseDouble($paramData_SMostLat) - 10.0)) < -90.0) {
                    $paramData_SMostLat = "-90";
                }
                if (!$paramData_WMostLong.equals("-180") || !$paramData_EMostLong.equals("180")) {
                    $paramData_WMostLong = "" + (Double.parseDouble($paramData_WMostLong) - 10.0);
                    if (Double.parseDouble($paramData_WMostLong) < 0.0) {
                        if (Double.parseDouble($paramData_WMostLong) < -180.0) {
                            $n = (Double.parseDouble($paramData_WMostLong) + 180.0) * -1.0;
                            $paramData_WMostLong = "" + (180.0 - $n);
                        }
                    } else if (Double.parseDouble($paramData_WMostLong) > 180.0) {
                        $n = Double.parseDouble($paramData_WMostLong) - 180.0;
                        $paramData_WMostLong = "" + (-180.0 + $n);
                    }
                    if (Double.parseDouble($paramData_EMostLong = "" + (Double.parseDouble($paramData_EMostLong) + 10.0)) < 0.0) {
                        if (Double.parseDouble($paramData_EMostLong) < -180.0) {
                            $n = (Double.parseDouble($paramData_EMostLong) + 180.0) * -1.0;
                            $paramData_EMostLong = "" + (180.0 - $n);
                        }
                    } else if (Double.parseDouble($paramData_EMostLong) > 180.0) {
                        $n = Double.parseDouble($paramData_EMostLong) - 180.0;
                        $paramData_EMostLong = "" + (-180.0 + $n);
                    }
                }
                double $diff = Double.parseDouble($paramData_WMostLong) - Double.parseDouble($paramData_EMostLong);
                if ($Wmost < 0.0 && $Emost < 0.0 && $Wmost >= $Emost && $diff <= 0.0 && $diff >= -20.0) {
                    $paramData_WMostLong = "-180";
                    $paramData_EMostLong = "180";
                }
                if ($Wmost > 0.0 && $Emost > 0.0 && $Wmost >= $Emost && $diff <= 0.0 && $diff >= -20.0) {
                    $paramData_WMostLong = "-180";
                    $paramData_EMostLong = "180";
                }
                if ($Wmost <= -170.0 && $Emost >= 170.0) {
                    $paramData_WMostLong = "-180";
                    $paramData_EMostLong = "180";
                }
                if ($Wmost >= 0.0 && $Wmost <= 10.0 && $Emost <= 0.0 && $Emost >= -10.0) {
                    $paramData_WMostLong = "-180";
                    $paramData_EMostLong = "180";
                }
            }
        }
        if ($paramData_NMostLat == null || $paramData_NMostLat.length() == 0 || $paramData_SMostLat == null || $paramData_SMostLat.length() == 0 || $paramData_WMostLong == null || $paramData_WMostLong.length() == 0 || $paramData_EMostLong == null || $paramData_EMostLong.length() == 0) {
            if ($paramData_NMostLat != null && $paramData_NMostLat.length() > 0 && $paramData_SMostLat != null && $paramData_SMostLat.length() > 0) {
                $pass_NS = "y";
            } else if ($paramData_NMostLat != null && $paramData_NMostLat.length() > 0) {
                $pass_N = "y";
            } else if ($paramData_SMostLat != null && $paramData_SMostLat.length() > 0) {
                $pass_S = "y";
            } else {
                double $maxCLat = 0.0;
                double $minCLat = 0.0;
                try {
                    $maxCLat = Double.parseDouble("" + maxMinLat[0]);
                    $minCLat = Double.parseDouble("" + maxMinLat[1]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if ($minCLat > 10.0) {
                    $paramData_SMostLat = "0";
                    $southern_hemisphere_adjusted = "y";
                } else if ($maxCLat < -10.0) {
                    $paramData_NMostLat = "0";
                    $northern_hemisphere_adjusted = "y";
                }
            }
        }
        boundingInfo.put("$southern_hemisphere_adjusted", $southern_hemisphere_adjusted);
        boundingInfo.put("$northern_hemisphere_adjusted", $northern_hemisphere_adjusted);
        boundingInfo.put("$pass_NS", $pass_NS);
        boundingInfo.put("$pass_N", $pass_N);
        boundingInfo.put("$pass_S", $pass_S);
        boundingInfo.put("$paramData_NMostLat", $paramData_NMostLat);
        boundingInfo.put("$paramData_SMostLat", $paramData_SMostLat);
        boundingInfo.put("$paramData_WMostLong", $paramData_WMostLong);
        boundingInfo.put("$paramData_EMostLong", $paramData_EMostLong);
        return boundingInfo;
    }

    @Override
    public HashMap<String, Integer> calculateBoundingBox(String csquarecode, String $pass_NS, String $pass_N, String $pass_S, String $CenterLat, String $CenterLong, String $FAOAreaM, String $paramData_NMostLat, String $paramData_SMostLat, String $paramData_WMostLong, String $paramData_EMostLong, String $paramData_FAOAreas, String $northern_hemisphere_adjusted, String $southern_hemisphere_adjusted) {
        int $InFAO = 0;
        int $InBox = 0;
        String $tmpstr = "";
        HashMap<String, Integer> AreaInfo = new HashMap<String, Integer>();
        if ($pass_NS.equals("y")) {
            if (Double.parseDouble($CenterLat) >= Double.parseDouble($paramData_SMostLat) && Double.parseDouble($CenterLat) <= Double.parseDouble($paramData_NMostLat)) {
                $InBox = 1;
            }
        } else if ($pass_N.equals("y")) {
            if (Double.parseDouble($CenterLat) <= Double.parseDouble($paramData_NMostLat)) {
                $InBox = 1;
            }
        } else if ($pass_S.equals("y")) {
            if (Double.parseDouble($CenterLat) >= Double.parseDouble($paramData_SMostLat)) {
                $InBox = 1;
            }
        } else if ($southern_hemisphere_adjusted.equals("y")) {
            if (Double.parseDouble($CenterLat) > 0.0) {
                $InBox = 1;
            }
        } else if ($northern_hemisphere_adjusted.equals("y")) {
            if (Double.parseDouble($CenterLat) < 0.0) {
                $InBox = 1;
            }
        } else {
            $InBox = 0;
        }
        if ($paramData_NMostLat != null && $paramData_NMostLat.length() > 0 && $paramData_SMostLat != null && $paramData_SMostLat.length() > 0 && $paramData_WMostLong != null && $paramData_WMostLong.length() > 0 && $paramData_EMostLong != null && $paramData_EMostLong.length() > 0) {
            boolean $InLong = Double.parseDouble($paramData_WMostLong) > Double.parseDouble($paramData_EMostLong) ? !(Double.parseDouble($CenterLong) >= Double.parseDouble($paramData_EMostLong)) || !(Double.parseDouble($CenterLong) <= Double.parseDouble($paramData_WMostLong)) : Double.parseDouble($CenterLong) >= Double.parseDouble($paramData_WMostLong) && Double.parseDouble($CenterLong) <= Double.parseDouble($paramData_EMostLong);
            $InBox = Double.parseDouble($CenterLat) >= Double.parseDouble($paramData_SMostLat) && Double.parseDouble($CenterLat) <= Double.parseDouble($paramData_NMostLat) && $InLong ? 1 : 0;
        }
        if ($FAOAreaM == null || $FAOAreaM.length() == 0) {
            $InFAO = 0;
        } else {
            $tmpstr = $FAOAreaM;
            $InFAO = $paramData_FAOAreas != null && $paramData_FAOAreas.contains($tmpstr) ? 1 : 0;
        }
        AreaInfo.put("$InBox", $InBox);
        AreaInfo.put("$InFAO", $InFAO);
        return AreaInfo;
    }

    private boolean inside(String searched, String containing) {
        if (containing != null) {
            return containing.contains(searched);
        }
        return false;
    }

    @Override
    public String procFAO_2050(String $temp) {
        if ((this.inside("41", $temp) || this.inside("47", $temp)) && !this.inside("48", $temp)) {
            $temp = $temp + ", 48";
        }
        if ((this.inside("51", $temp) || this.inside("57", $temp)) && !this.inside("58", $temp)) {
            $temp = $temp + ", 58";
        }
        if ((this.inside("81", $temp) || this.inside("87", $temp)) && !this.inside("88", $temp)) {
            $temp = $temp + ", 88";
        }
        if (this.inside("67", $temp) && !this.inside("18", $temp)) {
            $temp = $temp + ", 18";
        }
        if (this.inside("31", $temp)) {
            if (!this.inside("21", $temp)) {
                $temp = $temp + ", 21";
            }
            if (!this.inside("41", $temp)) {
                $temp = $temp + ", 41";
            }
        }
        if (this.inside("34", $temp)) {
            if (!this.inside("27", $temp)) {
                $temp = $temp + ", 27";
            }
            if (!this.inside("47", $temp)) {
                $temp = $temp + ", 47";
            }
        }
        if (this.inside("71", $temp)) {
            if (!this.inside("61", $temp)) {
                $temp = $temp + ", 61";
            }
            if (!this.inside("81", $temp)) {
                $temp = $temp + ", 81";
            }
        }
        if (this.inside("77", $temp)) {
            if (!this.inside("67", $temp)) {
                $temp = $temp + ", 67";
            }
            if (!this.inside("87", $temp)) {
                $temp = $temp + ", 87";
            }
        }
        return $temp;
    }

    @Override
    public double getSpeciesProb(Object[] speciesResults, Object[] csquarecodeInfo) {
        String depthmin = AquamapsAlgorithm.getElement(speciesResults, 0);
        int depthmean = 0;
        try {
            depthmean = Integer.parseInt("" + speciesResults[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        String depthprefmin = AquamapsAlgorithm.getElement(speciesResults, 2);
        String pelagic = AquamapsAlgorithm.getElement(speciesResults, 3);
        String depthprefmax = AquamapsAlgorithm.getElement(speciesResults, 4);
        String depthmax = AquamapsAlgorithm.getElement(speciesResults, 5);
        String tempmin = AquamapsAlgorithm.getElement(speciesResults, 6);
        String layer = AquamapsAlgorithm.getElement(speciesResults, 7);
        String tempprefmin = AquamapsAlgorithm.getElement(speciesResults, 8);
        String tempprefmax = AquamapsAlgorithm.getElement(speciesResults, 9);
        String tempmax = AquamapsAlgorithm.getElement(speciesResults, 10);
        String salinitymin = AquamapsAlgorithm.getElement(speciesResults, 11);
        String salinityprefmin = AquamapsAlgorithm.getElement(speciesResults, 12);
        String salinityprefmax = AquamapsAlgorithm.getElement(speciesResults, 13);
        String salinitymax = AquamapsAlgorithm.getElement(speciesResults, 14);
        String primprodmin = AquamapsAlgorithm.getElement(speciesResults, 15);
        String primprodprefmin = AquamapsAlgorithm.getElement(speciesResults, 16);
        String primprodprefmax = AquamapsAlgorithm.getElement(speciesResults, 17);
        String primprodmax = AquamapsAlgorithm.getElement(speciesResults, 18);
        String iceconmin = AquamapsAlgorithm.getElement(speciesResults, 19);
        String iceconprefmin = AquamapsAlgorithm.getElement(speciesResults, 20);
        String iceconprefmax = AquamapsAlgorithm.getElement(speciesResults, 21);
        String iceconmax = AquamapsAlgorithm.getElement(speciesResults, 22);
        String landdistyn = AquamapsAlgorithm.getElement(speciesResults, 23);
        String landdistmin = AquamapsAlgorithm.getElement(speciesResults, 24);
        String landdistprefmin = AquamapsAlgorithm.getElement(speciesResults, 25);
        String landdistprefmax = AquamapsAlgorithm.getElement(speciesResults, 26);
        String landdistmax = AquamapsAlgorithm.getElement(speciesResults, 27);
        String csquarecode = AquamapsAlgorithm.getElement(csquarecodeInfo, 0);
        double depthmeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 1);
        double depthmaxcsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 2);
        double depthmincsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 3);
        double sstanmeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 4);
        double sbtanmeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 5);
        double salinitymeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 6);
        double salinitybmeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 7);
        double primprodmeancsquare = AquamapsAlgorithm.getNumber(csquarecodeInfo, 8);
        String iceconanncsquare = csquarecodeInfo[9] == null ? "" : "" + csquarecodeInfo[9];
        double landdist = AquamapsAlgorithm.getNumber(csquarecodeInfo, 10);
        String vprovider = "";
        vprovider = depthmean == 1 ? "MM" : "suitable";
        double prob = 0.0;
        try {
            prob = this.calcProb(depthmin, depthmean, depthmeancsquare, depthmaxcsquare, depthmincsquare, depthprefmin, pelagic, vprovider, depthprefmax, depthmax, tempmin, layer, sstanmeancsquare, sbtanmeancsquare, tempprefmin, tempprefmax, tempmax, salinitymin, salinitymeancsquare, salinitybmeancsquare, salinityprefmin, salinityprefmax, salinitymax, primprodmin, primprodmeancsquare, primprodprefmin, primprodprefmax, primprodmax, iceconmin, iceconanncsquare, iceconprefmin, iceconprefmax, iceconmax, landdistyn, landdist, landdistmin, landdistprefmin, landdistprefmax, landdistmax);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Impossible to calculate probability: inconsistent values in the hcaf or hspen");
        }
        return prob;
    }

    public double calcProb(String $paramData_DepthMin, int $paramData_MeanDepth, double $DepthMean, double $DepthMax, double $DepthMin, String $paramData_DepthPrefMin, String $paramData_Pelagic, String $vprovider, String $paramData_DepthPrefMax, String $paramData_DepthMax, String $paramData_SSTMin, String $paramData_layer, double $SSTAnMean, double $SBTAnMean, String $paramData_SSTPrefMin, String $paramData_SSTPrefMax, String $paramData_SSTMax, String $paramData_SalinityMin, double $SalinityMean, double $SalinityBMean, String $paramData_SalinityPrefMin, String $paramData_SalinityPrefMax, String $paramData_SalinityMax, String $paramData_PrimProdMin, double $PrimProdMean, String $paramData_PrimProdPrefMin, String $paramData_PrimProdPrefMax, String $paramData_PrimProdMax, String $paramData_IceConMin, String $IceConAnn, String $paramData_IceConPrefMin, String $paramData_IceConPrefMax, String $paramData_IceConMax, String $paramData_LandDistYN, double $LandDist, String $paramData_LandDistMin, String $paramData_LandDistPrefMin, String $paramData_LandDistPrefMax, String $paramData_LandDistMax) {
        Double dparamData_DepthMin = null;
        Double dparamData_DepthPrefMin = null;
        Double dparamData_DepthPrefMax = null;
        Double dparamData_DepthMax = null;
        Double dparamData_SSTMin = null;
        Double dparamData_SSTPrefMin = null;
        Double dparamData_SSTMax = null;
        Double dparamData_SSTPrefMax = null;
        Double dparamData_SalinityMin = null;
        Double dparamData_SalinityPrefMin = null;
        Double dparamData_SalinityPrefMax = null;
        Double dparamData_SalinityMax = null;
        Double dparamData_PrimProdMax = null;
        Double dparamData_PrimProdPrefMax = null;
        Double dparamData_PrimProdPrefMin = null;
        Double dparamData_PrimProdMin = null;
        Double dparamData_IceConMax = null;
        Double dparamData_IceConPrefMax = null;
        Double dparamData_IceConPrefMin = null;
        Double dparamData_IceConMin = null;
        Double dIceConAnn = null;
        Double dparamData_LandDistMax = null;
        Double dparamData_LandDistPrefMax = null;
        Double dparamData_LandDistPrefMin = null;
        Double dparamData_LandDistMin = null;
        try {
            dparamData_DepthMin = Double.parseDouble($paramData_DepthMin);
            dparamData_DepthPrefMin = Double.parseDouble($paramData_DepthPrefMin);
            dparamData_DepthPrefMax = Double.parseDouble($paramData_DepthPrefMax);
            dparamData_DepthMax = Double.parseDouble($paramData_DepthMax);
            dparamData_SSTMin = Double.parseDouble($paramData_SSTMin);
            dparamData_SSTPrefMin = Double.parseDouble($paramData_SSTPrefMin);
            dparamData_SSTMax = Double.parseDouble($paramData_SSTMax);
            dparamData_SSTPrefMax = Double.parseDouble($paramData_SSTPrefMax);
            dparamData_SalinityMin = Double.parseDouble($paramData_SalinityMin);
            dparamData_SalinityPrefMin = Double.parseDouble($paramData_SalinityPrefMin);
            dparamData_SalinityPrefMax = Double.parseDouble($paramData_SalinityPrefMax);
            dparamData_SalinityMax = Double.parseDouble($paramData_SalinityMax);
            dparamData_PrimProdMax = Double.parseDouble($paramData_PrimProdMax);
            dparamData_PrimProdPrefMax = Double.parseDouble($paramData_PrimProdPrefMax);
            dparamData_PrimProdPrefMin = Double.parseDouble($paramData_PrimProdPrefMin);
            dparamData_PrimProdMin = Double.parseDouble($paramData_PrimProdMin);
            dparamData_IceConMax = Double.parseDouble($paramData_IceConMax);
            dparamData_IceConPrefMax = Double.parseDouble($paramData_IceConPrefMax);
            dparamData_IceConPrefMin = Double.parseDouble($paramData_IceConPrefMin);
            dparamData_IceConMin = Double.parseDouble($paramData_IceConMin);
            dIceConAnn = Double.parseDouble($IceConAnn);
            dparamData_LandDistMax = Double.parseDouble($paramData_LandDistMax);
            dparamData_LandDistPrefMax = Double.parseDouble($paramData_LandDistPrefMax);
            dparamData_LandDistPrefMin = Double.parseDouble($paramData_LandDistPrefMin);
            dparamData_LandDistMin = Double.parseDouble($paramData_LandDistMin);
        }
        catch (Exception ex) {
            // empty catch block
        }
        double $pDepth = 0.0;
        double $pSST = 0.0;
        double $pSalin = 0.0;
        double $pIce = 0.0;
        double $pLand = 0.0;
        double $pPProd = 0.0;
        double $pTotal = 0.0;
        double $paramfld = 0.0;
        double $paramfld1 = 0.0;
        if ($paramData_DepthMin == null) {
            $pDepth = 1.0;
        } else {
            if ($paramData_MeanDepth == 1) {
                $paramfld = $DepthMean;
                $paramfld1 = $DepthMean;
            } else {
                $paramfld = $DepthMax;
                $paramfld1 = $DepthMin;
            }
            $pDepth = -1.0;
            if ($paramfld == -9999.0 || $paramData_DepthMin.equals("")) {
                $pDepth = 1.0;
            } else if ($paramData_DepthMin.equals("") || $paramfld < dparamData_DepthMin) {
                $pDepth = 0.0;
            } else if ($paramfld < dparamData_DepthPrefMin && $paramfld >= dparamData_DepthMin) {
                $pDepth = ($paramfld - dparamData_DepthMin) / (dparamData_DepthPrefMin - dparamData_DepthMin);
            } else if (Integer.parseInt($paramData_Pelagic) != 0 && !$vprovider.equals("MM")) {
                $pDepth = 1.0;
            } else if ($paramfld >= dparamData_DepthPrefMin && $paramfld1 <= dparamData_DepthPrefMax) {
                $pDepth = 1.0;
            } else if (!$paramData_DepthPrefMax.equals("")) {
                if ($paramfld1 >= dparamData_DepthPrefMax) {
                    $pDepth = dparamData_DepthMax - dparamData_DepthPrefMax != 0.0 ? (dparamData_DepthMax - $paramfld1) / (dparamData_DepthMax - dparamData_DepthPrefMax) : 0.0;
                    $pDepth = dparamData_DepthMax - dparamData_DepthPrefMax != 0.0 ? (dparamData_DepthMax - $paramfld1) / (dparamData_DepthMax - dparamData_DepthPrefMax) : 0.0;
                    if ($pDepth < 0.0) {
                        $pDepth = 0.0;
                    }
                } else {
                    $pDepth = 0.0;
                }
            } else {
                $pDepth = 0.0;
            }
        }
        if ($paramData_SSTMin == null) {
            $pSST = 1.0;
        } else {
            if ($paramData_layer.equals("s")) {
                $paramfld = $SSTAnMean;
            } else if ($paramData_layer.equals("b")) {
                $paramfld = $SBTAnMean;
            }
            $pSST = $paramfld == -9999.0 || $paramData_SSTMin.equals("") ? 1.0 : ($paramfld < dparamData_SSTMin ? 0.0 : ($paramfld >= dparamData_SSTMin && $paramfld < dparamData_SSTPrefMin ? ($paramfld - dparamData_SSTMin) / (dparamData_SSTPrefMin - dparamData_SSTMin) : ($paramfld >= dparamData_SSTPrefMin && $paramfld <= dparamData_SSTPrefMax ? 1.0 : ($paramfld > dparamData_SSTPrefMax && $paramfld <= dparamData_SSTMax ? (dparamData_SSTMax - $paramfld) / (dparamData_SSTMax - dparamData_SSTPrefMax) : 0.0))));
        }
        if ($paramData_SalinityMin == null) {
            $pSalin = 1.0;
        } else {
            if ($paramData_layer.equals("s")) {
                $paramfld = $SalinityMean;
            } else if ($paramData_layer.equals("b")) {
                $paramfld = $SalinityBMean;
            }
            $pSalin = $paramfld == -9999.0 || $paramData_SalinityMin.equals("") ? 1.0 : ($paramfld < dparamData_SalinityMin ? 0.0 : ($paramfld >= dparamData_SalinityMin && $paramfld < dparamData_SalinityPrefMin ? ($paramfld - dparamData_SalinityMin) / (dparamData_SalinityPrefMin - dparamData_SalinityMin) : ($paramfld >= dparamData_SalinityPrefMin && $paramfld <= dparamData_SalinityPrefMax ? 1.0 : ($paramfld > dparamData_SalinityPrefMax && $paramfld <= dparamData_SalinityMax ? (dparamData_SalinityMax - $paramfld) / (dparamData_SalinityMax - dparamData_SalinityPrefMax) : 0.0))));
        }
        $pPProd = $paramData_PrimProdMin == null ? 1.0 : ($PrimProdMean == -9999.0 ? 1.0 : ($PrimProdMean < dparamData_PrimProdMin ? 0.0 : ($PrimProdMean >= dparamData_PrimProdMin && $PrimProdMean < dparamData_PrimProdPrefMin ? ($PrimProdMean - dparamData_PrimProdMin) / (dparamData_PrimProdPrefMin - dparamData_PrimProdMin) : ($PrimProdMean >= dparamData_PrimProdPrefMin && $PrimProdMean <= dparamData_PrimProdPrefMax ? 1.0 : ($PrimProdMean > dparamData_PrimProdPrefMax && $PrimProdMean <= dparamData_PrimProdMax ? (dparamData_PrimProdMax - $PrimProdMean) / (dparamData_PrimProdMax - dparamData_PrimProdPrefMax) : 0.0)))));
        if ($paramData_IceConMin == null || $paramData_IceConMin.length() == 0) {
            $pIce = 1.0;
        } else if ($IceConAnn == null || $IceConAnn.length() == 0) {
            $pIce = 1.0;
        } else if (!$IceConAnn.equals("")) {
            if (dIceConAnn < dparamData_IceConMin) {
                $pIce = 0.0;
                boolean $flgIceProbMultiplicationAlgorithm = false;
            } else if (dIceConAnn >= dparamData_IceConMin && dIceConAnn < dparamData_IceConPrefMin) {
                $pIce = (dIceConAnn - dparamData_IceConMin) / (dparamData_IceConPrefMin - dparamData_IceConMin);
                boolean $flgIceProbMultiplicationAlgorithm = false;
            } else if (dIceConAnn >= dparamData_IceConPrefMin && dIceConAnn <= dparamData_IceConPrefMax) {
                $pIce = 1.0;
                boolean $flgIceProbMultiplicationAlgorithm = true;
            } else if (dIceConAnn > dparamData_IceConPrefMax && dIceConAnn <= dparamData_IceConMax) {
                $pIce = (dparamData_IceConMax - dIceConAnn) / (dparamData_IceConMax - dparamData_IceConPrefMax);
                boolean $flgIceProbMultiplicationAlgorithm = true;
            } else if (dIceConAnn > dparamData_IceConMax) {
                $pIce = 0.0;
                boolean $flgIceProbMultiplicationAlgorithm = true;
            }
        }
        if (Integer.parseInt($paramData_LandDistYN) == 0) {
            $pLand = 1.0;
        } else {
            $pLand = 0.0;
            $pLand = $LandDist == -9999.0 || $paramData_LandDistMin.equals("") ? 1.0 : ($LandDist < dparamData_LandDistMin ? 0.0 : ($LandDist >= dparamData_LandDistMin && $LandDist < dparamData_LandDistPrefMin ? ($LandDist - dparamData_LandDistMin) / (dparamData_LandDistPrefMin - dparamData_LandDistMin) : (dparamData_LandDistPrefMax > 1000.0 ? 1.0 : ($LandDist >= dparamData_LandDistPrefMin && $LandDist <= dparamData_LandDistPrefMax ? 1.0 : ($LandDist > dparamData_LandDistPrefMax && $LandDist <= dparamData_LandDistMax ? (dparamData_LandDistMax - $LandDist) / (dparamData_LandDistMax - dparamData_LandDistPrefMax) : 0.0)))));
        }
        $pTotal = $pSST * $pDepth * $pSalin * $pLand * $pPProd * $pIce;
        return $pTotal;
    }
}

