/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg.envelopes;

import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg.AquamapsEnvelopeAlgorithm;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeName;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.subconnectors.Envelope;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;

public class AquamapsEnvelope {
    public Double Min;
    public Double PMin;
    public Double Max;
    public Double PMax;
    public static final double $TempUpper = 30.0;
    public static final double $TempLower = -2.0;
    public static final double $SalinUpper = 40.2;
    public static final double $SalinLower = 3.56;
    public static final double $ProdUpper = 6000.0;
    public static final double $ProdLower = 0.0;
    public static final double $LandUpper = 4200.0;
    public static final double $LandLower = 0.0;
    public static final double $SalinBUpper = 40.9;
    public static final double $SalinBLower = 3.5;
    private float toleranceThr = 0.015f;

    public static int round(double $n) {
        $n = (double)Math.round($n * 100.0) / 100.0;
        String $nstr = "" + $n;
        int $dec_pos = $nstr.indexOf(46);
        int $final = 0;
        String $left_char = "";
        String $right_char = "";
        if ($dec_pos > 0) {
            $left_char = $nstr.substring($dec_pos - 1, $dec_pos);
            $right_char = $nstr.substring($dec_pos + 1, $dec_pos + 2);
        }
        $final = $right_char.equals("5") ? ($left_char.equals("0") || $left_char.equals("2") || $left_char.equals("4") || $left_char.equals("6") || $left_char.equals("8") ? (int)Math.round($n) - 1 : (int)Math.round($n)) : (int)Math.round($n);
        return $final;
    }

    public void calculatePercentiles(List<Object> speciesOccurrences, Double $Uppermost, Double $Lowermost) {
        int position = 2;
        int $reccount = speciesOccurrences.size();
        int $Rec25 = AquamapsEnvelope.round(25.0f * ((float)$reccount + 1.0f) / 100.0f) - 1;
        int $Rec75 = AquamapsEnvelope.round(75.0f * ((float)$reccount + 1.0f) / 100.0f) - 1;
        int $Rec10 = 0;
        int $Rec90 = 0;
        if ($reccount >= 10 && $reccount <= 13) {
            $Rec10 = AquamapsEnvelope.round(10.0f * ((float)$reccount + 1.0f) / 100.0f);
            $Rec90 = AquamapsEnvelope.round(90.0f * ((float)$reccount + 1.0f) / 100.0f) - 2;
        } else {
            $Rec10 = AquamapsEnvelope.round(10.0f * ((float)$reccount + 1.0f) / 100.0f) - 1;
            $Rec90 = AquamapsEnvelope.round(90.0f * ((float)$reccount + 1.0f) / 100.0f) - 1;
        }
        Object[] $row2 = (Object[])speciesOccurrences.get(0);
        double $Min = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        $row2 = (Object[])speciesOccurrences.get($reccount - 1);
        double $Max = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        $row2 = (Object[])speciesOccurrences.get($Rec25);
        double $25 = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        $row2 = (Object[])speciesOccurrences.get($Rec75);
        double $75 = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        $row2 = (Object[])speciesOccurrences.get($Rec10);
        double $PMin = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        $row2 = (Object[])speciesOccurrences.get($Rec90);
        double $PMax = AquamapsEnvelopeAlgorithm.getNumber($row2, position);
        if ($Uppermost != null && $Lowermost != null) {
            double $InterQuartile = Math.abs($25 - $75);
            double $ParaAdjMax = $75 + Double.valueOf(1.5) * $InterQuartile;
            double $ParaAdjMin = $25 - Double.valueOf(1.5) * $InterQuartile;
            if ($ParaAdjMax < $Uppermost && $ParaAdjMax > $Max) {
                $Max = $ParaAdjMax;
            }
            if ($ParaAdjMin > $Lowermost && $ParaAdjMin < $Min) {
                $Min = $ParaAdjMin;
            }
        }
        this.Min = $Min;
        this.Max = $Max;
        this.PMin = $PMin;
        this.PMax = $PMax;
    }

    private static double relativeError(double realvalue, double calculatedvalue) {
        double absoluteError = Math.abs(realvalue - calculatedvalue);
        double relativeErr = 0.0;
        double denominator = 1.0;
        if (realvalue != 0.0) {
            denominator = realvalue;
        }
        if (realvalue != 0.0 || absoluteError != 0.0) {
            relativeErr = absoluteError / denominator;
        }
        return Math.abs(relativeErr);
    }

    public boolean checkPrevious(Double prevMin, Double prevMax, Double prevPMin, Double prevPMax) {
        try {
            return AquamapsEnvelope.relativeError(prevMin, this.Min) < (double)this.toleranceThr && AquamapsEnvelope.relativeError(prevMax, this.Max) < (double)this.toleranceThr && AquamapsEnvelope.relativeError(prevPMin, this.PMin) < (double)this.toleranceThr && AquamapsEnvelope.relativeError(prevPMax, this.PMax) < (double)this.toleranceThr;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Envelope toEnvelope(EnvelopeName name) {
        this.Min = this.Min == null ? null : Double.valueOf(MathFunctions.roundDecimal((double)this.Min, (int)2));
        this.PMin = this.PMin == null ? null : Double.valueOf(MathFunctions.roundDecimal((double)this.PMin, (int)2));
        this.PMax = this.PMax == null ? null : Double.valueOf(MathFunctions.roundDecimal((double)this.PMax, (int)2));
        this.Max = this.Max == null ? null : Double.valueOf(MathFunctions.roundDecimal((double)this.Max, (int)2));
        Envelope env = new Envelope("" + this.Min, "" + this.PMin, "" + this.PMax, "" + this.Max);
        env.setName(name);
        return env;
    }
}

