/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.connectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.BoundingBoxInformation;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.GenerationModel;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hcaf;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspec;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.Hspen;
import org.gcube.application.aquamaps.ecomodelling.generators.processing.DistributionGenerator;

public class DistributionGeneratorInterface {
    double status = 0.0;
    GenerationModel model;
    String configPath;
    boolean overallComputation;

    public DistributionGeneratorInterface(GenerationModel model, String configPath) {
        this.model = model;
        this.configPath = configPath;
        this.overallComputation = false;
    }

    public double getStatus() {
        return this.status;
    }

    public BoundingBoxInformation getBoudingBox(Hcaf hcaf, Hspen hspen, boolean gen2050) throws Exception {
        BoundingBoxInformation bbi = new BoundingBoxInformation();
        EngineConfiguration e = new EngineConfiguration();
        e.setGenerator(this.model);
        e.setUseDB(false);
        e.setType2050(gen2050);
        e.setConfigPath(this.configPath);
        DistributionGenerator generator = new DistributionGenerator(e);
        Object[] hspenArray = hspen.toObjectArray();
        Object[] latitudeExtent = hspen.latitudeExtent();
        Object[] hcafArray = hcaf.toObjectArray();
        generator.getBoundingBoxInformation(hspenArray, latitudeExtent);
        HashMap<String, Integer> boundingInfo = generator.calculateBoundingBox(hcafArray);
        Integer Inbox = boundingInfo.get("$InBox");
        Integer InFAO = boundingInfo.get("$InFAO");
        bbi.setInBoundingBox(Inbox == 1);
        bbi.setInFaoArea(InFAO == 1);
        return bbi;
    }

    public double computeProbability(Hcaf hcaf, Hspen hspen) throws Exception {
        double probability = Double.MIN_VALUE;
        EngineConfiguration e = new EngineConfiguration();
        e.setGenerator(this.model);
        e.setUseDB(false);
        e.setConfigPath(this.configPath);
        DistributionGenerator generator = new DistributionGenerator(e);
        Object[] hspenArray = hspen.toObjectArray();
        Object[] hcafArray = hcaf.toObjectArray();
        probability = generator.calculateModelProbability(hspenArray, hcafArray);
        return probability;
    }

    public List<Hspec> compute(List<Hcaf> hcaflist, Hspen hspen) throws Exception {
        if (!this.overallComputation) {
            this.status = 0.0;
        }
        double probability = Double.MIN_VALUE;
        EngineConfiguration e = new EngineConfiguration();
        e.setGenerator(this.model);
        e.setUseDB(false);
        e.setConfigPath(this.configPath);
        DistributionGenerator generator = new DistributionGenerator(e);
        Object[] hspenArray = hspen.toObjectArray();
        Object[] latitudeExtent = hspen.latitudeExtent();
        generator.getBoundingBoxInformation(hspenArray, latitudeExtent);
        ArrayList<Hspec> hspecList = new ArrayList<Hspec>();
        int size = hcaflist.size();
        int counter = 0;
        for (Hcaf hcaf : hcaflist) {
            Object[] hcafArray = hcaf.toObjectArray();
            probability = generator.calculateModelProbability(hspenArray, hcafArray);
            BoundingBoxInformation bbi = new BoundingBoxInformation();
            HashMap<String, Integer> boundingInfo = generator.calculateBoundingBox(hcafArray);
            Integer Inbox = boundingInfo.get("$InBox");
            Integer InFAO = boundingInfo.get("$InFAO");
            bbi.setInBoundingBox(Inbox == 1);
            bbi.setInFaoArea(InFAO == 1);
            Hspec hspec = new Hspec();
            hspec.setBoundingBox(bbi);
            hspec.setProbability(probability);
            hspec.setCsquareCode(hcaf.getCsquarecode());
            hspec.setSpeciesID(hspen.getSpeciesID());
            hspec.setFaoaream(hcaf.getFaoaream());
            hspec.setEezall(hcaf.getEezall());
            hspec.setLme(hcaf.getLme());
            hspecList.add(hspec);
            ++counter;
            if (this.overallComputation) continue;
            this.status = (double)((int)((double)counter * 100.0 / (double)size * 100.0)) / 100.0;
        }
        if (!this.overallComputation) {
            this.status = 100.0;
        }
        return hspecList;
    }

    public HashMap<String, List<Hspec>> compute(List<Hcaf> hcaflist, List<Hspen> hspenlist) throws Exception {
        this.overallComputation = true;
        HashMap<String, List<Hspec>> HspecMap = new HashMap<String, List<Hspec>>();
        this.status = 0.0;
        int size = hspenlist.size();
        int counter = 0;
        for (Hspen hspen : hspenlist) {
            List<Hspec> hspeclist = this.compute(hcaflist, hspen);
            HspecMap.put(hspen.getSpeciesID(), hspeclist);
            this.status = (double)((int)((double)(++counter) * 100.0 / (double)size * 100.0)) / 100.0;
        }
        this.status = 100.0;
        this.overallComputation = false;
        return HspecMap;
    }
}

