/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.aquamapsorg;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.EnvelopeModel;
import org.gcube.application.aquamaps.ecomodelling.generators.utils.DatabaseFactory;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.hibernate.SessionFactory;

public class MaxMinGenerator {
    String selectionQuery = "SELECT DISTINCT Max(hcaf_s.CenterLat) AS maxCLat, Min(hcaf_s.CenterLat) AS minCLat,speciesid FROM occurrencecells INNER JOIN hcaf_s ON occurrencecells.CsquareCode = hcaf_s.CsquareCode WHERE (((hcaf_s.oceanarea > 0))) AND occurrencecells.SpeciesID in (%1$s) AND occurrencecells.GoodCell <> 0 group by speciesid; ";
    String insertionQuery = "insert into maxminlat_%4$s values ('%1$s','%2$s','%3$s'); ";
    String creationQuery = "CREATE TABLE %1$s(  speciesid character varying,  maxclat real,  minclat real) WITH (  OIDS=FALSE)";
    SessionFactory vreConnection;
    List<Object> selectedSpecies;
    String SpeciesListQuery = "select distinct s.speciesid from %1$s s;";
    String CheckListQuery = "select speciesid from maxminlat where speciesid = '%1$s';";
    String vreDatabaseConfig = "DestinationDBHibernate.cfg.xml";
    int counter = 0;
    StringBuffer buffer = new StringBuffer();
    private double status = 0.0;

    private boolean checkElement(String speciesid) {
        List<Object> maxMin = DatabaseFactory.executeSQLQuery(String.format(this.CheckListQuery, speciesid), this.vreConnection);
        return maxMin != null && maxMin.size() > 0;
    }

    public void checkAllElements() {
        int i = 1;
        for (Object species : this.selectedSpecies) {
            boolean check = this.checkElement((String)species);
            if (!check) {
                System.err.println("MISSING: " + species);
            }
            ++i;
        }
    }

    public double getstatus() {
        return this.status;
    }

    private void executeQuery(List<String> species, String hspenTable) {
        StringBuffer sb = new StringBuffer();
        int size = species.size();
        int i = 0;
        for (String sp : species) {
            sb.append("'" + sp + "'");
            if (++i >= size) continue;
            sb.append(",");
        }
        String query = String.format(this.selectionQuery, sb.toString());
        List<Object> maxMin = DatabaseFactory.executeSQLQuery(query, this.vreConnection);
        int sizemm = maxMin.size();
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < sizemm; ++j) {
            Object[] maxMinRow = (Object[])maxMin.get(0);
            String insert = String.format(this.insertionQuery, maxMinRow[2], maxMinRow[0], maxMinRow[1], hspenTable);
            buffer.append(insert);
        }
        try {
            AnalysisLogger.getLogger().debug("inserting...");
            DatabaseFactory.executeSQLUpdate(buffer.toString(), this.vreConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeQuery(String species, String hspenTable) {
        String query = String.format(this.selectionQuery, species);
        List<Object> maxMin = DatabaseFactory.executeSQLQuery(query, this.vreConnection);
        Object[] maxMinRow = (Object[])maxMin.get(0);
        String insert = String.format(this.insertionQuery, species, maxMinRow[0], maxMinRow[1], hspenTable);
        this.buffer.append(insert);
        if (this.counter % 100 == 0) {
            try {
                AnalysisLogger.getLogger().debug("inserting...");
                DatabaseFactory.executeSQLUpdate(this.buffer.toString(), this.vreConnection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.buffer = new StringBuffer();
        }
        ++this.counter;
    }

    public void getAllSpecies(String hspentable) {
        String query = String.format(this.SpeciesListQuery, hspentable);
        AnalysisLogger.getLogger().warn("Distribution Generator ->getting all species list from DB");
        AnalysisLogger.getLogger().warn("Distribution Generator ->" + query);
        List<Object> allspecies = DatabaseFactory.executeSQLQuery(query, this.vreConnection);
        this.selectedSpecies = allspecies;
    }

    protected void deleteDestinationTable(String table) {
        String deleteQuery = "drop table " + table + ";";
        try {
            DatabaseFactory.executeSQLUpdate(deleteQuery, this.vreConnection);
            AnalysisLogger.getLogger().debug("destination table dropped");
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug("destination table NOT dropped");
        }
    }

    protected void buildDestinationTable(String destinationTable) {
        String createQuery = String.format(this.creationQuery, destinationTable);
        AnalysisLogger.getLogger().debug("Creating new table or destination schema: " + destinationTable);
        try {
            DatabaseFactory.executeSQLUpdate(String.format(createQuery, destinationTable), this.vreConnection);
            AnalysisLogger.getLogger().debug("Table created");
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug("Table NOT created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populatemaxminlat2(String hspenTable) {
        int i = 1;
        try {
            long t0 = System.currentTimeMillis();
            this.getAllSpecies(hspenTable);
            this.deleteDestinationTable("maxminlat_" + hspenTable);
            this.buildDestinationTable("maxminlat_" + hspenTable);
            int size = this.selectedSpecies.size();
            AnalysisLogger.getLogger().warn("Distribution Generator -> SIZE: " + size);
            for (Object species : this.selectedSpecies) {
                String speciesid = (String)species;
                this.executeQuery(speciesid, hspenTable);
                this.status = MathFunctions.roundDecimal((double)((double)(++i) * 100.0 / (double)size), (int)2);
                if (i % 10 != 0) continue;
                AnalysisLogger.getLogger().debug("status " + this.status);
            }
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().debug("elapsed Time: " + (t1 - t0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.vreConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populatemaxminlat(String hspenTable) {
        int i = 1;
        try {
            long t0 = System.currentTimeMillis();
            this.getAllSpecies(hspenTable);
            this.deleteDestinationTable("maxminlat_" + hspenTable);
            this.buildDestinationTable("maxminlat_" + hspenTable);
            int size = this.selectedSpecies.size();
            AnalysisLogger.getLogger().warn("Distribution Generator -> SIZE: " + size);
            ArrayList<String> specieslist = new ArrayList<String>();
            for (Object species : this.selectedSpecies) {
                String speciesid = (String)species;
                specieslist.add(speciesid);
                this.status = MathFunctions.roundDecimal((double)((double)(++i) * 100.0 / (double)size), (int)2);
                if (this.status >= 100.0) {
                    this.status = 99.0;
                }
                if (i % 100 != 0) continue;
                AnalysisLogger.getLogger().debug("status " + this.status + " species processed " + i);
                this.executeQuery(specieslist, hspenTable);
                specieslist = null;
                specieslist = new ArrayList();
            }
            if (specieslist.size() > 0) {
                AnalysisLogger.getLogger().debug("final status " + this.status + " species processed " + i);
                this.executeQuery(specieslist, hspenTable);
            }
            long t1 = System.currentTimeMillis();
            AnalysisLogger.getLogger().debug("overall elapsed Time: " + (t1 - t0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.vreConnection.close();
            this.status = 100.0;
        }
    }

    public MaxMinGenerator(String configPath) throws Exception {
        AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
        this.vreConnection = DatabaseFactory.initDBConnection(configPath + this.vreDatabaseConfig);
    }

    public MaxMinGenerator(EngineConfiguration engine) throws Exception {
        String cfg = engine.getConfigPath();
        if (!cfg.endsWith("/")) {
            cfg = cfg + "/";
        }
        AnalysisLogger.setLogger((String)(cfg + "ALog.properties"));
        this.vreConnection = DatabaseFactory.initDBConnection(cfg + this.vreDatabaseConfig, engine);
    }

    public static void main(String[] args) throws Exception {
        EngineConfiguration e = new EngineConfiguration();
        e.setConfigPath("./cfg/");
        e.setDatabaseUserName("utente");
        e.setDatabasePassword("d4science");
        e.setDatabaseURL("jdbc:postgresql://dbtest.next.research-infrastructures.eu/aquamapsorgupdated");
        e.setHcafTable("hcaf_d");
        e.setHspenTable("hspen_new");
        e.setOriginHspenTable("hspen_validation");
        e.setOccurrenceCellsTable("occurrencecells");
        e.setEnvelopeGenerator(EnvelopeModel.AQUAMAPS);
        e.setNumberOfThreads(16);
        e.setCreateTable(true);
        MaxMinGenerator maxmin = new MaxMinGenerator(e);
        maxmin.populatemaxminlat("hspen");
    }
}

