/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.ecomodelling.generators.processing;

import com.google.gson.Gson;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.RemoteHspecInputObject;
import org.gcube.application.aquamaps.ecomodelling.generators.connectors.RemoteHspecOutputObject;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class RemoteGenerationManager {
    private final String submissionMethod = "submit";
    private final String statusMethod = "status/";
    private String submissionID;
    private String username;
    private String endpoint;
    private boolean started;

    public RemoteGenerationManager(String generatorEndPoint) {
        this.endpoint = generatorEndPoint.charAt(generatorEndPoint.length() - 1) == '/' ? generatorEndPoint : generatorEndPoint + "/";
        this.started = false;
    }

    public void submitJob(RemoteHspecInputObject rhio) throws Exception {
        AnalysisLogger.getLogger().warn("RemoteGenerationManager: retrieving job information");
        RemoteHspecOutputObject rhoo = null;
        this.username = rhio.userName;
        try {
            rhoo = (RemoteHspecOutputObject)HttpRequest.postJSonData((String)(this.endpoint + "submit"), (Object)rhio, RemoteHspecOutputObject.class);
            AnalysisLogger.getLogger().trace("OUT: " + new Gson().toJson((Object)rhoo));
            AnalysisLogger.getLogger().trace("RemoteGenerationManager: job information retrieved");
            this.started = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace("RemoteGenerationManager: ERROR - job information NOT retrieved");
            throw e;
        }
        if (rhoo == null || rhoo.id == null) {
            AnalysisLogger.getLogger().warn("RemoteGenerationManager: ERROR - job ID NOT retrieved " + rhoo.error);
            throw new Exception();
        }
        AnalysisLogger.getLogger().warn("RemoteGenerationManager: job ID retrieved ");
        this.submissionID = rhoo.id;
    }

    public double retrieveCompletion() {
        RemoteHspecOutputObject rhoo = this.retrieveCompleteStatus();
        try {
            double completion = Double.parseDouble(rhoo.completion);
            return completion;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().warn("RemoteGenerationManager: ERROR - cannot retrieve information from remote site ", (Throwable)e);
            return 0.0;
        }
    }

    public RemoteHspecOutputObject retrieveCompleteStatus() {
        RemoteHspecOutputObject rhoo = null;
        if (this.started) {
            try {
                rhoo = (RemoteHspecOutputObject)HttpRequest.getJSonData((String)(this.endpoint + "status/" + this.submissionID), null, RemoteHspecOutputObject.class);
                if (rhoo.id == null || rhoo.id.equals("null")) {
                    rhoo = this.getDefaultOutput();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().warn("RemoteGenerationManager: ERROR - cannot retrieve information from remote site ", (Throwable)e);
            }
        } else {
            rhoo = this.getDefaultOutput();
        }
        return rhoo;
    }

    private RemoteHspecOutputObject getDefaultOutput() {
        RemoteHspecOutputObject rhoo = new RemoteHspecOutputObject();
        rhoo.status = "INITIALIZING";
        rhoo.completion = "0.0";
        return rhoo;
    }
}

