/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.factsheetplugin.types;

import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.restinterface.handlers.Factsheet;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;

public class GCUBEDocumentIterator
implements RemoteIterator<GDoc> {
    private static GCUBELog logger = new GCUBELog(GCUBEDocumentIterator.class);
    private ReadManager readManager;
    private Iterator<Factsheet> factsheets;
    private Predicate projection;
    private GDoc doc;

    public GCUBEDocumentIterator(List<Factsheet> factsheets, ReadManager readManager, Predicate projection) {
        this.factsheets = factsheets.iterator();
        this.readManager = readManager;
        this.projection = projection;
    }

    public boolean hasNext() {
        this.doc = null;
        while (this.factsheets.hasNext()) {
            try {
                Factsheet factsheet = this.factsheets.next();
                this.doc = this.readManager.extractDoc(factsheet, this.readManager.getDomainName());
                if (this.projection != null) {
                    try {
                        this.projection.prune((Node)this.doc);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error matching the document", (Throwable)e);
                        continue;
                    }
                }
                return true;
            }
            catch (Exception e) {
                logger.warn((Object)"an error occurred trying to retrieve a record (moving to the next element)", (Throwable)e);
                continue;
            }
            break;
        }
        return false;
    }

    public GDoc next() {
        return this.doc;
    }

    public void remove() {
        this.factsheets.remove();
    }

    public void close() {
        this.doc = null;
        this.projection = null;
    }

    public String locator() {
        return "local";
    }
}

