/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.factsheetplugin.delegates;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.contexts.FactsheetPluginContext;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.delegates.FactsheetCollection;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.restinterface.Util;
import org.gcube.contentmanagement.contentmanager.factsheetplugin.types.FactsheetCreateParameters;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.FactoryDelegate;
import org.w3c.dom.Element;

public class FactsheetFactory
extends FactoryDelegate {
    GCUBELog logger = new GCUBELog(((Object)((Object)this)).getClass());

    public List<FactsheetCollection> create(Element parameters) throws Exception {
        FactsheetCreateParameters createParameters = FactsheetPluginContext.fromElement(parameters, FactsheetCreateParameters.class);
        if (!Util.getDomainList().contains(createParameters.getDomainName())) {
            throw new Exception("the domain doesn't exist");
        }
        ReadManager rm = new ReadManager(createParameters.getDomainName(), createParameters.getContentXpath(), createParameters.getTitleXPath());
        FactsheetCollection fc = new FactsheetCollection(createParameters.getDomainName(), rm);
        fc.setUser(true);
        fc.setName(createParameters.getCollectionName());
        fc.setCreationTime(Calendar.getInstance());
        fc.setDescription(createParameters.getDescription());
        int count = Util.getFactsheetsIdentifiersPerDomain(createParameters.getDomainName()).size();
        fc.setCardinality(count);
        return Collections.singletonList(fc);
    }
}

