/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.streams.adapters;

import java.util.NoSuchElementException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.faults.IFaultPolicy;
import org.gcube.contentmanagement.gcubedocumentlibrary.streams.filters.Filter;

public abstract class AbstractAdapter<FROM, TO, E extends Exception> {
    private RemoteIterator<FROM> inner;
    private TO next;
    private int faultCount;
    private Filter<FROM, TO> filter;
    private IFaultPolicy<? extends E> errorHandler;

    public AbstractAdapter(RemoteIterator<FROM> rit, Filter<FROM, TO> f, IFaultPolicy<? extends E> h) {
        this.inner = rit;
        this.filter = f;
        this.errorHandler = h;
    }

    public RemoteIterator<FROM> inner() {
        return this.inner;
    }

    protected IFaultPolicy<? extends E> errorHandler() {
        return this.errorHandler;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.inner.hasNext()) {
            try {
                Object el = this.inner.next();
                this.next = this.filter.apply(el);
                return true;
            }
            catch (Exception e) {
                ++this.faultCount;
                return this.delegateToHandler(e, this.faultCount);
            }
        }
        return false;
    }

    protected abstract boolean delegateToHandler(Exception var1, int var2);

    public TO next() throws E {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        TO val = this.next;
        this.next = null;
        return val;
    }
}

