/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubedocumentlibrary.views;

import java.net.URI;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.BaseCollectionView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.viewmanager.stubs.model.View;
import org.gcube.contentmanagement.viewmanager.stubs.model.ViewProperty;

public abstract class SimpleView<E extends GCubeElement, P extends Property>
extends BaseCollectionView<E, P> {
    static final ViewProperty SCHEMA_URI_VP = new ViewProperty(Projections.SCHEMA_URI.name(), "", null);
    static final ViewProperty LANGUAGE_VP = new ViewProperty(Projections.LANGUAGE.name(), "", null);
    static final ViewProperty SCHEMA_NAME_VP = new ViewProperty(Projections.SCHEMA_NAME.name(), "", null);
    static final ViewProperty EDITABLE = new ViewProperty(new QName("isEditable"), "", Boolean.TRUE.toString());
    static final ViewProperty INDEXABLE = new ViewProperty(new QName("isIndexable"), "", Boolean.TRUE.toString());
    static final ViewProperty USER_COLLECTION = new ViewProperty(new QName("isUserCollection"), "", Boolean.TRUE.toString());

    static ViewProperty clonePropertyWith(ViewProperty v, Object val) {
        return new ViewProperty(v.getName(), v.getDescription(), val.toString());
    }

    public SimpleView() {
    }

    public SimpleView(GCUBEScope s) {
        super(s);
    }

    SimpleView(View v) {
        super(v);
    }

    SimpleView(View v, GCUBEScope s) {
        super(v, s);
    }

    SimpleView(View v, GCUBESecurityManager m) {
        super(v, m);
    }

    SimpleView(View v, GCUBEScope s, GCUBESecurityManager m) {
        super(v, s, m);
    }

    public void setProjection(Locale language, String schemaName, URI schemaURI) {
        this.unboundOnly();
        if (language != null) {
            this.addProperty(SimpleView.clonePropertyWith(LANGUAGE_VP, language.getLanguage()));
        }
        this.addProperty(SimpleView.clonePropertyWith(SCHEMA_NAME_VP, schemaName));
        this.addProperty(SimpleView.clonePropertyWith(SCHEMA_URI_VP, schemaURI.toString()));
    }

    public void setLanguage(Locale language) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(LANGUAGE_VP, language == null ? null : language.getLanguage()));
    }

    public void setSchemaName(String schemaName) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(SCHEMA_NAME_VP, schemaName));
    }

    public void setSchemaURI(URI schemaURI) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(SCHEMA_URI_VP, schemaURI == null ? null : schemaURI.toString()));
    }

    public String language() {
        return this.getPropertyValueOrNull(LANGUAGE_VP.getName());
    }

    public String schemaName() {
        return this.getPropertyValueOrNull(SCHEMA_NAME_VP.getName());
    }

    public URI schemaURI() {
        String val = this.getPropertyValueOrNull(SCHEMA_URI_VP.getName());
        if (val == null) {
            return null;
        }
        return URI.create(val);
    }

    public Boolean isUserCollection() {
        String val = this.getPropertyValueOrNull(USER_COLLECTION.getName());
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public void setUserCollection(boolean userCollection) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(USER_COLLECTION, Boolean.toString(userCollection)));
    }

    public Boolean isIndexable() {
        String val = this.getPropertyValueOrNull(INDEXABLE.getName());
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public void setIndexable(boolean indexable) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(INDEXABLE, Boolean.toString(indexable)));
    }

    public Boolean isEditable() {
        String val = this.getPropertyValueOrNull(EDITABLE.getName());
        return val == null ? null : Boolean.valueOf(Boolean.parseBoolean(val));
    }

    public void setEditable(boolean editable) {
        this.unboundOnly();
        this.addProperty(SimpleView.clonePropertyWith(EDITABLE, Boolean.toString(editable)));
    }

    boolean isValid() {
        return this.language() != null && this.schemaName() != null && this.schemaURI() != null;
    }

    @Override
    protected void onBinding() throws IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalArgumentException("language, schema name, schema URI are all required  poperty on " + this);
        }
        if (this.isUserCollection() == null || this.isIndexable() == null || this.isEditable() == null) {
            throw new IllegalArgumentException("usercollection, editable are all required  poperty on " + this);
        }
    }

    @Override
    protected void onPublication() throws IllegalStateException {
        if (this.isUserCollection() == null) {
            this.setUserCollection(true);
        }
        if (this.isIndexable() == null) {
            this.setIndexable(true);
        }
        if (this.isEditable() == null) {
            this.setEditable(true);
        }
        if (!this.isValid()) {
            throw new IllegalStateException("language, schema name, schema URI are all required  poperty on " + this);
        }
    }
}

