/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import thredds.filesystem.MFileOS;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import ucar.nc2.util.Indent;

@ThreadSafe
public class ControllerOS
implements MController {
    @Override
    public Iterator<MFile> getInventory(MCollection mc) {
        return this.getInventory(mc, true);
    }

    @Override
    public Iterator<MFile> getInventoryNoSubdirs(MCollection mc) {
        return this.getInventoryNoSubdirs(mc, true);
    }

    @Override
    public Iterator<MFile> getInventory(MCollection mc, boolean recheck) {
        File cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!(cd = new File(path)).exists()) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIteratorWithSubdirs(cd));
    }

    @Override
    public Iterator<MFile> getInventoryNoSubdirs(MCollection mc, boolean recheck) {
        File cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!(cd = new File(path)).exists()) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIterator(cd));
    }

    @Override
    public void close() {
    }

    private class Traversal {
        File dir;
        List<File> fileList;
        Iterator<File> subdirIterator;
        boolean leavesAreDone = false;

        Traversal(File dir, File top) {
            this.dir = dir;
            if (dir == null) {
                System.out.printf("------ControllerOS--------%n", new Object[0]);
                this.showFiles(top, new Indent(2));
            }
            this.fileList = new ArrayList<File>();
            ArrayList<File> subdirList = new ArrayList<File>();
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    subdirList.add(f);
                    continue;
                }
                this.fileList.add(f);
            }
            if (subdirList.size() > 0) {
                this.subdirIterator = subdirList.iterator();
            }
        }

        private void showFiles(File dir, Indent indent) {
            System.out.printf("%s dir=%s%n", indent, dir);
            if (dir == null) {
                return;
            }
            indent.incr();
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.showFiles(f, indent);
                    continue;
                }
                System.out.printf("%s %s%n", indent, f);
            }
            indent.decr();
        }
    }

    private class MFileIteratorWithSubdirs
    implements Iterator<MFile> {
        Queue<Traversal> traverse = new LinkedList<Traversal>();
        Traversal currTraversal;
        Iterator<MFile> currIter;
        File top;

        MFileIteratorWithSubdirs(File top) {
            this.currTraversal = new Traversal(top, top);
            this.top = top;
        }

        @Override
        public boolean hasNext() {
            if (this.currIter == null) {
                this.currIter = this.getNextIterator();
                if (this.currIter == null) {
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public MFile next() {
            return this.currIter.next();
        }

        private Iterator<MFile> getNextIterator() {
            if (!this.currTraversal.leavesAreDone) {
                this.currTraversal.leavesAreDone = true;
                return new MFileIterator(this.currTraversal.fileList);
            }
            if (this.currTraversal.subdirIterator != null && this.currTraversal.subdirIterator.hasNext()) {
                File nextDir = this.currTraversal.subdirIterator.next();
                this.traverse.add(this.currTraversal);
                this.currTraversal = new Traversal(nextDir, this.top);
                return this.getNextIterator();
            }
            if (this.traverse.peek() == null) {
                return null;
            }
            this.currTraversal = this.traverse.remove();
            return this.getNextIterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MFileIterator
    implements Iterator<MFile> {
        List<File> files;
        int count = 0;

        MFileIterator(File dir) {
            this.files = Arrays.asList(dir.listFiles());
        }

        MFileIterator(List<File> files) {
            this.files = files;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.size();
        }

        @Override
        public MFile next() {
            File cfile = this.files.get(this.count++);
            return new MFileOS(cfile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FilteredIterator
    implements Iterator<MFile> {
        private Iterator<MFile> orgIter;
        private MCollection mc;
        private MFile next;

        FilteredIterator(MCollection mc, Iterator<MFile> iter) {
            this.orgIter = iter;
            this.mc = mc;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredFile();
            return this.next != null;
        }

        @Override
        public MFile next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private MFile nextFilteredFile() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (pdata.isDirectory() || !this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    return null;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

