/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.grads.GradsAttribute;
import ucar.nc2.iosp.grads.GradsDimension;
import ucar.nc2.iosp.grads.GradsEnsembleDimension;
import ucar.nc2.iosp.grads.GradsTimeDimension;
import ucar.nc2.iosp.grads.GradsVariable;

public class GradsDataDescriptorFile {
    private static Logger log = LoggerFactory.getLogger(GradsDataDescriptorFile.class);
    public static final String DSET = "DSET";
    public static final String DTYPE = "DTYPE";
    public static final String INDEX = "INDEX";
    public static final String TITLE = "TITLE";
    public static final String UNDEF = "UNDEF";
    public static final String UNPACK = "UNPACK";
    public static final String FILEHEADER = "FILEHEADER";
    public static final String XYHEADER = "XYHEADER";
    public static final String THEADER = "THEADER";
    public static final String HEADERBYTES = "HEADERBYTES";
    public static final String TRAILERBYTES = "TRAILERBYTES";
    public static final String OPTIONS = "OPTIONS";
    public static final String XDEF = "XDEF";
    public static final String YDEF = "YDEF";
    public static final String ZDEF = "ZDEF";
    public static final String TDEF = "TDEF";
    public static final String EDEF = "EDEF";
    public static final String PDEF = "PDEF";
    public static final String ENDEDEF = "ENDEDEF";
    public static final String VARS = "VARS";
    public static final String ENDVARS = "ENDVARS";
    private static final String YREV = "YREV";
    private static final String TEMPLATE = "TEMPLATE";
    private static final String CHSUB = "CHSUB";
    private static final String CHSUB_TEMPLATE_ID = "%ch";
    private static final String BIG_ENDIAN = "BIG_ENDIAN";
    private static final String LITTLE_ENDIAN = "LITTLE_ENDIAN";
    private static final String BYTESWAPPED = "BYTESWAPPED";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    public static final int NO_TEMPLATE = 0;
    public static final int TIME_TEMPLATE = 1;
    public static final int ENS_TEMPLATE = 2;
    public static final int ENS_TIME_TEMPLATE = 3;
    private String ddFile;
    private String dataFile;
    boolean bigEndian = false;
    private double missingData = Double.NaN;
    private int xyHeaderBytes = 0;
    private int fileHeaderBytes = 0;
    private int timeHeaderBytes = 0;
    private int timeTrailerBytes = 0;
    private String dataType = null;
    List<GradsVariable> variableList;
    List<GradsDimension> dimList;
    List<GradsAttribute> attrList;
    private GradsDimension xDim;
    private GradsDimension yDim;
    private GradsDimension zDim;
    private GradsTimeDimension tDim;
    private GradsEnsembleDimension eDim;
    private String title = null;
    private int gridsPerTimeStep = 0;
    private int timeStepsPerFile = 0;
    private boolean isTemplate = false;
    private int templateType = 0;
    private boolean isSequential = false;
    private boolean yReversed = false;
    List<String> fileNames;
    private boolean hasProjection = false;
    private List<Chsub> chsubs = null;
    private String pathToDDF = null;

    public GradsDataDescriptorFile(String filename) throws IOException {
        this.ddFile = filename;
        this.parseDDF();
        this.getFileNames();
    }

    private void parseDDF() throws IOException {
        block56: {
            long start2 = System.currentTimeMillis();
            BufferedReader r = new BufferedReader(new FileReader(this.ddFile));
            this.variableList = new ArrayList<GradsVariable>();
            this.dimList = new ArrayList<GradsDimension>();
            this.attrList = new ArrayList<GradsAttribute>();
            try {
                String original;
                boolean inVarSection = false;
                boolean inEnsSection = false;
                GradsDimension curDim = null;
                while ((original = r.readLine()) != null) {
                    if ((original = original.trim()).isEmpty()) continue;
                    String line = original.toLowerCase();
                    if (line.startsWith("@ ")) {
                        this.attrList.add(GradsAttribute.parseAttribute(original));
                        continue;
                    }
                    if (line.startsWith("*")) continue;
                    if (inEnsSection && line.startsWith(ENDEDEF.toLowerCase())) {
                        inEnsSection = false;
                        continue;
                    }
                    if (inVarSection) {
                        if (line.startsWith(ENDVARS.toLowerCase())) {
                            inVarSection = false;
                            continue;
                        }
                        GradsVariable var = new GradsVariable(original);
                        int numLevels = var.getNumLevels();
                        if (numLevels == 0) {
                            numLevels = 1;
                        }
                        this.gridsPerTimeStep += numLevels;
                        this.variableList.add(var);
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(original);
                    String label = st.nextToken();
                    if (label.equalsIgnoreCase(OPTIONS)) {
                        curDim = null;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equalsIgnoreCase(BIG_ENDIAN)) {
                                this.bigEndian = true;
                                continue;
                            }
                            if (token.equalsIgnoreCase(LITTLE_ENDIAN)) {
                                this.bigEndian = false;
                                continue;
                            }
                            if (token.equalsIgnoreCase(BYTESWAPPED)) {
                                this.swapByteOrder();
                                continue;
                            }
                            if (token.equalsIgnoreCase(YREV)) {
                                this.yReversed = true;
                                continue;
                            }
                            if (token.equalsIgnoreCase(TEMPLATE)) {
                                this.isTemplate = true;
                                continue;
                            }
                            if (!token.equalsIgnoreCase(SEQUENTIAL)) continue;
                            this.isSequential = true;
                        }
                    } else if (label.equalsIgnoreCase(CHSUB)) {
                        int start = Integer.parseInt(st.nextToken());
                        int end = Integer.parseInt(st.nextToken());
                        String sub = st.nextToken();
                        this.addChsub(new Chsub(start, end, sub));
                    } else if (label.equalsIgnoreCase(DSET)) {
                        curDim = null;
                        this.dataFile = st.nextToken();
                    } else if (label.equalsIgnoreCase(UNDEF)) {
                        curDim = null;
                        this.missingData = Double.parseDouble(st.nextToken());
                    } else if (label.equalsIgnoreCase(XYHEADER)) {
                        curDim = null;
                        this.xyHeaderBytes = Integer.parseInt(st.nextToken());
                    } else if (label.equalsIgnoreCase(FILEHEADER)) {
                        curDim = null;
                        this.fileHeaderBytes = Integer.parseInt(st.nextToken());
                    } else if (label.equalsIgnoreCase(XDEF)) {
                        int xSize = Integer.valueOf(st.nextToken());
                        String xMapping = st.nextToken();
                        curDim = this.xDim = new GradsDimension(label, xSize, xMapping);
                        this.dimList.add(this.xDim);
                    } else if (label.equalsIgnoreCase(YDEF)) {
                        int ySize = Integer.valueOf(st.nextToken());
                        String yMapping = st.nextToken();
                        curDim = this.yDim = new GradsDimension(label, ySize, yMapping);
                        this.dimList.add(this.yDim);
                    } else if (label.equalsIgnoreCase(ZDEF)) {
                        int zSize = Integer.valueOf(st.nextToken());
                        String zMapping = st.nextToken();
                        curDim = this.zDim = new GradsDimension(label, zSize, zMapping);
                        this.dimList.add(this.zDim);
                    } else if (label.equalsIgnoreCase(TDEF)) {
                        int tSize = Integer.valueOf(st.nextToken());
                        String tMapping = st.nextToken();
                        this.tDim = new GradsTimeDimension(label, tSize, tMapping);
                        curDim = this.tDim;
                        this.dimList.add(this.tDim);
                    } else if (label.equalsIgnoreCase(EDEF)) {
                        int eSize = Integer.valueOf(st.nextToken());
                        if (st.nextToken().equalsIgnoreCase("NAMES")) {
                            inEnsSection = false;
                            String eMapping = "NAMES";
                            this.eDim = new GradsEnsembleDimension(label, eSize, eMapping);
                            curDim = this.eDim;
                            this.dimList.add(curDim);
                        } else {
                            curDim = null;
                            inEnsSection = true;
                        }
                    } else if (label.equalsIgnoreCase(PDEF)) {
                        curDim = null;
                        this.hasProjection = true;
                    } else if (label.equalsIgnoreCase(VARS)) {
                        curDim = null;
                        inVarSection = true;
                    } else if (label.equalsIgnoreCase(DTYPE)) {
                        curDim = null;
                        this.dataType = st.nextToken();
                    } else if (label.equalsIgnoreCase(TITLE)) {
                        curDim = null;
                        this.title = original.substring(original.indexOf(" ")).trim();
                    } else if (curDim != null) {
                        curDim.addLevel(label);
                    }
                    if (curDim == null) continue;
                    while (st.hasMoreTokens()) {
                        curDim.addLevel(st.nextToken());
                    }
                }
                if (this.zDim == null) break block56;
                for (GradsAttribute attr : this.attrList) {
                    if (!attr.getVariable().equalsIgnoreCase(ZDEF) || !attr.getType().equalsIgnoreCase("String") || !attr.getName().equalsIgnoreCase("units")) continue;
                    this.zDim.setUnit(attr.getValue());
                    break;
                }
            }
            catch (IOException ioe) {
                log.error("Error parsing metadata for " + this.ddFile);
                throw new IOException("error parsing metadata for " + this.ddFile);
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void swapByteOrder() {
        String arch = System.getProperty("os.arch");
        this.bigEndian = arch.equals("x86") || arch.equals("arm") || arch.equals("x86_64") || arch.equals("amd64") || arch.equals("alpha");
    }

    public List<GradsDimension> getDimensions() {
        return this.dimList;
    }

    public List<GradsVariable> getVariables() {
        return this.variableList;
    }

    public List<GradsAttribute> getAttributes() {
        return this.attrList;
    }

    public GradsEnsembleDimension getEnsembleDimension() {
        return this.eDim;
    }

    public GradsTimeDimension getTimeDimension() {
        return this.tDim;
    }

    public GradsDimension getZDimension() {
        return this.zDim;
    }

    public GradsDimension getYDimension() {
        return this.yDim;
    }

    public GradsDimension getXDimension() {
        return this.xDim;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public String getDataDescriptorFile() {
        return this.ddFile;
    }

    public double getMissingValue() {
        return this.missingData;
    }

    public int getGridsPerTimeStep() {
        return this.gridsPerTimeStep;
    }

    public int[] getTimeStepsPerFile(String filename) {
        if (this.chsubs != null) {
            for (Chsub ch : this.chsubs) {
                if (filename.indexOf(ch.subString) < 0) continue;
                return new int[]{ch.numTimes, ch.startTimeIndex};
            }
        }
        return new int[]{this.timeStepsPerFile, 0};
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public int getTemplateType() {
        return this.templateType;
    }

    public boolean hasProjection() {
        return this.hasProjection;
    }

    public boolean isSequential() {
        return this.isSequential;
    }

    public boolean isYReversed() {
        return this.yReversed;
    }

    public int getXYHeaderBytes() {
        return this.xyHeaderBytes;
    }

    public int getFileHeaderBytes() {
        return this.fileHeaderBytes;
    }

    public int getTimeHeaderBytes() {
        return this.timeHeaderBytes;
    }

    public int getTimeTrailerBytes() {
        return this.timeTrailerBytes;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Parsed: ");
        buf.append(this.ddFile);
        buf.append("\n");
        buf.append("Data file: ");
        buf.append(this.dataFile);
        buf.append("\n");
        for (GradsDimension dim : this.dimList) {
            buf.append(dim.toString());
        }
        for (GradsVariable var : this.variableList) {
            buf.append(var.toString());
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        GradsDataDescriptorFile gdd = new GradsDataDescriptorFile(args[0]);
        System.out.println(gdd);
    }

    public String getFileName(int eIndex, int tIndex) {
        String dataFilePath = this.dataFile;
        if (this.getTemplateType() == 2 || this.getTemplateType() == 3) {
            dataFilePath = this.getEnsembleDimension().replaceFileTemplate(dataFilePath, eIndex);
        }
        dataFilePath = this.getTimeDimension().replaceFileTemplate(dataFilePath, tIndex);
        if (this.chsubs != null && dataFilePath.indexOf(CHSUB_TEMPLATE_ID) >= 0) {
            for (Chsub ch : this.chsubs) {
                if (tIndex < ch.startTimeIndex || tIndex > ch.endTimeIndex) continue;
                dataFilePath.replace(CHSUB_TEMPLATE_ID, ch.subString);
                break;
            }
        }
        return this.getFullPath(dataFilePath);
    }

    private List<String> getFileNames() throws IOException {
        if (this.fileNames == null) {
            this.fileNames = new ArrayList<String>();
            this.timeStepsPerFile = this.tDim.getSize();
            if (!this.isTemplate()) {
                this.fileNames.add(this.getFullPath(this.getDataFile()));
            } else {
                long start = System.currentTimeMillis();
                ArrayList<String> fileSet = new ArrayList<String>();
                String template = this.getDataFile();
                this.templateType = GradsTimeDimension.hasTimeTemplate(template) ? (template.indexOf("%e") >= 0 ? 3 : 1) : (template.indexOf("%e") >= 0 ? 2 : 1);
                if (this.templateType == 2) {
                    for (int e = 0; e < this.eDim.getSize(); ++e) {
                        fileSet.add(this.getFullPath(this.eDim.replaceFileTemplate(template, e)));
                    }
                } else if (this.templateType == 1 || this.templateType == 3) {
                    int numens = this.templateType == 1 ? 1 : this.eDim.getSize();
                    for (int t = 0; t < this.tDim.getSize(); ++t) {
                        for (int e = 0; e < numens; ++e) {
                            String file = this.getFileName(e, t);
                            if (fileSet.contains(file)) continue;
                            fileSet.add(file);
                        }
                    }
                    this.timeStepsPerFile = this.tDim.getSize() / (fileSet.size() / numens);
                }
                this.fileNames.addAll(fileSet);
            }
            long start2 = System.currentTimeMillis();
            for (String file : this.fileNames) {
                File f = new File(file);
                if (f.exists()) continue;
                log.error("File: " + f + " does not exist");
                throw new IOException("File: " + f + " does not exist");
            }
        }
        return this.fileNames;
    }

    private String getDDFPath() {
        if (this.pathToDDF == null) {
            int lastSlash = this.ddFile.lastIndexOf("/");
            if (lastSlash < 0) {
                lastSlash = this.ddFile.lastIndexOf(File.separator);
            }
            this.pathToDDF = lastSlash < 0 ? "" : this.ddFile.substring(0, lastSlash + 1);
        }
        return this.pathToDDF;
    }

    private String getFullPath(String filename) {
        String file = filename;
        String ddfPath = this.getDDFPath();
        if (filename.startsWith("^")) {
            file = filename.replace("^", "");
            file = ddfPath + file;
        } else {
            File f = new File(filename);
            file = !f.isAbsolute() ? ddfPath + filename : filename;
        }
        return file;
    }

    private void addChsub(Chsub sub) {
        if (this.chsubs == null) {
            this.chsubs = new ArrayList<Chsub>();
        }
        this.chsubs.add(sub);
    }

    protected class Chsub {
        protected int startTimeIndex = 0;
        protected int endTimeIndex = 0;
        protected int numTimes = 0;
        protected String subString = null;

        Chsub(int start, int end, String sub) {
            this.startTimeIndex = start - 1;
            this.endTimeIndex = end - 1;
            this.numTimes = this.endTimeIndex - this.startTimeIndex + 1;
            this.subString = sub;
        }

        public String toString() {
            return "CHSUB " + this.startTimeIndex + " " + this.endTimeIndex + " " + this.subString;
        }
    }
}

