/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function0;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.PartialFunction$class;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenIterable$class;
import scala.collection.GenIterableLike$class;
import scala.collection.GenIterableViewLike$class;
import scala.collection.GenSeq$class;
import scala.collection.GenSeqLike$class;
import scala.collection.GenSeqViewLike$class;
import scala.collection.GenTraversable;
import scala.collection.GenTraversable$class;
import scala.collection.GenTraversableLike$class;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.GenTraversableViewLike$class;
import scala.collection.Iterable$class;
import scala.collection.IterableLike$class;
import scala.collection.IterableViewLike$class;
import scala.collection.Iterator;
import scala.collection.LinearSeqLike$class;
import scala.collection.LinearSeqOptimized;
import scala.collection.LinearSeqOptimized$class;
import scala.collection.Parallelizable$class;
import scala.collection.Seq$class;
import scala.collection.SeqLike$class;
import scala.collection.SeqViewLike$class;
import scala.collection.Traversable$class;
import scala.collection.TraversableLike;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$class;
import scala.collection.TraversableViewLike$class;
import scala.collection.ViewMkString$class;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenTraversableFactory;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.generic.TraversableForwarder$class;
import scala.collection.immutable.LinearSeq;
import scala.collection.immutable.LinearSeq$class;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Stream$Empty$;
import scala.collection.immutable.StreamIterator;
import scala.collection.immutable.StreamView;
import scala.collection.immutable.StreamViewLike$class;
import scala.collection.mutable.LazyBuilder;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stream<A>
implements LinearSeq<A>,
GenericTraversableTemplate<A, Stream>,
LinearSeqOptimized<A, Stream<A>> {
    @Override
    public GenericCompanion<Stream> companion() {
        return Stream$.MODULE$;
    }

    public abstract boolean tailDefined();

    public <B> Stream<B> append(Function0<TraversableOnce<B>> rest$1) {
        Cons cons;
        if (this.isEmpty()) {
            cons = ((GenTraversableOnce)rest$1.apply()).toStream();
        } else {
            Serializable serializable = new Serializable(this, rest$1){
                public static final long serialVersionUID;
                public final Stream $outer;
                public final Function0 rest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<B> apply() {
                    return ((Stream)this.$outer.tail()).append(this.rest$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rest$1 = stream;
                }
            };
            Object a = this.head();
            cons = new Cons(a, serializable);
        }
        return cons;
    }

    public Stream<A> force() {
        Stream these = this;
        while (!these.isEmpty()) {
            these = (Stream)these.tail();
        }
        return this;
    }

    @Override
    public int length() {
        int len = 0;
        Stream left = this;
        while (!left.isEmpty()) {
            ++len;
            left = (Stream)left.tail();
        }
        return len;
    }

    @Override
    public Stream<A> toStream() {
        return this;
    }

    @Override
    public <B, That> That $plus$plus(GenTraversableOnce<B> that$1, CanBuildFrom<Stream<A>, B, That> bf) {
        Cons cons;
        if (bf.apply((Stream<A>)this.repr()) instanceof StreamBuilder) {
            if (this.isEmpty()) {
                cons = that$1.toStream();
            } else {
                Serializable serializable = new Serializable(this, that$1){
                    public static final long serialVersionUID;
                    public final Stream $outer;
                    public final GenTraversableOnce that$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Stream<A> apply() {
                        return ((Stream)this.$outer.tail()).$plus$plus(this.that$1, Stream$.MODULE$.canBuildFrom());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.that$1 = stream;
                    }
                };
                Object a = this.head();
                cons = new Cons(a, serializable);
            }
        } else {
            cons = TraversableLike$class.$plus$plus(this, that$1, bf);
        }
        return (That)cons;
    }

    @Override
    public final <B, That> That map(Function1<A, B> f$1, CanBuildFrom<Stream<A>, B, That> bf) {
        Object object;
        if (bf.apply((Stream<A>)this.repr()) instanceof StreamBuilder) {
            if (this.isEmpty()) {
                object = Stream$Empty$.MODULE$;
            } else {
                Serializable serializable = new Serializable(this, f$1){
                    public static final long serialVersionUID;
                    public final Stream $outer;
                    public final Function1 f$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Stream<B> apply() {
                        void f$11;
                        Object object;
                        void $inlThis1;
                        CanBuildFrom<Stream<?>, A, Stream<A>> canBuildFrom = Stream$.MODULE$.canBuildFrom();
                        Function1 function1 = this.f$1;
                        CanBuildFrom<Stream<?>, A, Stream<A>> canBuildFrom2 = canBuildFrom;
                        Stream stream = (Stream)this.$outer.tail();
                        Stream stream2 = stream;
                        if (canBuildFrom2.apply((Stream<?>)stream2.repr()) instanceof StreamBuilder) {
                            if ($inlThis1.isEmpty()) {
                                object = Stream$Empty$.MODULE$;
                            } else {
                                Serializable serializable = new /* invalid duplicate definition of identical inner class */;
                                R r = f$11.apply($inlThis1.head());
                                object = new Cons<R>(r, serializable);
                            }
                        } else {
                            void bf1;
                            object = TraversableLike$class.map((TraversableLike)$inlThis1, (Function1)f$11, (CanBuildFrom)bf1);
                        }
                        return (Stream)object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.f$1 = stream;
                    }
                };
                B b = f$1.apply(this.head());
                object = new Cons<B>(b, serializable);
            }
        } else {
            object = TraversableLike$class.map(this, f$1, bf);
        }
        return (That)object;
    }

    @Override
    public Stream<A> filter(Function1<A, Object> p) {
        Stream rest = this;
        while (!rest.isEmpty() && !BoxesRunTime.unboxToBoolean(p.apply(rest.head()))) {
            rest = (Stream)rest.tail();
        }
        return rest.nonEmpty() ? Stream$.MODULE$.filteredTail(rest, p) : Stream$Empty$.MODULE$;
    }

    @Override
    public Iterator<A> iterator() {
        return new StreamIterator(this);
    }

    @Override
    public final <B> void foreach(Function1<A, B> f) {
        while (!this_.isEmpty()) {
            f.apply(this_.head());
            Stream this_ = (Stream)this_.tail();
        }
        return;
    }

    @Override
    public final <B> B foldLeft(B z, Function2<B, A, B> op) {
        while (!this_.isEmpty()) {
            z = op.apply(z, this_.head());
            Stream this_ = (Stream)this_.tail();
        }
        return z;
    }

    @Override
    public final <B> B reduceLeft(Function2<B, A, B> f) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        Object reducedRes = this.head();
        Stream left = (Stream)this.tail();
        while (!left.isEmpty()) {
            reducedRes = f.apply(reducedRes, left.head());
            left = (Stream)left.tail();
        }
        return (B)reducedRes;
    }

    @Override
    public final <A1, B, That> That zip(GenIterable<B> that$2, CanBuildFrom<Stream<A>, Tuple2<A1, B>, That> bf) {
        Object object;
        if (bf.apply((Stream<A>)this.repr()) instanceof StreamBuilder) {
            if (this.isEmpty() || that$2.isEmpty()) {
                object = Stream$Empty$.MODULE$;
            } else {
                Serializable serializable = new Serializable(this, that$2){
                    public static final long serialVersionUID;
                    public final Stream $outer;
                    public final GenIterable that$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Stream<Tuple2<A1, B>> apply() {
                        return ((Stream)this.$outer.tail()).zip((GenIterable)this.that$2.tail(), Stream$.MODULE$.canBuildFrom());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.that$2 = stream;
                    }
                };
                Tuple2 tuple2 = new Tuple2(this.head(), that$2.head());
                object = new Cons(tuple2, serializable);
            }
        } else {
            object = IterableLike$class.zip(this, that$2, bf);
        }
        return (That)object;
    }

    @Override
    public <A1, That> That zipWithIndex(CanBuildFrom<Stream<A>, Tuple2<A1, Object>, That> bf) {
        return this.zip((GenIterable<B>)Stream$.MODULE$.from(0), (CanBuildFrom)bf);
    }

    @Override
    public StringBuilder addString(StringBuilder b$1, String start, String sep$2, String end$1) {
        b$1.append(start);
        this.loop$3("", this, b$1, sep$2, end$1);
        return b$1;
    }

    @Override
    public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    @Override
    public String mkString() {
        return this.mkString("");
    }

    @Override
    public String mkString(String start, String sep, String end) {
        this.force();
        return TraversableOnce$class.mkString(this, start, sep, end);
    }

    @Override
    public String toString() {
        return TraversableOnce$class.mkString(this, new StringBuilder().append((Object)this.stringPrefix()).append((Object)"(").toString(), ", ", ")");
    }

    @Override
    public Tuple2<Stream<A>, Stream<A>> splitAt(int n) {
        return new Tuple2<Object, Object>(this.take(n), this.drop(n));
    }

    @Override
    public Stream<A> take(int n$1) {
        Stream stream;
        if (n$1 <= 0 || this.isEmpty()) {
            stream = Stream$Empty$.MODULE$;
        } else if (n$1 == 1) {
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<Nothing$> apply() {
                    return Stream$.MODULE$.empty();
                }
            };
            Object a = this.head();
            stream = new Cons(a, serializable);
        } else {
            Serializable serializable = new Serializable(this, n$1){
                public static final long serialVersionUID;
                public final Stream $outer;
                public final int n$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<A> apply() {
                    return ((Stream)this.$outer.tail()).take(this.n$1 - 1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.n$1 = n;
                }
            };
            Object a = this.head();
            stream = new Cons(a, serializable);
        }
        return stream;
    }

    @Override
    public final Stream<A> drop(int n) {
        while (n > 0 && !this_.isEmpty()) {
            --n;
            Stream this_ = (Stream)this_.tail();
        }
        return this_;
    }

    public Stream<A> takeWhile(Function1<A, Object> p$3) {
        Stream stream;
        if (!this.isEmpty() && BoxesRunTime.unboxToBoolean(p$3.apply(this.head()))) {
            Serializable serializable = new Serializable(this, p$3){
                public static final long serialVersionUID;
                public final Stream $outer;
                public final Function1 p$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<A> apply() {
                    return ((Stream)this.$outer.tail()).takeWhile(this.p$3);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.p$3 = stream;
                }
            };
            Object a = this.head();
            stream = new Cons(a, serializable);
        } else {
            stream = Stream$Empty$.MODULE$;
        }
        return stream;
    }

    @Override
    public <B, That> That padTo(int len, B elem$1, CanBuildFrom<Stream<A>, B, That> bf) {
        return (That)(bf.apply((Stream<A>)this.repr()) instanceof StreamBuilder ? this.loop$4(len, this, elem$1) : SeqLike$class.padTo(this, len, elem$1, bf));
    }

    @Override
    public Stream<A> reverse() {
        ObjectRef result$1 = new ObjectRef(Stream$Empty$.MODULE$);
        Stream these = this;
        while (!these.isEmpty()) {
            Serializable serializable = new Serializable(this, result$1){
                public static final long serialVersionUID;
                public final ObjectRef result$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<A> apply() {
                    return (Stream)this.result$1.elem;
                }
                {
                    this.result$1 = stream;
                }
            };
            Stream r = new ConsWrapper(serializable).$hash$colon$colon(these.head());
            r.tail();
            result$1.elem = r;
            these = (Stream)these.tail();
        }
        return (Stream)result$1.elem;
    }

    @Override
    public StreamView view() {
        return new StreamView<A, Stream<A>>(this){
            public final Stream $outer;

            public Iterator<A> iterator() {
                return this.$outer.iterator();
            }

            public int length() {
                return this.$outer.length();
            }

            public A apply(int idx) {
                return this.$outer.apply(idx);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Function1$class.$init$(this);
                PartialFunction$class.$init$(this);
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Parallelizable$class.$init$(this);
                GenTraversableLike$class.$init$(this);
                TraversableLike$class.$init$(this);
                GenericTraversableTemplate$class.$init$(this);
                GenTraversable$class.$init$(this);
                Traversable$class.$init$(this);
                GenIterableLike$class.$init$(this);
                GenIterable$class.$init$(this);
                IterableLike$class.$init$(this);
                Iterable$class.$init$(this);
                GenSeqLike$class.$init$(this);
                GenSeq$class.$init$(this);
                SeqLike$class.$init$(this);
                Seq$class.$init$(this);
                ViewMkString$class.$init$(this);
                GenTraversableViewLike$class.$init$(this);
                TraversableViewLike$class.$init$(this);
                GenIterableViewLike$class.$init$(this);
                IterableViewLike$class.$init$(this);
                GenSeqViewLike$class.$init$(this);
                SeqViewLike$class.$init$(this);
                StreamViewLike$class.$init$(this);
            }
        };
    }

    @Override
    public String stringPrefix() {
        return "Stream";
    }

    private final void loop$3(String pre, Stream these, StringBuilder stringBuilder, String string, String string2) {
        block2: {
            while (true) {
                if (these.isEmpty()) {
                    stringBuilder.append(string2);
                    break block2;
                }
                stringBuilder.append(pre).append(these.head());
                if (!these.tailDefined()) break;
                these = (Stream)these.tail();
                pre = string;
            }
            stringBuilder.append(string).append("?").append(string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Stream loop$4(int len$1, Stream these$1, Object object) {
        Stream stream;
        if (these$1.isEmpty()) {
            Serializable serializable = new Serializable(this, object){
                public static final long serialVersionUID;
                public final Object elem$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final B apply() {
                    return (B)this.elem$1;
                }
                {
                    this.elem$1 = stream;
                }
            };
            int n = len$1;
            if (n <= 0) {
                stream = Stream$Empty$.MODULE$;
            } else {
                void elem$21;
                void n$21;
                Serializable serializable2 = new Serializable((int)n$21, (Function0)elem$21){
                    public static final long serialVersionUID;
                    public final int n$2;
                    public final Function0 elem$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Stream<A> apply() {
                        return Stream$.MODULE$.fill(this.n$2 - 1, this.elem$2);
                    }
                    {
                        this.n$2 = n;
                        this.elem$2 = function0;
                    }
                };
                Object object2 = object;
                stream = new Cons<Object>(object2, (Function0<Stream<Object>>)((Object)serializable2));
            }
        } else {
            Serializable serializable = new Serializable(this, object, len$1, these$1){
                public static final long serialVersionUID;
                public final Stream $outer;
                public final Object elem$1;
                public final int len$1;
                public final Stream these$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<B> apply() {
                    return this.$outer.loop$4(this.len$1 - 1, (Stream)this.these$1.tail(), this.elem$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elem$1 = stream;
                    this.len$1 = n;
                    this.these$1 = var4_4;
                }
            };
            Object a = these$1.head();
            stream = new Cons(a, serializable);
        }
        return stream;
    }

    public Stream() {
        GenTraversableOnce$class.$init$(this);
        TraversableOnce$class.$init$(this);
        Parallelizable$class.$init$(this);
        GenTraversableLike$class.$init$(this);
        TraversableLike$class.$init$(this);
        GenericTraversableTemplate$class.$init$(this);
        GenTraversable$class.$init$(this);
        Traversable$class.$init$(this);
        scala.collection.immutable.Traversable$class.$init$(this);
        GenIterableLike$class.$init$(this);
        GenIterable$class.$init$(this);
        IterableLike$class.$init$(this);
        Iterable$class.$init$(this);
        scala.collection.immutable.Iterable$class.$init$(this);
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        GenSeqLike$class.$init$(this);
        GenSeq$class.$init$(this);
        SeqLike$class.$init$(this);
        Seq$class.$init$(this);
        scala.collection.immutable.Seq$class.$init$(this);
        LinearSeqLike$class.$init$(this);
        scala.collection.LinearSeq$class.$init$(this);
        LinearSeq$class.$init$(this);
        LinearSeqOptimized$class.$init$(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Cons<A>
    extends Stream<A>
    implements Serializable {
        public static final long serialVersionUID;
        private final A hd;
        private final Function0<Stream<A>> tl;
        private volatile Stream<A> tlVal;

        static {
            long l = serialVersionUID = -602202424901551803L;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public A head() {
            return this.hd;
        }

        @Override
        public boolean tailDefined() {
            return this.tlVal != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Stream<A> tail() {
            if (this.tailDefined()) return this.tlVal;
            Cons cons = this;
            synchronized (cons) {
                if (!this.tailDefined()) {
                    this.tlVal = this.tl.apply();
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return this.tlVal;
            }
        }

        public Cons(A hd, Function0<Stream<A>> tl) {
            this.hd = hd;
            this.tl = tl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsWrapper<A> {
        private final Function0<Stream<A>> tl;

        public Stream<A> $hash$colon$colon(A hd) {
            Function0<Stream<A>> function0 = this.tl;
            A a = hd;
            return new Cons<A>(a, function0);
        }

        public ConsWrapper(Function0<Stream<A>> tl) {
            this.tl = tl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StreamBuilder<A>
    extends LazyBuilder<A, Stream<A>> {
        /*
         * WARNING - void declaration
         */
        @Override
        public Stream<A> result() {
            void f$21;
            Stream stream;
            void $inlThis1;
            StreamCanBuildFrom streamCanBuildFrom = new StreamCanBuildFrom();
            Serializable serializable = new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Stream<A> apply(TraversableOnce<A> traversableOnce) {
                    return traversableOnce.toStream();
                }
            };
            Stream stream2 = TraversableForwarder$class.toStream(this.parts());
            Stream stream3 = stream2;
            if (streamCanBuildFrom.apply(stream3.repr()) instanceof StreamBuilder) {
                if ($inlThis1.isEmpty()) {
                    stream = Stream$Empty$.MODULE$;
                } else {
                    ObjectRef nonEmptyPrefix$11 = new ObjectRef($inlThis1);
                    Stream prefix1 = ((GenTraversableOnce)((TraversableOnce)((Stream)nonEmptyPrefix$11.elem).head()).toStream()).toStream();
                    while (!((Stream)nonEmptyPrefix$11.elem).isEmpty() && prefix1.isEmpty()) {
                        nonEmptyPrefix$11.elem = (Stream)((Stream)nonEmptyPrefix$11.elem).tail();
                        if (((Stream)nonEmptyPrefix$11.elem).isEmpty()) continue;
                        prefix1 = ((GenTraversableOnce)((TraversableOnce)((Stream)nonEmptyPrefix$11.elem).head()).toStream()).toStream();
                    }
                    stream = ((Stream)nonEmptyPrefix$11.elem).isEmpty() ? Stream$Empty$.MODULE$ : prefix1.append(new Serializable((Stream)$inlThis1, (Function1)f$21, nonEmptyPrefix$11){
                        public static final long serialVersionUID;
                        public final Stream $outer;
                        public final Function1 f$2;
                        public final ObjectRef nonEmptyPrefix$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Stream<B> apply() {
                            void f$21;
                            GenTraversable<Object> genTraversable;
                            void $inlThis1;
                            CanBuildFrom<Stream<?>, A, Stream<A>> canBuildFrom = Stream$.MODULE$.canBuildFrom();
                            Function1 function1 = this.f$2;
                            CanBuildFrom<Stream<?>, A, Stream<A>> canBuildFrom2 = canBuildFrom;
                            Stream stream = (Stream)((Stream)this.nonEmptyPrefix$1.elem).tail();
                            Stream stream2 = stream;
                            if (canBuildFrom2.apply((Stream<?>)stream2.repr()) instanceof StreamBuilder) {
                                if ($inlThis1.isEmpty()) {
                                    genTraversable = Stream$Empty$.MODULE$;
                                } else {
                                    ObjectRef nonEmptyPrefix$11 = new ObjectRef($inlThis1);
                                    Stream<A> prefix1 = ((GenTraversableOnce)f$21.apply(((Stream)nonEmptyPrefix$11.elem).head())).toStream();
                                    while (!((Stream)nonEmptyPrefix$11.elem).isEmpty() && prefix1.isEmpty()) {
                                        nonEmptyPrefix$11.elem = (Stream)((Stream)nonEmptyPrefix$11.elem).tail();
                                        if (((Stream)nonEmptyPrefix$11.elem).isEmpty()) continue;
                                        prefix1 = ((GenTraversableOnce)f$21.apply(((Stream)nonEmptyPrefix$11.elem).head())).toStream();
                                    }
                                    genTraversable = ((Stream)nonEmptyPrefix$11.elem).isEmpty() ? Stream$.MODULE$.empty() : prefix1.append(new /* invalid duplicate definition of identical inner class */);
                                }
                            } else {
                                void bf1;
                                genTraversable = TraversableLike$class.flatMap((TraversableLike)$inlThis1, (Function1)f$21, (CanBuildFrom)bf1);
                            }
                            return genTraversable;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.f$2 = stream;
                            this.nonEmptyPrefix$1 = var3_3;
                        }
                    });
                }
            } else {
                void bf1;
                stream = TraversableLike$class.flatMap((TraversableLike)$inlThis1, (Function1)f$21, (CanBuildFrom)bf1);
            }
            return stream;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StreamCanBuildFrom<A>
    extends GenTraversableFactory.GenericCanBuildFrom<A> {
        public StreamCanBuildFrom() {
            super(Stream$.MODULE$);
        }
    }
}

