/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.message;

import java.util.HashMap;
import org.bounce.message.DefaultPublisher;
import org.bounce.message.Message;
import org.bounce.message.Publisher;

public class Distributor {
    HashMap<Class, Publisher> publishers = new HashMap();

    public Distributor() {
        this.setPublisher(Message.class, new DefaultPublisher());
    }

    public void setPublisher(Class topic, Publisher publisher) {
        this.publishers.put(topic, publisher);
    }

    public Publisher getPublisher(Class topic) {
        return this.publishers.get(topic);
    }

    public void distribute(Message message) {
        this.handle(message.getClass(), message);
    }

    private void handle(Class topic, Message message) {
        Publisher publisher;
        if (topic != Message.class) {
            this.handle(topic.getSuperclass(), message);
        }
        if (!message.isConsumed() && (publisher = this.publishers.get(topic)) != null) {
            publisher.publish(message);
        }
    }
}

