/*
 * Decompiled with CFR 0.152.
 */
package opendap.Server;

import java.util.HashMap;
import java.util.Map;
import opendap.Server.BTFunction;
import opendap.Server.BoolFunction;
import opendap.Server.ServerSideFunction;
import opendap.dap.NoSuchFunctionException;

public class FunctionLibrary {
    protected Map boolFunctions;
    protected Map btFunctions;
    protected String prefix;

    public FunctionLibrary() {
        this("");
    }

    public FunctionLibrary(String prefix) {
        this.prefix = prefix;
        this.boolFunctions = new HashMap();
        this.btFunctions = new HashMap();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void add(ServerSideFunction function) {
        if (function instanceof BoolFunction) {
            this.boolFunctions.put(function.getName(), function);
        }
        if (function instanceof BTFunction) {
            this.btFunctions.put(function.getName(), function);
        }
    }

    public BoolFunction getBoolFunction(String name) throws NoSuchFunctionException {
        if (!this.boolFunctions.containsKey(name)) {
            this.loadNewFunction(name);
        }
        return (BoolFunction)this.boolFunctions.get(name);
    }

    public BTFunction getBTFunction(String name) throws NoSuchFunctionException {
        if (!this.btFunctions.containsKey(name)) {
            this.loadNewFunction(name);
        }
        return (BTFunction)this.btFunctions.get(name);
    }

    protected void loadNewFunction(String name) {
        try {
            String fullName = this.prefix + name;
            Class<?> value = Class.forName(fullName);
            if (ServerSideFunction.class.isAssignableFrom(value)) {
                this.add((ServerSideFunction)value.newInstance());
                return;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }
}

