/*
 * Decompiled with CFR 0.152.
 */
package opendap.Server.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import opendap.Server.CEEvaluator;
import opendap.Server.ClauseFactory;
import opendap.Server.ServerDDS;
import opendap.Server.ServerMethods;
import opendap.Server.parsers.AST;
import opendap.Server.parsers.ASTclause;
import opendap.Server.parsers.ASTconstant;
import opendap.Server.parsers.ASTconstraint;
import opendap.Server.parsers.ASTfcn;
import opendap.Server.parsers.ASTprojection;
import opendap.Server.parsers.ASTsegment;
import opendap.Server.parsers.ASTslice;
import opendap.Server.parsers.ASTvalue;
import opendap.Server.parsers.ASTvar;
import opendap.Server.parsers.Celex;
import opendap.Server.parsers.ExprParserConstants;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.parsers.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ceparse
implements ExprParserConstants {
    BaseTypeFactory factory;
    Celex lexstate = null;
    Ceparse parsestate = null;
    ASTconstraint ast = null;
    protected int cedebug = 0;
    List<AST> astnodeset = new ArrayList<AST>();

    public Ceparse() {
        this(null);
    }

    public Ceparse(BaseTypeFactory factory) {
        this.parsestate = this;
        this.ast = new ASTconstraint(this.astnodeset);
        if (factory == null) {
            throw new RuntimeException("Ceparse: no factory specified");
        }
        this.factory = factory;
    }

    public abstract boolean parse() throws ParseException;

    public abstract int getDebugLevel();

    public abstract void setDebugLevel(int var1);

    public abstract void setURL(String var1);

    public abstract String getURL();

    public abstract void setConstraint(String var1);

    public abstract String getConstraint();

    String strdup(String s) {
        return s;
    }

    void cleanup() {
        this.factory = null;
        this.lexstate = null;
    }

    public AST getAST() {
        return this.ast;
    }

    public List<AST> getASTnodeset() {
        return this.astnodeset;
    }

    void projections(Ceparse state, Object list0) throws ParseException {
        this.ast.projections = (List)list0;
    }

    void selections(Ceparse state, Object list0) throws ParseException {
        this.ast.selections = (List)list0;
    }

    Object projectionlist(Ceparse state, Object list0, Object decl) throws ParseException {
        ArrayList<ASTprojection> list = (ArrayList<ASTprojection>)list0;
        if (list == null) {
            list = new ArrayList<ASTprojection>();
        }
        list.add((ASTprojection)decl);
        return list;
    }

    Object projection(Ceparse state, Object varorfcn) throws ParseException {
        ASTprojection p = new ASTprojection(this.astnodeset);
        if (varorfcn instanceof ASTvar) {
            p.var = (ASTvar)varorfcn;
        } else {
            p.fcn = (ASTfcn)varorfcn;
        }
        return p;
    }

    Object segmentlist(Ceparse state, Object var0, Object decl) throws ParseException {
        ASTvar var = (ASTvar)var0;
        if (var == null) {
            var = new ASTvar(this.astnodeset);
        }
        var.segments.add((ASTsegment)decl);
        return var;
    }

    Object segment(Ceparse state, Object name, Object slices0) throws ParseException {
        ASTsegment segment = new ASTsegment(this.astnodeset);
        segment.name = (String)name;
        segment.slices = (List)slices0;
        return segment;
    }

    Object rangelist(Ceparse state, Object list0, Object decl) throws ParseException {
        ArrayList<ASTslice> list = (ArrayList<ASTslice>)list0;
        if (list == null) {
            list = new ArrayList<ASTslice>();
        }
        list.add((ASTslice)decl);
        return list;
    }

    Object range(Ceparse state, Object sstart, Object sstride, Object sstop) throws ParseException {
        ASTslice slice = new ASTslice(this.astnodeset);
        int start = -1;
        int stride = -1;
        int stop = -1;
        try {
            start = Integer.parseInt((String)sstart);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (sstop != null) {
            try {
                stop = Integer.parseInt((String)sstop);
            }
            catch (NumberFormatException nfe) {}
        } else {
            stop = start;
        }
        if (sstride != null) {
            try {
                stride = Integer.parseInt((String)sstride);
            }
            catch (NumberFormatException nfe) {}
        } else {
            stride = 1;
        }
        if (start < 0) {
            throw new ParseException("Illegal index for range first index");
        }
        if (stride <= 0) {
            throw new ParseException("Illegal index for range stride index");
        }
        if (stop < 0) {
            throw new ParseException("Illegal index for range last index");
        }
        if (stop < start) {
            throw new ParseException("Range last index less than first index");
        }
        slice.start = start;
        slice.stride = stride;
        slice.stop = stop;
        return slice;
    }

    Object range1(Ceparse state, Object rangenumber) throws ParseException {
        try {
            Long.parseLong((String)rangenumber);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Index is not an integer");
        }
        return rangenumber;
    }

    Object clauselist(Ceparse state, Object list0, Object decl) throws ParseException {
        ArrayList<ASTclause> list = (ArrayList<ASTclause>)list0;
        if (list == null) {
            list = new ArrayList<ASTclause>();
        }
        list.add((ASTclause)decl);
        return list;
    }

    Object sel_clause(Ceparse state, int selcase, Object lhs, Object relop0, Object values) throws ParseException {
        ASTclause sel = new ASTclause(this.astnodeset);
        sel.lhs = (ASTvalue)lhs;
        sel.operator = (Integer)relop0;
        sel.lhs = (ASTvalue)lhs;
        if (selcase == 2) {
            sel.rhs = new ArrayList<ASTvalue>();
            sel.rhs.add((ASTvalue)values);
        } else {
            sel.rhs = (List)values;
        }
        return sel;
    }

    Object indexpath(Ceparse state, Object list0, Object index) throws ParseException {
        ArrayList<ASTsegment> list = (ArrayList<ASTsegment>)list0;
        if (list == null) {
            list = new ArrayList<ASTsegment>();
        }
        list.add((ASTsegment)index);
        return list;
    }

    Object array_indices(Ceparse state, Object list0, Object indexno) throws ParseException {
        ArrayList<ASTslice> list = (ArrayList<ASTslice>)list0;
        if (list == null) {
            list = new ArrayList<ASTslice>();
        }
        long start = 0L;
        try {
            start = Long.parseLong((String)indexno);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        ASTslice slice = new ASTslice(this.astnodeset);
        slice.start = start;
        slice.stride = 1L;
        slice.stop = start;
        list.add(slice);
        return list;
    }

    Object index(Ceparse state, Object name, Object indices) throws ParseException {
        ASTsegment segment = new ASTsegment(this.astnodeset);
        segment.name = (String)name;
        segment.slices = (List)indices;
        return segment;
    }

    Object function(Ceparse state, Object fcnname, Object args) throws ParseException {
        ASTfcn fcn = new ASTfcn(this.astnodeset);
        fcn.fcnname = (String)fcnname;
        fcn.args = (List)args;
        return fcn;
    }

    Object arg_list(Ceparse state, Object list0, Object decl) throws ParseException {
        ArrayList<ASTvalue> list = (ArrayList<ASTvalue>)list0;
        if (list == null) {
            list = new ArrayList<ASTvalue>();
        }
        list.add((ASTvalue)decl);
        return list;
    }

    Object value_list(Ceparse state, Object list0, Object decl) throws ParseException {
        ArrayList<ASTvalue> list = (ArrayList<ASTvalue>)list0;
        if (list == null) {
            list = new ArrayList<ASTvalue>();
        }
        list.add((ASTvalue)decl);
        return list;
    }

    Object value(Ceparse state, Object o) throws ParseException {
        ASTvalue value = new ASTvalue(this.astnodeset);
        if (o instanceof ASTvar) {
            value.var = (ASTvar)o;
        } else if (o instanceof ASTfcn) {
            value.fcn = (ASTfcn)o;
        } else if (o instanceof ASTconstant) {
            value.constant = (ASTconstant)o;
        }
        return value;
    }

    Object var(Ceparse state, Object indexpath) throws ParseException {
        ASTvar var = new ASTvar(this.astnodeset);
        var.segments = (List)indexpath;
        return var;
    }

    Object constant(Ceparse state, Object path, int tag) throws ParseException {
        ASTconstant value = new ASTconstant(this.astnodeset);
        switch (tag) {
            case 259: {
                value.text = (String)path;
                value.tag = 23;
                break;
            }
            case 260: {
                try {
                    value.intvalue = Long.parseLong((String)path);
                    value.tag = 24;
                    break;
                }
                catch (NumberFormatException nfe) {
                    try {
                        value.floatvalue = Float.parseFloat((String)path);
                        value.tag = 25;
                        break;
                    }
                    catch (NumberFormatException nfe2) {
                        throw new ParseException("Illegal integer constant");
                    }
                }
            }
            default: {
                assert (false);
                break;
            }
        }
        return value;
    }

    void runProjectionFunction(String name, Vector btv) {
    }

    String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    void markStackedVariables(Stack s) {
        Stack bts = new Stack();
        while (!s.empty()) {
            bts.push(s.pop());
        }
        while (bts.size() > 1) {
            ServerMethods ct = (ServerMethods)bts.pop();
            ct.setProject(true, false);
        }
        ServerMethods bt = (ServerMethods)bts.pop();
        bt.setProject(true, true);
    }

    public boolean constraint_expression(CEEvaluator ceEval, BaseTypeFactory factory, ClauseFactory clauseFactory) throws DAP2Exception, ParseException {
        ServerDDS sdds = ceEval.getDDS();
        if (!this.parse()) {
            return false;
        }
        this.ast.init(ceEval, factory, clauseFactory, sdds, this.getASTnodeset());
        this.ast.walkConstraint();
        return true;
    }
}

