/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAPNode;
import opendap.dap.DArrayDimension;
import opendap.dap.DDS;
import opendap.dap.DVector;
import opendap.dap.InvalidDimensionException;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.DDSXMLParser;

public class DArray
extends DVector {
    protected Vector<DArrayDimension> dimVector = new Vector();

    public DArray() {
        this(null);
    }

    public DArray(String n) {
        super(n);
    }

    public String getTypeName() {
        return "Array";
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        if (this.dimVector.isEmpty()) {
            throw new BadSemanticsException("An array variable must have dimensions");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        this.getPrimitiveVector().printDecl(os, space, false, constrained);
        Enumeration<DArrayDimension> e = this.dimVector.elements();
        while (e.hasMoreElements()) {
            DArrayDimension d = e.nextElement();
            os.print("[");
            if (d.getEncodedName() != null) {
                os.print(d.getEncodedName() + " = ");
            }
            os.print(d.getSize() + "]");
        }
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter pw, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(pw, space, false);
            pw.print(" = ");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration<DArrayDimension> e = this.dimVector.elements();
        while (e.hasMoreElements()) {
            DArrayDimension d = e.nextElement();
            shape[i++] = d.getSize();
        }
        this.printArray(pw, 0, dims, shape, 0);
        if (print_decl_p) {
            pw.println(";");
        }
        pw.flush();
    }

    private int printArray(PrintWriter os, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            os.print("{");
            for (int i = 0; i < shape[offset] - 1; ++i) {
                this.getPrimitiveVector().printSingleVal(os, index++);
                os.print(", ");
            }
            this.getPrimitiveVector().printSingleVal(os, index++);
            os.print("}");
            return index;
        }
        os.print("{");
        for (int i = 0; i < shape[offset] - 1; ++i) {
            index = this.printArray(os, index, dims - 1, shape, offset + 1);
            os.print(",");
        }
        index = this.printArray(os, index, dims - 1, shape, offset + 1);
        os.print("}");
        return index;
    }

    public void appendDim(int size, String name) {
        DArrayDimension newDim = new DArrayDimension(size, name);
        this.dimVector.addElement(newDim);
        newDim.setContainer(this);
    }

    public void appendDim(int size) {
        this.appendDim(size, null);
    }

    public final Enumeration getDimensions() {
        return this.dimVector.elements();
    }

    public final int numDimensions() {
        return this.dimVector.size();
    }

    public void squeeze() {
        if (this.dimVector.size() == 1) {
            return;
        }
        Vector<DArrayDimension> squeezeCandidates = new Vector<DArrayDimension>();
        for (DArrayDimension dim : this.dimVector) {
            if (dim.getSize() != 1) continue;
            squeezeCandidates.add(dim);
        }
        if (squeezeCandidates.size() == this.dimVector.size()) {
            squeezeCandidates.remove(squeezeCandidates.size() - 1);
        }
        this.dimVector.removeAll(squeezeCandidates);
    }

    public DArrayDimension getDimension(int dimension) throws InvalidDimensionException {
        if (dimension < this.dimVector.size()) {
            return this.dimVector.get(dimension);
        }
        throw new InvalidDimensionException("DArray.getDimension(): Bad dimension request: dimension > # of dimensions");
    }

    public DArrayDimension getFirstDimension() {
        return this.dimVector.get(0);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Array");
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Array>");
    }

    public void printAsMapXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Map");
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Map>");
    }

    private void printXMLcore(PrintWriter pw, String pad, boolean constrained) {
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            Attribute a = this.getAttribute(aName);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        BaseType bt = null;
        PrimitiveVector pv = this.getPrimitiveVector();
        bt = pv instanceof BaseTypePrimitiveVector ? pv.getTemplate() : pv.getTemplate();
        String nameCache = bt.getEncodedName();
        bt.setEncodedName(null);
        bt.printXML(pw, pad + "\t", constrained);
        bt.setEncodedName(nameCache);
        Enumeration dae = this.getDimensions();
        while (dae.hasMoreElements()) {
            DArrayDimension dad = (DArrayDimension)dae.nextElement();
            int size = dad.getSize();
            String name = dad.getEncodedName();
            if (name == null) {
                pw.println(pad + "\t" + "<dimension size=\"" + size + "\"/>");
                continue;
            }
            pw.println(pad + "\t" + "<dimension name=\"" + DDSXMLParser.normalizeToXML(name) + "\" size=\"" + size + "\"/>");
        }
    }

    public void printConstraint(PrintWriter os) {
        if (this.getParent() != null && !(this.getParent() instanceof DDS)) {
            ((BaseType)this.getParent()).printConstraint(os);
            os.print(".");
        }
        os.print(this.getEncodedName());
        for (int i = 0; i < this.dimVector.size(); ++i) {
            DArrayDimension dim = this.dimVector.get(i);
            dim.printConstraint(os);
        }
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DArray a = (DArray)super.cloneDAG(map);
        a.dimVector = new Vector();
        for (int i = 0; i < this.dimVector.size(); ++i) {
            DArrayDimension d = this.dimVector.elementAt(i);
            DArrayDimension dclone = (DArrayDimension)DArray.cloneDAG(map, d);
            dclone.setContainer(a);
            a.dimVector.addElement(dclone);
        }
        return a;
    }
}

