/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.InflaterInputStream;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DataDDS;
import opendap.dap.DefaultFactory;
import opendap.dap.HeaderInputStream;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.parsers.ParseException;

public class DConnect {
    private boolean dumpStream = false;
    private boolean dumpDAS = false;
    private InputStream fileStream;
    private URLConnection connection;
    private String urlString;
    private String projString;
    private String selString;
    private boolean acceptDeflate;
    private ServerVersion ver;

    public void setServerVersion(int major, int minor) {
        System.out.println("ServerVersion made with int,int: " + major + "," + minor);
        this.ver = new ServerVersion(major, minor);
        System.out.println("ServerVersion.getMajor(): " + this.ver.getMajor());
        System.out.println("ServerVersion.getMinor(): " + this.ver.getMinor());
    }

    public DConnect(String urlString) throws FileNotFoundException {
        this(urlString, true);
    }

    public DConnect(String urlString, boolean acceptDeflate) throws FileNotFoundException {
        int ceIndex = urlString.indexOf(63);
        if (ceIndex != -1) {
            this.urlString = urlString.substring(0, ceIndex);
            String expr = urlString.substring(ceIndex);
            int selIndex = expr.indexOf(38);
            if (selIndex != -1) {
                this.projString = expr.substring(0, selIndex);
                this.selString = expr.substring(selIndex);
            } else {
                this.projString = expr;
                this.selString = "";
            }
        } else {
            this.urlString = urlString;
            this.selString = "";
            this.projString = "";
        }
        this.acceptDeflate = acceptDeflate;
        try {
            URL testURL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.fileStream = new FileInputStream(urlString);
        }
    }

    public DConnect(InputStream is) {
        this.fileStream = is;
    }

    public final boolean isLocal() {
        return this.fileStream != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private InputStream openConnection(URL url) throws IOException, DAP2Exception {
        this.connection = url.openConnection();
        if (this.acceptDeflate) {
            this.connection.setRequestProperty("Accept-Encoding", "deflate");
        }
        this.connection.connect();
        InputStream is = null;
        try {
            is = this.connection.getInputStream();
        }
        catch (NullPointerException e) {
            throw new DAP2Exception("Connection cannot be opened; connection is null");
        }
        catch (FileNotFoundException e) {
            throw new DAP2Exception("Connection cannot be opened; file not found");
        }
        if (is == null) {
            throw new DAP2Exception("Unable to open input stream");
        }
        String type = this.connection.getHeaderField("content-description");
        this.handleContentDesc(is, type);
        this.ver = new ServerVersion(this.connection);
        String encoding = this.connection.getContentEncoding();
        return this.handleContentEncoding(is, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAS getDAS() throws MalformedURLException, IOException, ParseException, DASException, DAP2Exception {
        InputStream is;
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            URL url = new URL(this.urlString + ".das" + this.projString + this.selString);
            if (this.dumpDAS) {
                System.out.println("--DConnect.getDAS to " + url);
                this.copy(url.openStream(), System.out);
                System.out.println("\n--DConnect.getDAS END1");
                this.dumpBytes(url.openStream(), 100);
                System.out.println("\n-DConnect.getDAS END2");
            }
            is = this.openConnection(url);
        }
        DAS das = new DAS();
        try {
            das.parse(is);
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return das;
    }

    public DDS getDDS() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDDS("");
    }

    private String getCompleteCE(String CE) {
        String localSelString;
        String localProjString;
        int selIndex = CE.indexOf(38);
        if (selIndex != -1) {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1, selIndex) : CE.substring(0, selIndex);
            localSelString = CE.substring(selIndex);
        } else {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1) : CE;
            localSelString = "";
        }
        String ce = this.projString;
        if (!localProjString.equals("")) {
            if (!ce.equals("") && localProjString.indexOf(44) != 0) {
                ce = ce + ",";
            }
            ce = ce + localProjString;
        }
        if (!this.selString.equals("")) {
            if (this.selString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + this.selString;
        }
        if (!localSelString.equals("")) {
            if (localSelString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + localSelString;
        }
        if (ce.indexOf(63) != 0) {
            ce = "?" + ce;
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDS getDDS(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        InputStream is;
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            URL url = new URL(this.urlString + ".dds" + this.getCompleteCE(CE));
            is = this.openConnection(url);
        }
        DDS dds = new DDS();
        dds.setURL(this.urlString);
        try {
            dds.parse(is);
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return dds;
    }

    public DDS getDDX() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDDX("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDS getDDX(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        InputStream is;
        URL url = new URL(this.urlString + ".ddx" + this.getCompleteCE(CE));
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            is = this.openConnection(url);
            System.out.println("Opened DDX URL: " + url);
        }
        DDS dds = new DDS();
        try {
            dds.parseXML(is, false);
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return dds;
    }

    public DataDDS getDataDDX() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX("", new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX(CE, new DefaultFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDDS getDataDDX(String CE, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        InputStream is;
        URL url = new URL(this.urlString + ".ddx" + this.getCompleteCE(CE));
        if (this.fileStream != null) {
            is = this.parseMime(this.fileStream);
        } else {
            is = this.openConnection(url);
            System.out.println("Opened DataDDX URL: " + url);
        }
        DataDDS dds = new DataDDS(this.ver, btf);
        try {
            dds.parseXML(is, false);
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return dds;
    }

    public DataDDS getData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        if (this.fileStream != null) {
            return this.getDataFromFileStream(this.fileStream, statusUI, btf);
        }
        URL url = new URL(this.urlString + ".dods" + this.getCompleteCE(CE));
        String errorMsg = "DConnect getData failed. URL: " + url;
        int errorCode = 0;
        try {
            return this.getDataFromUrl(url, statusUI, btf);
        }
        catch (DAP2Exception e) {
            errorMsg = e.getErrorMessage();
            errorCode = e.getErrorCode();
            return null;
        }
    }

    public DataDDS getDDXData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        if (this.fileStream != null) {
            throw new MalformedURLException("Cannont read DDX data from a file. The DDX client/server interaction requires 2 request/response pairs. File based input is not currently supported.");
        }
        URL url = new URL(this.urlString + ".ddx" + this.getCompleteCE(CE));
        String errorMsg = "DConnect getDDXData failed. URL: " + url;
        int errorCode = 0;
        int retry = 1;
        long backoff = 100L;
        while (true) {
            try {
                return this.getDDXDataFromURL(url, statusUI, btf);
            }
            catch (DAP2Exception e) {
                System.out.println("DConnect getData failed; retry (" + retry + "," + backoff + ") " + url);
                errorMsg = e.getErrorMessage();
                errorCode = e.getErrorCode();
                try {
                    Thread.currentThread();
                    Thread.sleep(backoff);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (retry == 5) {
                    throw new DAP2Exception(errorCode, errorMsg);
                }
                ++retry;
                backoff *= 2L;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataDDS getDataFromFileStream(InputStream fileStream, StatusUI statusUI, BaseTypeFactory btf) throws IOException, ParseException, DDSException, DAP2Exception {
        InputStream is = this.parseMime(fileStream);
        DataDDS dds = new DataDDS(this.ver, btf);
        dds.setURL(this.urlString);
        try {
            dds.parse(new HeaderInputStream(is));
            dds.readData(is, statusUI);
        }
        finally {
            is.close();
        }
        return dds;
    }

    public void getBlobData(DataDDS dds, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        ByteArrayOutputStream bos;
        boolean dumpStreamErr = false;
        System.out.println("dds.getBlobURL(): " + dds.getBlobContentID());
        if (dds.getBlobContentID() == null) {
            throw new MalformedURLException("Blob URL was 'null'. This may indicate that this OPeNDAP Server does not support the full use of DDX.");
        }
        URL blobURL = new URL(dds.getBlobContentID());
        System.out.println("Opening BLOB URL: " + blobURL);
        InputStream is = this.openConnection(blobURL);
        ByteArrayInputStream bis = null;
        if (this.dumpStream) {
            System.out.println("DConnect to " + blobURL);
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        if (dumpStreamErr) {
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        try {
            dds.readData(is, statusUI);
        }
        catch (Throwable e) {
            System.out.println("DConnect dds.readData problem with: " + blobURL + "\nStack Trace:");
            e.printStackTrace(System.out);
            if (dumpStreamErr) {
                System.out.println("DConnect dump " + blobURL);
                bis.reset();
                this.dump(bis);
            }
            throw new DAP2Exception("Connection problem when reading: " + blobURL + "\n" + "Error Message - " + e.toString());
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
    }

    public DataDDS getDDXDataFromURL(URL url, StatusUI statusUI, BaseTypeFactory btf) throws IOException, ParseException, DDSException, DAP2Exception {
        ByteArrayOutputStream bos;
        System.out.println("Opening DDX URL: " + url);
        InputStream is = this.openConnection(url);
        DataDDS dds = new DataDDS(this.ver, btf);
        boolean dumpStreamErr = false;
        ByteArrayInputStream bis = null;
        if (this.dumpStream) {
            System.out.println("DConnect to " + url);
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        if (dumpStreamErr) {
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        try {
            if (this.dumpStream) {
                bis.mark(1000);
                System.out.println("DConnect parse header: ");
                this.dump(bis);
                bis.reset();
            }
            dds.parseXML(is, false);
            if (this.dumpStream) {
                bis.mark(20);
                System.out.println("DConnect done with header, next bytes are: ");
                this.dumpBytes(bis, 20);
                bis.reset();
            }
        }
        catch (Throwable e) {
            System.out.println("DConnect ddx.parse problem with: " + url + "\nStack Trace:");
            e.printStackTrace(System.out);
            if (dumpStreamErr) {
                System.out.println("DConnect dump " + url);
                bis.reset();
                this.dump(bis);
            }
            throw new DAP2Exception("Connection problem when reading: " + url + "\n" + "Error Message - " + e.toString());
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        this.getBlobData(dds, statusUI);
        return dds;
    }

    public DataDDS getDataFromUrl(URL url, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        ByteArrayOutputStream bos;
        InputStream is = this.openConnection(url);
        DataDDS dds = new DataDDS(this.ver, btf);
        dds.setURL(this.urlString);
        boolean dumpStreamErr = false;
        ByteArrayInputStream bis = null;
        if (this.dumpStream) {
            System.out.println("DConnect to " + url);
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        if (dumpStreamErr) {
            bos = new ByteArrayOutputStream();
            this.copy(is, bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = bis;
        }
        String operation = "";
        try {
            if (this.dumpStream) {
                bis.mark(1000);
                System.out.println("DConnect parse header: ");
                this.dump(bis);
                bis.reset();
            }
            operation = "dds.parse";
            dds.parse(new HeaderInputStream(is));
            if (this.dumpStream) {
                bis.mark(20);
                System.out.println("DConnect done with header, next bytes are: ");
                this.dumpBytes(bis, 20);
                bis.reset();
            }
            operation = "dds.readData";
            dds.readData(is, statusUI);
        }
        catch (Throwable e) {
            System.out.println("DConnect " + operation + " problem with: " + url + "\nStack Trace:");
            e.printStackTrace(System.out);
            if (dumpStreamErr) {
                System.out.println("DConnect dump " + url);
                bis.reset();
                this.dump(bis);
            }
            throw new DAP2Exception("Connection problem when reading: " + url + "\n" + "Error Message - " + e.toString());
        }
        finally {
            is.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return dds;
    }

    private void copy(InputStream in, OutputStream out) {
        try {
            int bytesRead;
            byte[] buffer = new byte[256];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dump(InputStream is) throws IOException {
        DataInputStream d0 = new DataInputStream(is);
        BufferedReader d = new BufferedReader(new InputStreamReader(d0));
        try {
            String line;
            System.out.println("dump lines avail=" + is.available());
            do {
                line = d.readLine();
                System.out.println(line);
                if (null != line) continue;
                return;
            } while (!line.equals("Data:"));
            System.out.println("dump bytes avail=" + is.available());
            this.dumpBytes(is, 20);
        }
        catch (EOFException e) {
            // empty catch block
        }
    }

    private void dumpBytes(InputStream is, int n) {
        try {
            DataInputStream d = new DataInputStream(is);
            byte[] buff = new byte[1];
            for (int count = 0; count < n && d.available() > 0; ++count) {
                buff[0] = d.readByte();
                System.out.println(count + " " + buff[0] + " = " + new String(buff));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataDDS getData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData(CE, statusUI, new DefaultFactory());
    }

    public DataDDS getDDXData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDDXData(CE, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public final DataDDS getDDXData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDDXData("", statusUI, new DefaultFactory());
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    private InputStream parseMime(InputStream is) throws IOException, DAP2Exception {
        String line;
        DataInputStream d0 = new DataInputStream(is);
        BufferedReader d = new BufferedReader(new InputStreamReader(d0));
        String description = null;
        String encoding = null;
        this.ver = null;
        while (!(line = d.readLine()).equals("")) {
            int spaceIndex = line.indexOf(32);
            if (spaceIndex == -1) continue;
            String header = line.substring(0, spaceIndex);
            String value = line.substring(spaceIndex + 1);
            if (header.equals("XDAP:")) {
                this.ver = new ServerVersion(value, 1);
                continue;
            }
            if (header.equals("XDODS-Server:") && this.ver != null) {
                this.ver = new ServerVersion(value, 0);
                continue;
            }
            if (header.equals("Content-Description:")) {
                description = value;
                continue;
            }
            if (!header.equals("Content-Encoding:")) continue;
            encoding = value;
        }
        this.handleContentDesc(is, description);
        return this.handleContentEncoding(is, encoding);
    }

    private void handleContentDesc(InputStream is, String type) throws IOException, DAP2Exception {
        if (type != null && (type.equals("dods-error") || type.equals("dods_error"))) {
            DAP2Exception ds = new DAP2Exception();
            ds.parse(is);
            throw ds;
        }
    }

    private InputStream handleContentEncoding(InputStream is, String encoding) {
        if (encoding != null && encoding.equals("deflate")) {
            return new InflaterInputStream(is);
        }
        return is;
    }
}

