/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridCoordinate2D;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.RotatedLatLon;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class GridCoordSys
extends CoordinateSystem
implements GridCoordSystem {
    private static Logger log = LoggerFactory.getLogger(GridCoordSys.class);
    private ProjectionImpl proj;
    private GridCoordinate2D g2d;
    private CoordinateAxis horizXaxis;
    private CoordinateAxis horizYaxis;
    private CoordinateAxis1D vertZaxis;
    private CoordinateAxis1D ensembleAxis;
    private CoordinateAxis1DTime timeTaxis;
    private CoordinateAxis1DTime runTimeAxis;
    private VerticalCT vCT;
    private VerticalTransform vt;
    private Dimension timeDim;
    private boolean isDate;
    private boolean isLatLon;
    private Date[] timeDates;
    private CoordinateAxis1DTime[] timeAxisForRun;
    private ProjectionRect mapArea;
    private LatLonRect llbb;

    public static boolean isGridCoordSys(Formatter sbuff, CoordinateSystem cs, VariableEnhanced v) {
        CoordinateAxis yaxis;
        CoordinateAxis xaxis;
        if (cs.getRankDomain() < 2) {
            if (sbuff != null) {
                sbuff.format("%s: domain rank < 2%n", cs.getName());
            }
            return false;
        }
        if (!cs.isLatLon()) {
            if (cs.getXaxis() == null || cs.getYaxis() == null) {
                if (sbuff != null) {
                    sbuff.format("%s: NO Lat,Lon or X,Y axis%n", cs.getName());
                }
                return false;
            }
            if (null == cs.getProjection()) {
                if (sbuff != null) {
                    sbuff.format("%s: NO projection found%n", cs.getName());
                }
                return false;
            }
        }
        if (cs.isGeoXY()) {
            xaxis = cs.getXaxis();
            yaxis = cs.getYaxis();
            ProjectionImpl p = cs.getProjection();
            if (!(p instanceof RotatedPole)) {
                if (!SimpleUnit.kmUnit.isCompatible(xaxis.getUnitsString()) && sbuff != null) {
                    sbuff.format("%s: X axis units are not convertible to km%n", cs.getName());
                }
                if (!SimpleUnit.kmUnit.isCompatible(yaxis.getUnitsString()) && sbuff != null) {
                    sbuff.format("%s: Y axis units are not convertible to km%n", cs.getName());
                }
            }
        } else {
            xaxis = cs.getLonAxis();
            yaxis = cs.getLatAxis();
        }
        if (xaxis.getRank() > 2 || yaxis.getRank() > 2) {
            if (sbuff != null) {
                sbuff.format("%s: X or Y axis rank must be <= 2%n", cs.getName());
            }
            return false;
        }
        List<Dimension> xyDomain = CoordinateSystem.makeDomain(new CoordinateAxis[]{xaxis, yaxis});
        if (xyDomain.size() < 2) {
            if (sbuff != null) {
                sbuff.format("%s: X and Y axis must have 2 or more dimensions%n", cs.getName());
            }
            return false;
        }
        ArrayList<CoordinateAxis> testAxis = new ArrayList<CoordinateAxis>();
        testAxis.add(xaxis);
        testAxis.add(yaxis);
        CoordinateAxis z = cs.getHeightAxis();
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getPressureAxis();
        }
        if (z == null || !(z instanceof CoordinateAxis1D)) {
            z = cs.getZaxis();
        }
        if (z != null && !(z instanceof CoordinateAxis1D)) {
            if (sbuff != null) {
                sbuff.format("%s: Z axis must be 1D%n", cs.getName());
            }
            return false;
        }
        if (z != null) {
            testAxis.add(z);
        }
        CoordinateAxis t = cs.getTaxis();
        CoordinateAxis rt = cs.findAxis(AxisType.RunTime);
        if (rt != null && !(rt instanceof CoordinateAxis1D)) {
            if (sbuff != null) {
                sbuff.format("%s: RunTime axis must be 1D%n", cs.getName());
            }
            return false;
        }
        if (t != null && !(t instanceof CoordinateAxis1D) && t.getRank() != 0) {
            if (rt == null) {
                if (sbuff != null) {
                    sbuff.format("%s: T axis must be 1D%n", cs.getName());
                }
                return false;
            }
            if (t.getRank() != 2) {
                if (sbuff != null) {
                    sbuff.format("%s: Time axis must be 2D when used with RunTime dimension%n", cs.getName());
                }
                return false;
            }
            CoordinateAxis1D rt1D = (CoordinateAxis1D)rt;
            if (!rt1D.getDimension(0).equals(t.getDimension(0))) {
                if (sbuff != null) {
                    sbuff.format("%s: Time axis must use RunTime dimension%n", cs.getName());
                }
                return false;
            }
        }
        if (t != null) {
            testAxis.add(t);
        } else if (rt != null) {
            testAxis.add(rt);
        }
        CoordinateAxis ens = cs.getEnsembleAxis();
        if (ens != null) {
            testAxis.add(ens);
        }
        if (v != null) {
            ArrayList<Dimension> testDomain = new ArrayList<Dimension>();
            for (CoordinateAxis axis : testAxis) {
                for (Dimension dim : axis.getDimensions()) {
                    if (testDomain.contains(dim)) continue;
                    testDomain.add(dim);
                }
            }
            if (!CoordinateSystem.isSubset(v.getDimensionsAll(), testDomain)) {
                if (sbuff != null) {
                    sbuff.format(" NOT complete\n", new Object[0]);
                }
                return false;
            }
        }
        return true;
    }

    public static GridCoordSys makeGridCoordSys(Formatter sbuff, CoordinateSystem cs, VariableEnhanced v) {
        if (sbuff != null) {
            sbuff.format(" ", new Object[0]);
            v.getNameAndDimensions(sbuff, false, true);
            sbuff.format(" check CS %s: ", cs.getName());
        }
        if (GridCoordSys.isGridCoordSys(sbuff, cs, v)) {
            GridCoordSys gcs = new GridCoordSys(cs, sbuff);
            if (sbuff != null) {
                sbuff.format(" OK\n", new Object[0]);
            }
            return gcs;
        }
        return null;
    }

    public GridCoordSys(CoordinateSystem cs, Formatter sbuff) {
        block27: {
            CoordinateAxis1D rtAxis;
            CoordinateAxis z_oneD;
            this.isDate = false;
            this.isLatLon = false;
            this.timeDates = null;
            this.mapArea = null;
            this.llbb = null;
            this.ds = cs.getNetcdfDataset();
            if (cs.isGeoXY()) {
                this.horizXaxis = this.xAxis = cs.getXaxis();
                this.horizYaxis = this.yAxis = cs.getYaxis();
                ProjectionImpl p = cs.getProjection();
                if (!(p instanceof RotatedPole) && !(p instanceof RotatedLatLon)) {
                    this.horizXaxis = this.convertUnits(this.horizXaxis);
                    this.horizYaxis = this.convertUnits(this.horizYaxis);
                }
            } else if (cs.isLatLon()) {
                this.horizXaxis = this.lonAxis = cs.getLonAxis();
                this.horizYaxis = this.latAxis = cs.getLatAxis();
                this.isLatLon = true;
            } else {
                throw new IllegalArgumentException("CoordinateSystem is not geoReferencing");
            }
            this.coordAxes.add(this.horizXaxis);
            this.coordAxes.add(this.horizYaxis);
            ProjectionImpl projOrig = cs.getProjection();
            if (projOrig != null) {
                this.proj = projOrig.constructCopy();
                this.proj.setDefaultMapArea(this.getBoundingBox());
            }
            if ((z_oneD = (this.hAxis = cs.getHeightAxis())) == null || !(z_oneD instanceof CoordinateAxis1D)) {
                z_oneD = this.pAxis = cs.getPressureAxis();
            }
            if (z_oneD == null || !(z_oneD instanceof CoordinateAxis1D)) {
                z_oneD = this.zAxis = cs.getZaxis();
            }
            if (z_oneD != null && !(z_oneD instanceof CoordinateAxis1D)) {
                z_oneD = null;
            }
            CoordinateAxis z_best = this.hAxis;
            if (this.pAxis != null && (z_best == null || z_best.getRank() <= this.pAxis.getRank())) {
                z_best = this.pAxis;
            }
            if (this.zAxis != null && (z_best == null || z_best.getRank() <= this.zAxis.getRank())) {
                z_best = this.zAxis;
            }
            if (z_oneD == null && z_best != null && sbuff != null) {
                sbuff.format("GridCoordSys needs a 1D Coordinate, instead has %s%n", z_best.getNameAndDimensions());
            }
            if (z_oneD != null) {
                this.vertZaxis = (CoordinateAxis1D)z_oneD;
                this.coordAxes.add(this.vertZaxis);
            } else {
                this.zAxis = null;
                this.pAxis = null;
                this.hAxis = null;
            }
            CoordinateAxis t = cs.getTaxis();
            if (t != null) {
                if (t instanceof CoordinateAxis1D) {
                    try {
                        this.timeTaxis = t instanceof CoordinateAxis1DTime ? (CoordinateAxis1DTime)t : CoordinateAxis1DTime.factory(this.ds, t, sbuff);
                        this.tAxis = this.timeTaxis;
                        this.coordAxes.add(this.timeTaxis);
                        this.timeDim = t.getDimension(0);
                    }
                    catch (Exception e) {
                        if (sbuff != null) {
                            sbuff.format("Error reading time coord= %s err= %s\n", t.getFullName(), e.getMessage());
                        }
                        log.error("Error reading time coord= " + t.getFullName(), (Throwable)e);
                    }
                } else {
                    this.tAxis = t;
                    this.timeTaxis = null;
                    this.coordAxes.add(t);
                }
            }
            this.ensembleAxis = (CoordinateAxis1D)cs.findAxis(AxisType.Ensemble);
            if (null != this.ensembleAxis) {
                this.coordAxes.add(this.ensembleAxis);
            }
            if (null != (rtAxis = (CoordinateAxis1D)cs.findAxis(AxisType.RunTime))) {
                try {
                    this.runTimeAxis = rtAxis instanceof CoordinateAxis1DTime ? (CoordinateAxis1DTime)rtAxis : CoordinateAxis1DTime.factory(this.ds, rtAxis, sbuff);
                    this.coordAxes.add(this.runTimeAxis);
                }
                catch (IOException e) {
                    if (sbuff == null) break block27;
                    sbuff.format("Error reading runtime coord= %s err= %s\n", t.getFullName(), e.getMessage());
                }
            }
        }
        List<CoordinateTransform> list = cs.getCoordinateTransforms();
        for (CoordinateTransform ct : list) {
            if (!(ct instanceof VerticalCT)) continue;
            this.vCT = (VerticalCT)ct;
            break;
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(cs.getCoordinateTransforms());
        for (CoordinateAxis axis : this.coordAxes) {
            List<Dimension> dims = axis.getDimensions();
            for (Dimension dim : dims) {
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
    }

    public GridCoordSys(GridCoordSys from, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        this(from, null, null, t_range, z_range, y_range, x_range);
    }

    public GridCoordSys(GridCoordSys from, Range rt_range, Range e_range, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        CoordinateAxis1DTime rtaxis;
        CoordinateAxis1D eaxis;
        CoordinateAxis1D zaxis;
        this.isDate = false;
        this.isLatLon = false;
        this.timeDates = null;
        this.mapArea = null;
        this.llbb = null;
        CoordinateAxis xaxis = from.getXHorizAxis();
        CoordinateAxis yaxis = from.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            this.horizXaxis = x_range == null ? xaxis1 : xaxis1.section(x_range);
            this.horizYaxis = y_range == null ? yaxis : yaxis1.section(y_range);
        } else if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && from.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            this.horizXaxis = lon_axis.section(y_range, x_range);
            this.horizYaxis = lat_axis.section(y_range, x_range);
        } else {
            throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
        }
        if (from.isGeoXY()) {
            this.xAxis = this.horizXaxis;
            this.yAxis = this.horizYaxis;
        } else {
            this.lonAxis = this.horizXaxis;
            this.latAxis = this.horizYaxis;
            this.isLatLon = true;
        }
        this.coordAxes.add(this.horizXaxis);
        this.coordAxes.add(this.horizYaxis);
        ProjectionImpl projOrig = from.getProjection();
        if (projOrig != null) {
            this.proj = projOrig.constructCopy();
            this.proj.setDefaultMapArea(this.getBoundingBox());
        }
        if ((zaxis = from.getVerticalAxis()) != null) {
            this.vertZaxis = z_range == null ? zaxis : zaxis.section(z_range);
            this.coordAxes.add(this.vertZaxis);
        }
        if (from.getVerticalCT() != null) {
            VerticalTransform vtFrom = from.getVerticalTransform();
            if (vtFrom != null) {
                this.vt = vtFrom.subset(t_range, z_range, y_range, x_range);
            }
            this.vCT = from.getVerticalCT();
        }
        if ((eaxis = from.getEnsembleAxis()) != null) {
            this.ensembleAxis = e_range == null ? eaxis : eaxis.section(e_range);
            this.coordAxes.add(this.ensembleAxis);
        }
        CoordinateAxis taxis = from.getTimeAxis();
        CoordinateAxis1DTime taxis1D = null;
        if (taxis != null) {
            if (taxis instanceof CoordinateAxis1DTime) {
                taxis1D = (CoordinateAxis1DTime)taxis;
                this.timeTaxis = t_range == null ? taxis1D : (CoordinateAxis1DTime)taxis1D.section(t_range);
                this.tAxis = this.timeTaxis;
                this.coordAxes.add(this.timeTaxis);
                this.timeDim = this.timeTaxis.getDimension(0);
            } else {
                if (rt_range == null && t_range == null) {
                    this.tAxis = taxis;
                } else {
                    Section timeSection = new Section().appendRange(rt_range).appendRange(t_range);
                    this.tAxis = (CoordinateAxis)taxis.section(timeSection);
                }
                this.coordAxes.add(this.tAxis);
            }
        }
        if ((rtaxis = from.getRunTimeAxis()) != null) {
            if (taxis1D != null) {
                Dimension tDim = taxis1D.getDimension(0);
                Dimension rtDim = rtaxis.getDimension(0);
                if (tDim.getName().equals(rtDim.getName())) {
                    CoordinateAxis1DTime coordinateAxis1DTime = this.runTimeAxis = t_range == null ? rtaxis : (CoordinateAxis1DTime)rtaxis.section(t_range);
                }
            }
            if (this.runTimeAxis == null) {
                this.runTimeAxis = rt_range == null ? rtaxis : (CoordinateAxis1DTime)rtaxis.section(rt_range);
            }
            this.coordAxes.add(this.runTimeAxis);
        }
        Collections.sort(this.coordAxes, new CoordinateAxis.AxisComparator());
        this.name = GridCoordSys.makeName(this.coordAxes);
        this.coordTrans = new ArrayList<CoordinateTransform>(from.getCoordinateTransforms());
        for (CoordinateAxis axis : this.coordAxes) {
            List<Dimension> dims = axis.getDimensions();
            for (Dimension dim : dims) {
                dim.setShared(true);
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
    }

    private CoordinateAxis convertUnits(CoordinateAxis axis) {
        Array data;
        double factor;
        String units = axis.getUnitsString();
        SimpleUnit axisUnit = SimpleUnit.factory(units);
        try {
            factor = axisUnit.convertTo(1.0, SimpleUnit.kmUnit);
        }
        catch (IllegalArgumentException e) {
            log.warn("convertUnits failed", (Throwable)e);
            return axis;
        }
        if (factor == 1.0) {
            return axis;
        }
        try {
            data = axis.read();
        }
        catch (IOException e) {
            log.warn("convertUnits read failed", (Throwable)e);
            return axis;
        }
        DataType dtype = axis.getDataType();
        if (dtype.isFloatingPoint()) {
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                ii.setDoubleCurrent(factor * ii.getDoubleNext());
            }
            CoordinateAxis newAxis = axis.copyNoCache();
            newAxis.setCachedData(data, false);
            newAxis.setUnitsString("km");
            return newAxis;
        }
        Array newData = Array.factory(DataType.DOUBLE, axis.getShape());
        IndexIterator newi = newData.getIndexIterator();
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext() && newi.hasNext()) {
            newi.setDoubleNext(factor * ii.getDoubleNext());
        }
        CoordinateAxis newAxis = axis.copyNoCache();
        newAxis.setDataType(DataType.DOUBLE);
        newAxis.setCachedData(newData, false);
        newAxis.setUnitsString("km");
        return newAxis;
    }

    @Override
    public VerticalTransform getVerticalTransform() {
        return this.vt;
    }

    @Override
    public VerticalCT getVerticalCT() {
        return this.vCT;
    }

    void makeVerticalTransform(GridDataset gds, Formatter parseInfo) {
        if (this.vt != null) {
            return;
        }
        if (this.vCT == null) {
            return;
        }
        this.vt = this.vCT.makeVerticalTransform(gds.getNetcdfDataset(), this.timeDim);
        if (this.vt == null) {
            if (parseInfo != null) {
                parseInfo.format("  - ERR can't make VerticalTransform = %s\n", this.vCT.getVerticalTransformType());
            }
        } else if (parseInfo != null) {
            parseInfo.format("  - VerticalTransform = %s\n", this.vCT.getVerticalTransformType());
        }
    }

    @Override
    public CoordinateAxis getXHorizAxis() {
        return this.horizXaxis;
    }

    @Override
    public CoordinateAxis getYHorizAxis() {
        return this.horizYaxis;
    }

    @Override
    public CoordinateAxis1D getVerticalAxis() {
        return this.vertZaxis;
    }

    @Override
    public CoordinateAxis getTimeAxis() {
        return this.tAxis;
    }

    @Override
    public CoordinateAxis1DTime getTimeAxis1D() {
        return this.timeTaxis;
    }

    @Override
    public CoordinateAxis1DTime getRunTimeAxis() {
        return this.runTimeAxis;
    }

    @Override
    public CoordinateAxis1D getEnsembleAxis() {
        return this.ensembleAxis;
    }

    @Override
    public ProjectionImpl getProjection() {
        return this.proj;
    }

    @Override
    public void setProjectionBoundingBox() {
        if (this.proj != null) {
            this.proj.setDefaultMapArea(this.getBoundingBox());
        }
    }

    public Date[] getTimeDates() {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        return this.timeDates;
    }

    @Override
    public boolean isLatLon() {
        return this.isLatLon;
    }

    public boolean isDate() {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        return this.isDate;
    }

    @Override
    public boolean isZPositive() {
        if (this.vertZaxis == null) {
            return false;
        }
        if (this.vertZaxis.getPositive() != null) {
            return this.vertZaxis.getPositive().equalsIgnoreCase("up");
        }
        if (this.vertZaxis.getAxisType() == AxisType.Height) {
            return true;
        }
        return this.vertZaxis.getAxisType() != AxisType.Pressure;
    }

    @Override
    public boolean isRegularSpatial() {
        if (!this.isRegularSpatial(this.getXHorizAxis())) {
            return false;
        }
        return this.isRegularSpatial(this.getYHorizAxis());
    }

    private boolean isRegularSpatial(CoordinateAxis axis) {
        if (axis == null) {
            return true;
        }
        if (!(axis instanceof CoordinateAxis1D)) {
            return false;
        }
        return ((CoordinateAxis1D)axis).isRegular();
    }

    @Override
    public int[] findXYindexFromCoord(double x_coord, double y_coord, int[] result) {
        if (result == null) {
            result = new int[2];
        }
        if (this.horizXaxis instanceof CoordinateAxis1D && this.horizYaxis instanceof CoordinateAxis1D) {
            result[0] = ((CoordinateAxis1D)this.horizXaxis).findCoordElement(x_coord);
            result[1] = ((CoordinateAxis1D)this.horizYaxis).findCoordElement(y_coord);
            return result;
        }
        if (this.horizXaxis instanceof CoordinateAxis2D && this.horizYaxis instanceof CoordinateAxis2D) {
            int[] result2;
            boolean found;
            if (this.g2d == null) {
                this.g2d = new GridCoordinate2D((CoordinateAxis2D)this.horizYaxis, (CoordinateAxis2D)this.horizXaxis);
            }
            if (found = this.g2d.findCoordElement(y_coord, x_coord, result2 = new int[2])) {
                result[0] = result2[1];
                result[1] = result2[0];
            } else {
                result[0] = -1;
                result[1] = -1;
            }
            return result;
        }
        throw new IllegalStateException("GridCoordSystem.findXYindexFromCoord");
    }

    @Override
    public int[] findXYindexFromCoordBounded(double x_coord, double y_coord, int[] result) {
        if (result == null) {
            result = new int[2];
        }
        if (this.horizXaxis instanceof CoordinateAxis1D && this.horizYaxis instanceof CoordinateAxis1D) {
            result[0] = ((CoordinateAxis1D)this.horizXaxis).findCoordElementBounded(x_coord);
            result[1] = ((CoordinateAxis1D)this.horizYaxis).findCoordElementBounded(y_coord);
            return result;
        }
        if (this.horizXaxis instanceof CoordinateAxis2D && this.horizYaxis instanceof CoordinateAxis2D) {
            if (this.g2d == null) {
                this.g2d = new GridCoordinate2D((CoordinateAxis2D)this.horizYaxis, (CoordinateAxis2D)this.horizXaxis);
            }
            int[] result2 = new int[2];
            this.g2d.findCoordElement(y_coord, x_coord, result2);
            result[0] = result2[1];
            result[1] = result2[0];
            return result;
        }
        throw new IllegalStateException("GridCoordSystem.findXYindexFromCoord");
    }

    @Override
    public int[] findXYindexFromLatLon(double lat, double lon, int[] result) {
        ProjectionImpl dataProjection = this.getProjection();
        ProjectionPoint pp = dataProjection.latLonToProj(new LatLonPointImpl(lat, lon), new ProjectionPointImpl());
        return this.findXYindexFromCoord(pp.getX(), pp.getY(), result);
    }

    @Override
    public int[] findXYindexFromLatLonBounded(double lat, double lon, int[] result) {
        ProjectionImpl dataProjection = this.getProjection();
        ProjectionPoint pp = dataProjection.latLonToProj(new LatLonPointImpl(lat, lon), new ProjectionPointImpl());
        return this.findXYindexFromCoordBounded(pp.getX(), pp.getY(), result);
    }

    public int[] findXYCoordElement(double x_coord, double y_coord, int[] result) {
        return this.findXYindexFromCoord(x_coord, y_coord, result);
    }

    @Override
    public DateRange getDateRange() {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        if (this.isDate) {
            Date[] dates = this.getTimeDates();
            return new DateRange(dates[0], dates[dates.length - 1]);
        }
        return null;
    }

    @Override
    public boolean hasTimeAxis() {
        return this.tAxis != null;
    }

    @Override
    public boolean hasTimeAxis1D() {
        return this.timeTaxis != null;
    }

    @Override
    public CoordinateAxis1DTime getTimeAxisForRun(int run_index) {
        if (!this.hasTimeAxis() || this.hasTimeAxis1D()) {
            return null;
        }
        int nruns = (int)this.runTimeAxis.getSize();
        if (run_index < 0 || run_index >= nruns) {
            throw new IllegalArgumentException("getTimeAxisForRun index out of bounds= " + run_index);
        }
        if (this.timeAxisForRun == null) {
            this.timeAxisForRun = new CoordinateAxis1DTime[nruns];
        }
        if (this.timeAxisForRun[run_index] == null) {
            this.timeAxisForRun[run_index] = this.makeTimeAxisForRun(run_index);
        }
        return this.timeAxisForRun[run_index];
    }

    private CoordinateAxis1DTime makeTimeAxisForRun(int run_index) {
        try {
            VariableDS section = (VariableDS)this.tAxis.slice(0, run_index);
            return CoordinateAxis1DTime.factory(this.ds, section, null);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public DateUnit getDateUnit() throws Exception {
        String tUnits = this.getTimeAxis().getUnitsString();
        return new DateUnit(tUnits);
    }

    public TimeUnit getTimeResolution() throws Exception {
        if (!this.isRegular()) {
            return null;
        }
        CoordinateAxis1DTime taxis = (CoordinateAxis1DTime)this.getTimeAxis();
        String tUnits = taxis.getUnitsString();
        StringTokenizer stoker = new StringTokenizer(tUnits);
        double tResolution = taxis.getIncrement();
        return new TimeUnit(tResolution, stoker.nextToken());
    }

    @Override
    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            if (this.horizXaxis == null || !this.horizXaxis.isNumeric() || this.horizYaxis == null || !this.horizYaxis.isNumeric()) {
                return null;
            }
            if (!(this.horizXaxis instanceof CoordinateAxis1D) || !(this.horizYaxis instanceof CoordinateAxis1D)) {
                this.mapArea = new ProjectionRect(this.horizXaxis.getMinValue(), this.horizYaxis.getMinValue(), this.horizXaxis.getMaxValue(), this.horizYaxis.getMaxValue());
            } else {
                CoordinateAxis1D xaxis1 = (CoordinateAxis1D)this.horizXaxis;
                CoordinateAxis1D yaxis1 = (CoordinateAxis1D)this.horizYaxis;
                this.mapArea = new ProjectionRect(xaxis1.getCoordEdge(0), yaxis1.getCoordEdge(0), xaxis1.getCoordEdge((int)xaxis1.getSize()), yaxis1.getCoordEdge((int)yaxis1.getSize()));
            }
        }
        return this.mapArea;
    }

    @Override
    public LatLonPoint getLatLon(int xindex, int yindex) {
        double y;
        CoordinateAxis2D horiz2D;
        double x;
        CoordinateAxis1D horiz1D;
        if (this.horizXaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)this.horizXaxis;
            x = horiz1D.getCoordValue(xindex);
        } else {
            horiz2D = (CoordinateAxis2D)this.horizXaxis;
            x = horiz2D.getCoordValue(yindex, xindex);
        }
        if (this.horizYaxis instanceof CoordinateAxis1D) {
            horiz1D = (CoordinateAxis1D)this.horizYaxis;
            y = horiz1D.getCoordValue(yindex);
        } else {
            horiz2D = (CoordinateAxis2D)this.horizYaxis;
            y = horiz2D.getCoordValue(yindex, xindex);
        }
        return this.isLatLon() ? new LatLonPointImpl(y, x) : this.getLatLon(x, y);
    }

    public LatLonPoint getLatLon(double xcoord, double ycoord) {
        ProjectionImpl dataProjection = this.getProjection();
        return dataProjection.projToLatLon(new ProjectionPointImpl(xcoord, ycoord), new LatLonPointImpl());
    }

    @Override
    public LatLonRect getLatLonBoundingBox() {
        if (this.llbb == null) {
            if (this.isLatLon()) {
                double startLat = this.horizYaxis.getMinValue();
                double startLon = this.horizXaxis.getMinValue();
                double deltaLat = this.horizYaxis.getMaxValue() - startLat;
                double deltaLon = this.horizXaxis.getMaxValue() - startLon;
                LatLonPointImpl llpt = new LatLonPointImpl(startLat, startLon);
                this.llbb = new LatLonRect(llpt, deltaLat, deltaLon);
            } else {
                ProjectionImpl dataProjection = this.getProjection();
                ProjectionRect bb = this.getBoundingBox();
                LatLonPointImpl llpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerLeftPoint(), new LatLonPointImpl());
                LatLonPointImpl lrpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getLowerRightPoint(), new LatLonPointImpl());
                LatLonPointImpl urpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperRightPoint(), new LatLonPointImpl());
                LatLonPointImpl ulpt = (LatLonPointImpl)dataProjection.projToLatLon(bb.getUpperLeftPoint(), new LatLonPointImpl());
                boolean includesNorthPole = false;
                int[] resultNP = new int[2];
                resultNP = this.findXYindexFromLatLon(90.0, 0.0, null);
                if (resultNP[0] != -1 && resultNP[1] != -1) {
                    includesNorthPole = true;
                }
                boolean includesSouthPole = false;
                int[] resultSP = new int[2];
                resultSP = this.findXYindexFromLatLon(-90.0, 0.0, null);
                if (resultSP[0] != -1 && resultSP[1] != -1) {
                    includesSouthPole = true;
                }
                if (includesNorthPole && !includesSouthPole) {
                    this.llbb = new LatLonRect(llpt, new LatLonPointImpl(90.0, 0.0));
                    this.llbb.extend(lrpt);
                    this.llbb.extend(urpt);
                    this.llbb.extend(ulpt);
                } else if (includesSouthPole && !includesNorthPole) {
                    this.llbb = new LatLonRect(llpt, new LatLonPointImpl(-90.0, -180.0));
                    this.llbb.extend(lrpt);
                    this.llbb.extend(urpt);
                    this.llbb.extend(ulpt);
                } else {
                    double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
                    double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
                    double lonMin = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
                    double lonMax = this.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
                    llpt.set(latMin, lonMin);
                    urpt.set(latMax, lonMax);
                    this.llbb = new LatLonRect(llpt, urpt);
                }
            }
        }
        return this.llbb;
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    public List<Range> getLatLonBoundingBox(LatLonRect rect) throws InvalidRangeException {
        return this.getRangesFromLatLonRect(rect);
    }

    @Override
    public List<Range> getRangesFromLatLonRect(LatLonRect rect) throws InvalidRangeException {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonRect bb;
        ProjectionImpl proj = this.getProjection();
        if (proj != null && !(proj instanceof VerticalPerspectiveView) && !(proj instanceof MSGnavigation) && null == (rect = (bb = this.getLatLonBoundingBox()).intersect(rect))) {
            throw new InvalidRangeException("Request Bounding box does not intersect Grid");
        }
        CoordinateAxis xaxis = this.getXHorizAxis();
        CoordinateAxis yaxis = this.getYHorizAxis();
        if (this.isLatLon()) {
            LatLonPointImpl llpt = rect.getLowerLeftPoint();
            LatLonPointImpl urpt = rect.getUpperRightPoint();
            LatLonPointImpl lrpt = rect.getLowerRightPoint();
            LatLonPointImpl ulpt = rect.getUpperLeftPoint();
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
            double minLon = xaxis.getMinValue();
            minx = LatLonPointImpl.lonNormalFrom(minx, minLon);
            maxx = LatLonPointImpl.lonNormalFrom(maxx, minLon);
        } else {
            ProjectionRect prect = this.getProjection().latLonToProjBB(rect);
            minx = prect.getMinPoint().getX();
            miny = prect.getMinPoint().getY();
            maxx = prect.getMaxPoint().getX();
            maxy = prect.getMaxPoint().getY();
        }
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)xaxis;
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)yaxis;
            int minxIndex = xaxis1.findCoordElementBounded(minx);
            int minyIndex = yaxis1.findCoordElementBounded(miny);
            int maxxIndex = xaxis1.findCoordElementBounded(maxx);
            int maxyIndex = yaxis1.findCoordElementBounded(maxy);
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(Math.min(minyIndex, maxyIndex), Math.max(minyIndex, maxyIndex)));
            list.add(new Range(Math.min(minxIndex, maxxIndex), Math.max(minxIndex, maxxIndex)));
            return list;
        }
        if (xaxis instanceof CoordinateAxis2D && yaxis instanceof CoordinateAxis2D && this.isLatLon()) {
            CoordinateAxis2D lon_axis = (CoordinateAxis2D)xaxis;
            CoordinateAxis2D lat_axis = (CoordinateAxis2D)yaxis;
            int[] shape = lon_axis.getShape();
            int nj = shape[0];
            int ni = shape[1];
            int mini = Integer.MAX_VALUE;
            int minj = Integer.MAX_VALUE;
            int maxi = -1;
            int maxj = -1;
            for (int j = 0; j < nj; ++j) {
                for (int i = 0; i < ni; ++i) {
                    double lat = lat_axis.getCoordValue(j, i);
                    double lon = lon_axis.getCoordValue(j, i);
                    if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                    if (i > maxi) {
                        maxi = i;
                    }
                    if (i < mini) {
                        mini = i;
                    }
                    if (j > maxj) {
                        maxj = j;
                    }
                    if (j >= minj) continue;
                    minj = j;
                }
            }
            if (mini > maxi || minj > maxj) {
                mini = 0;
                minj = 0;
                maxi = -1;
                maxj = -1;
            }
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(minj, maxj));
            list.add(new Range(mini, maxi));
            return list;
        }
        throw new IllegalArgumentException("must be 1D or 2D/LatLon ");
    }

    @Override
    public String toString() {
        Formatter buff = new Formatter();
        buff.format("(%s) ", this.getName());
        if (this.runTimeAxis != null) {
            buff.format("rt=%s,", this.runTimeAxis.getFullName());
        }
        if (this.ensembleAxis != null) {
            buff.format("ens=%s,", this.ensembleAxis.getFullName());
        }
        if (this.timeTaxis != null) {
            buff.format("t=%s,", this.timeTaxis.getFullName());
        }
        if (this.vertZaxis != null) {
            buff.format("z=%s,", this.vertZaxis.getFullName());
        }
        if (this.horizYaxis != null) {
            buff.format("y=%s,", this.horizYaxis.getFullName());
        }
        if (this.horizXaxis != null) {
            buff.format("x=%s,", this.horizXaxis.getFullName());
        }
        if (this.proj != null) {
            buff.format("  Projection: %s %s", this.proj.getName(), this.proj.getClassName());
        }
        return buff.toString();
    }

    private void makeTimes() {
        if (this.timeTaxis != null && this.timeTaxis.getSize() > 0L) {
            this.timeDates = this.timeTaxis.getTimeDates();
            this.isDate = true;
            return;
        }
        if (this.tAxis != null && this.tAxis.getSize() > 0L && this.makeTimes2D()) {
            return;
        }
        this.timeDates = new Date[0];
        this.isDate = false;
    }

    private boolean makeTimes1D() {
        int n = (int)this.timeTaxis.getSize();
        this.timeDates = new Date[n];
        try {
            DateUnit du = null;
            String units = this.timeTaxis.getUnitsString();
            if (units != null) {
                du = new DateUnit(units);
            }
            for (int i = 0; i < n; ++i) {
                Date d;
                this.timeDates[i] = d = du.makeDate(this.timeTaxis.getCoordValue(i));
            }
            this.isDate = true;
            return true;
        }
        catch (Exception e) {
            if (this.timeTaxis.getDataType() == DataType.STRING || this.timeTaxis.getDataType() == DataType.CHAR) {
                DateFormatter formatter = new DateFormatter();
                for (int i = 0; i < n; ++i) {
                    String coordValue = this.timeTaxis.getCoordName(i);
                    Date d = formatter.getISODate(coordValue);
                    if (d == null) {
                        this.isDate = false;
                        return false;
                    }
                    this.timeDates[i] = d;
                }
                this.isDate = true;
                return true;
            }
            return false;
        }
    }

    private boolean makeTimes2D() {
        HashSet<Date> dates;
        block9: {
            dates = new HashSet<Date>();
            try {
                DateFormatter formatter;
                Date d;
                Array data;
                String units = this.tAxis.getUnitsString();
                if (units != null && SimpleUnit.isDateUnit(units) && this.tAxis.getDataType().isNumeric()) {
                    DateUnit du = new DateUnit(units);
                    data = this.tAxis.read();
                    data.resetLocalIterator();
                    while (data.hasNext()) {
                        d = du.makeDate(data.nextDouble());
                        if (d == null) continue;
                        dates.add(d);
                    }
                    this.isDate = true;
                    break block9;
                }
                if (this.tAxis.getDataType() == DataType.STRING) {
                    formatter = new DateFormatter();
                    data = this.tAxis.read();
                    data.resetLocalIterator();
                    while (data.hasNext()) {
                        d = formatter.getISODate((String)data.next());
                        if (d == null) continue;
                        dates.add(d);
                    }
                    this.isDate = true;
                    break block9;
                }
                if (this.tAxis.getDataType() == DataType.CHAR) {
                    formatter = new DateFormatter();
                    data = (ArrayChar)this.tAxis.read();
                    ArrayChar.StringIterator iter = ((ArrayChar)data).getStringIterator();
                    while (iter.hasNext()) {
                        Date d2 = formatter.getISODate(iter.next());
                        if (d2 == null) continue;
                        dates.add(d2);
                    }
                    this.isDate = true;
                    break block9;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        int n = dates.size();
        Date[] dd = dates.toArray(new Date[n]);
        List<Date> dateList = Arrays.asList(dd);
        Collections.sort(dateList);
        this.timeDates = new Date[n];
        int count = 0;
        for (Date d : dateList) {
            this.timeDates[count++] = d;
        }
        return true;
    }

    public List<NamedObject> getLevels() {
        if (this.vertZaxis == null) {
            return new ArrayList<NamedObject>(0);
        }
        int n = (int)this.vertZaxis.getSize();
        ArrayList<NamedObject> levels = new ArrayList<NamedObject>(n);
        for (int i = 0; i < n; ++i) {
            levels.add(new NamedAnything(this.vertZaxis.getCoordName(i), this.vertZaxis.getUnitsString()));
        }
        return levels;
    }

    public String getLevelName(int index) {
        if (this.vertZaxis == null || index < 0 || (long)index >= this.vertZaxis.getSize()) {
            throw new IllegalArgumentException("getLevelName = " + index);
        }
        return this.vertZaxis.getCoordName(index).trim();
    }

    public int getLevelIndex(String name) {
        if (this.vertZaxis == null || name == null) {
            return -1;
        }
        int i = 0;
        while ((long)i < this.vertZaxis.getSize()) {
            if (this.vertZaxis.getCoordName(i).trim().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<NamedObject> getTimes() {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        if (!this.isDate) {
            return null;
        }
        DateFormatter df = new DateFormatter();
        ArrayList<NamedObject> times = new ArrayList<NamedObject>(this.timeDates.length);
        for (Date d : this.timeDates) {
            times.add(new NamedAnything(df.toDateTimeStringISO(d), "date/time"));
        }
        return times;
    }

    public String getTimeName(int index) {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        if (!this.isDate) {
            return null;
        }
        if (index < 0 || index >= this.timeDates.length) {
            throw new IllegalArgumentException("getTimeName = " + index);
        }
        DateFormatter df = new DateFormatter();
        return df.toDateTimeStringISO(this.timeDates[index]);
    }

    public int getTimeIndex(String name) {
        if (this.timeDates == null) {
            this.makeTimes();
        }
        if (!this.isDate) {
            return -1;
        }
        DateFormatter df = new DateFormatter();
        for (int i = 0; i < this.timeDates.length; ++i) {
            if (!df.toDateTimeStringISO(this.timeDates[i]).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findTimeIndexFromDate(Date d) {
        if (this.timeTaxis == null) {
            return -1;
        }
        return this.timeTaxis.findTimeIndexFromDate(d);
    }

    public static void main(String[] args) throws IOException {
        GridDataset gds = GridDataset.open(args[0]);
        GridDatatype grid = gds.findGridDatatype(args[1]);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        CoordinateAxis yAxis = gcs.getXHorizAxis();
        CoordinateAxis1D zAxis = gcs.getVerticalAxis();
        if (gcs.hasTimeAxis1D()) {
            CoordinateAxis1DTime tAxis = gcs.getTimeAxis1D();
        } else if (gcs.hasTimeAxis()) {
            CoordinateAxis tAxis = gcs.getTimeAxis();
        }
    }
}

