/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class MultipleAxisChart
extends JPanel {
    JFreeChart chart;
    private int axisNum = 1;
    private static final Color[] colors = new Color[]{Color.black, Color.red, Color.blue, Color.green};

    public MultipleAxisChart(String title1, String xaxis1, String yaxis1, TimeSeries series1) {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(series1);
        this.chart = ChartFactory.createTimeSeriesChart((String)title1, (String)xaxis1, (String)yaxis1, (XYDataset)dataset1, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.getRangeAxis().setFixedDimension(15.0);
        this.setLayout(new BorderLayout());
        this.add((Component)new ChartPanel(this.chart), "Center");
    }

    public void addSeries(String yaxisName, TimeSeries series) {
        NumberAxis axis2 = new NumberAxis(yaxisName);
        axis2.setFixedDimension(10.0);
        axis2.setAutoRangeIncludesZero(false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRangeAxis(this.axisNum, (ValueAxis)axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        plot.setDataset(this.axisNum, (XYDataset)dataset);
        plot.mapDatasetToRangeAxis(this.axisNum, this.axisNum);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        plot.setRenderer(this.axisNum, (XYItemRenderer)renderer2);
        ++this.axisNum;
    }

    public void finish(Dimension preferredSize) {
        ChartUtilities.applyCurrentTheme((JFreeChart)this.chart);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        for (int i = 0; i < this.axisNum; ++i) {
            XYItemRenderer renderer = plot.getRenderer(i);
            renderer.setSeriesPaint(0, (Paint)colors[i]);
            ValueAxis axis = plot.getRangeAxis(i);
            axis.setLabelPaint((Paint)colors[i]);
            axis.setTickLabelPaint((Paint)colors[i]);
        }
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(preferredSize);
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
    }

    private static TimeSeries createDataset(String name, double base, RegularTimePeriod start, int count) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name), start.getClass());
        RegularTimePeriod period = start;
        double value = base;
        for (int i = 0; i < count; ++i) {
            series.add(period, value);
            period = period.next();
            value *= 1.0 + (Math.random() - 0.495) / 10.0;
        }
        return series;
    }

    public static void main(String[] args) {
        TimeSeries dataset1 = MultipleAxisChart.createDataset("Series 1", 100.0, (RegularTimePeriod)new Minute(), 200);
        MultipleAxisChart demo = new MultipleAxisChart("Multiple Axis Demo 1", "Time of Day", "Primary Range Axis", dataset1);
        TimeSeries dataset2 = MultipleAxisChart.createDataset("Series 2", 1000.0, (RegularTimePeriod)new Minute(), 170);
        demo.addSeries("Range Axis 2", dataset2);
        TimeSeries dataset3 = MultipleAxisChart.createDataset("Series 3", 10000.0, (RegularTimePeriod)new Minute(), 170);
        demo.addSeries("Range Axis 3", dataset3);
        TimeSeries dataset4 = MultipleAxisChart.createDataset("Series 4", 25.0, (RegularTimePeriod)new Minute(), 200);
        demo.addSeries("Range Axis 4", dataset4);
        demo.finish(new Dimension(600, 270));
        JFrame frame = new JFrame("Demovabulous ");
        frame.getContentPane().add((Component)demo, "Center");
        frame.setSize(640, 480);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

