/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionSpecParser;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Record;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribReportPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted recordTable;
    private BeanTableSorted gdsTable;
    private BeanTableSorted productTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane reportPane;

    public GribReportPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.reportPane = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.reportPane, "Center");
    }

    public void setCollection(String spec, boolean useIndex, Report which) throws IOException {
        Formatter f = new Formatter();
        f.format("%s %s %s%n", new Object[]{spec, useIndex, which});
        CollectionSpecParser parser = new CollectionSpecParser(spec, f);
        f.format("top dir = %s%n", parser.getTopDir());
        f.format("filter = %s%n", parser.getFilter());
        this.reportPane.setText(f.toString());
        File top = new File(parser.getTopDir());
        if (!top.exists()) {
            f.format("top dir = %s does not exist%n", parser.getTopDir());
        } else {
            switch (which) {
                case uniqueGds: {
                    this.doUniqueGds(f, parser, useIndex);
                    break;
                }
                case localUseSection: {
                    this.doLocalUseSection(f, parser, useIndex);
                }
            }
        }
        this.reportPane.setText(f.toString());
        this.reportPane.gotoTop();
    }

    private void doLocalUseSection(Formatter f, CollectionSpecParser parser, boolean useIndex) throws IOException {
        f.format("Show Local Use Section%n", new Object[0]);
        File top = new File(parser.getTopDir());
        for (File file : top.listFiles(new GribFilter(parser.getFilter()))) {
            f.format(" %s%n", file.getPath());
            this.doLocalUseSection(file, f, useIndex);
        }
    }

    private void doLocalUseSection(File ff, Formatter f, boolean useIndex) throws IOException {
        f.format("File = %s%n", ff);
        RandomAccessFile raf = new RandomAccessFile(ff.getPath(), "r");
        Grib2Input reader = new Grib2Input(raf);
        raf.seek(0L);
        raf.order(0);
        reader.scan(false, false);
        for (Grib2Record gr : reader.getRecords()) {
            byte[] lus = gr.getLocalUseSection();
            if (lus == null) {
                f.format(" %10d == none%n", gr.getPdsOffset());
                continue;
            }
            f.format(" %10d == %s%n", gr.getPdsOffset(), Misc.showBytes(lus));
        }
        raf.close();
    }

    private void doUniqueGds(Formatter f, CollectionSpecParser parser, boolean useIndex) throws IOException {
        f.format("Show Unique GDS%n", new Object[0]);
        File top = new File(parser.getTopDir());
        HashMap<Long, GdsList> gdsSet = new HashMap<Long, GdsList>();
        for (File file : top.listFiles(new GribFilter(parser.getFilter()))) {
            f.format(" %s%n", file.getPath());
            this.doUniqueGds(file, useIndex, gdsSet);
        }
        for (GdsList gdsl : gdsSet.values()) {
            f.format("%nGDS = %d x %d (%d) %n", gdsl.gds.getNy(), gdsl.gds.getNx(), gdsl.gds.getGdtn());
            for (FileCount fc : gdsl.fileList) {
                f.format("  %5d %s%n", fc.count, fc.f.getPath());
            }
        }
    }

    private void doUniqueGds(File ff, boolean useIndex, Map<Long, GdsList> gdsSet) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(ff.getPath(), "r");
        Grib2Input reader = new Grib2Input(raf);
        raf.seek(0L);
        raf.order(0);
        reader.scan(false, false);
        for (Grib2Record gr : reader.getRecords()) {
            FileCount fc;
            Grib2GridDefinitionSection gds = gr.getGDS();
            long crc = gds.getGdsVars().calcCRC();
            GdsList gdsl = gdsSet.get(crc);
            if (gdsl == null) {
                gdsl = new GdsList(gds);
                gdsSet.put(crc, gdsl);
            }
            if ((fc = gdsl.contains(ff)) == null) {
                fc = new FileCount(ff);
                gdsl.fileList.add(fc);
            }
            ++fc.count;
        }
        raf.close();
    }

    public void save() {
    }

    public void showInfo(Formatter f) {
    }

    private class FileCount {
        File f;
        int count = 0;

        private FileCount(File f) {
            this.f = f;
        }
    }

    private class GdsList {
        Grib2GridDefinitionSection gds;
        List<FileCount> fileList = new ArrayList<FileCount>();

        private GdsList(Grib2GridDefinitionSection gds) {
            this.gds = gds;
        }

        FileCount contains(File f) {
            for (FileCount fc : this.fileList) {
                if (!fc.f.equals(f)) continue;
                return fc;
            }
            return null;
        }
    }

    private class GribFilter
    implements FileFilter {
        Pattern pattern;

        GribFilter(Pattern p) {
            this.pattern = p;
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return matcher.matches();
        }
    }

    public static enum Report {
        localUseSection,
        uniqueGds;

    }
}

