/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import opendap.dap.AttributeBadValueException;
import opendap.dap.AttributeTable;
import opendap.dap.DAPNode;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.parsers.DDSXMLParser;

public class Attribute
extends DAPNode {
    private static final boolean _Debug = false;
    private static final boolean DebugValueChecking = false;
    public static final int UNKNOWN = 0;
    public static final int ALIAS = 1;
    public static final int CONTAINER = 2;
    public static final int BYTE = 3;
    public static final int INT16 = 4;
    public static final int UINT16 = 5;
    public static final int INT32 = 6;
    public static final int UINT32 = 7;
    public static final int FLOAT32 = 8;
    public static final int FLOAT64 = 9;
    public static final int STRING = 10;
    public static final int URL = 11;
    private int type;
    private Object attr;

    public Attribute(AttributeTable container) {
        this.type = 2;
        this.attr = container;
    }

    public Attribute(int type, String clearname, String value, boolean check) throws AttributeBadValueException {
        super(clearname);
        if (check) {
            Attribute.dispatchCheckValue(type, value);
        }
        this.type = type;
        this.attr = new Vector();
        ((Vector)this.attr).addElement(value);
    }

    public Attribute(int type, String clearname, String value) throws AttributeBadValueException {
        super(clearname);
        Attribute.dispatchCheckValue(type, value);
        this.type = type;
        this.attr = new Vector();
        ((Vector)this.attr).addElement(value);
    }

    public Attribute(String clearname, AttributeTable container) {
        super(clearname);
        this.type = 2;
        this.attr = container;
    }

    public Attribute(String clearname, int type) throws IllegalArgumentException {
        super(clearname);
        this.type = type;
        if (type == 2) {
            throw new IllegalArgumentException("Can't construct an Attribute(CONTAINER)");
        }
        this.attr = new Vector();
    }

    public final String getTypeString() {
        switch (this.type) {
            case 2: {
                return "Container";
            }
            case 1: {
                return "Alias";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Int16";
            }
            case 5: {
                return "UInt16";
            }
            case 6: {
                return "Int32";
            }
            case 7: {
                return "UInt32";
            }
            case 8: {
                return "Float32";
            }
            case 9: {
                return "Float64";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "Url";
            }
        }
        return "";
    }

    public static final int getTypeVal(String s) {
        if (s.equalsIgnoreCase("Container")) {
            return 2;
        }
        if (s.equalsIgnoreCase("Byte")) {
            return 3;
        }
        if (s.equalsIgnoreCase("Int16")) {
            return 4;
        }
        if (s.equalsIgnoreCase("UInt16")) {
            return 5;
        }
        if (s.equalsIgnoreCase("Int32")) {
            return 6;
        }
        if (s.equalsIgnoreCase("UInt32")) {
            return 7;
        }
        if (s.equalsIgnoreCase("Float32")) {
            return 8;
        }
        if (s.equalsIgnoreCase("Float64")) {
            return 9;
        }
        if (s.equalsIgnoreCase("String")) {
            return 10;
        }
        if (s.equalsIgnoreCase("URL")) {
            return 11;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContainer() {
        return this.type == 2;
    }

    public boolean isAlias() {
        return false;
    }

    public AttributeTable getContainer() throws NoSuchAttributeException {
        this.checkContainerUsage();
        return (AttributeTable)this.attr;
    }

    public AttributeTable getContainerN() {
        return this.attr instanceof AttributeTable ? (AttributeTable)this.attr : null;
    }

    public Enumeration getValues() throws NoSuchAttributeException {
        this.checkVectorUsage();
        return ((Vector)this.attr).elements();
    }

    public Iterator getValuesIterator() {
        return this.attr instanceof Vector ? ((Vector)this.attr).iterator() : null;
    }

    public int getNumVal() throws NoSuchAttributeException {
        this.checkVectorUsage();
        return ((Vector)this.attr).size();
    }

    public String getValueAt(int index) throws NoSuchAttributeException {
        this.checkVectorUsage();
        return (String)((Vector)this.attr).elementAt(index);
    }

    public String getValueAtN(int index) {
        if (!(this.attr instanceof Vector)) {
            return null;
        }
        return (String)((Vector)this.attr).elementAt(index);
    }

    public void appendValue(String value) throws NoSuchAttributeException, AttributeBadValueException {
        this.checkVectorUsage();
        this.appendValue(value, true);
    }

    public void appendValue(String value, boolean check) throws NoSuchAttributeException, AttributeBadValueException {
        this.checkVectorUsage();
        if (check) {
            Attribute.dispatchCheckValue(this.type, value);
        }
        ((Vector)this.attr).addElement(value);
    }

    public void deleteValueAt(int index) throws AttributeBadValueException, NoSuchAttributeException {
        this.checkVectorUsage();
        ((Vector)this.attr).removeElementAt(index);
    }

    private static void dispatchCheckValue(int type, String value) throws AttributeBadValueException {
        switch (type) {
            case 3: {
                if (Attribute.checkByte(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Byte value.");
            }
            case 4: {
                if (Attribute.checkShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int16 value.");
            }
            case 5: {
                if (Attribute.checkUShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt16 value.");
            }
            case 6: {
                if (Attribute.checkInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int32 value.");
            }
            case 7: {
                if (Attribute.checkUInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt32 value.");
            }
            case 8: {
                if (Attribute.checkFloat(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float32 value.");
            }
            case 9: {
                if (Attribute.checkDouble(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float64 value.");
            }
        }
    }

    private static final boolean checkByte(String s) throws AttributeBadValueException {
        try {
            short val = Short.parseShort(s);
            return val <= 255 && val >= 0;
        }
        catch (NumberFormatException e) {
            throw new AttributeBadValueException("`" + s + "' is not a Byte value.");
        }
    }

    private static final boolean checkShort(String s) {
        try {
            short val = Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkUShort(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 65535L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkInt(String s) {
        try {
            int val = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkUInt(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 0xFFFFFFFFL;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkFloat(String s) {
        try {
            float val = Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }

    private static final boolean checkDouble(String s) {
        try {
            double val = Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }

    private void checkVectorUsage() throws NoSuchAttributeException {
        if (!(this.attr instanceof Vector)) {
            throw new NoSuchAttributeException("The Attribute '" + this.getEncodedName() + "' is a container. " + "It's contents are Attribues, not values.");
        }
    }

    private void checkContainerUsage() throws NoSuchAttributeException {
        if (!(this.attr instanceof AttributeTable)) {
            throw new NoSuchAttributeException("The Attribute '" + this.getEncodedName() + "' is not a container (AttributeTable)." + "It's content is made up of values, not other Attributes.");
        }
    }

    public void print(PrintWriter os, String pad) {
        if (this.attr instanceof AttributeTable) {
            ((AttributeTable)this.attr).print(os, pad);
        } else {
            os.print(pad + this.getTypeString() + " " + this.getEncodedName() + " ");
            Enumeration es = ((Vector)this.attr).elements();
            while (es.hasMoreElements()) {
                String val = (String)es.nextElement();
                if (this.type == 10) {
                    String quoted = "\"" + Attribute.escapify(val) + "\"";
                    for (int i = 0; i < quoted.length(); ++i) {
                        os.print(quoted.charAt(i));
                    }
                } else {
                    os.print(val);
                }
                if (!es.hasMoreElements()) continue;
                os.print(", ");
            }
            os.println(";");
        }
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))), pad);
    }

    public final void print(PrintWriter os) {
        this.print(os, "");
    }

    public final void print(OutputStream os) {
        this.print(os, "");
    }

    public void printXML(OutputStream os) {
        this.printXML(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printXML(pw, pad);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (this.attr instanceof AttributeTable) {
            ((AttributeTable)this.attr).printXML(pw, pad, constrained);
        } else {
            pw.println(pad + "<Attribute name=\"" + DDSXMLParser.normalizeToXML(this.getEncodedName()) + "\" type=\"" + this.getTypeString() + "\">");
            Enumeration es = ((Vector)this.attr).elements();
            while (es.hasMoreElements()) {
                String val = (String)es.nextElement();
                pw.println(pad + "\t" + "<value>" + DDSXMLParser.normalizeToXML(val) + "</value>");
            }
            pw.println(pad + "</Attribute>");
        }
        pw.flush();
    }

    static String fixnan(String value) {
        if (value.equalsIgnoreCase("nan.")) {
            value = "nan";
        } else if (value.equalsIgnoreCase("inf.")) {
            value = "inf";
        }
        return value;
    }

    static String escapify(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        buf.append(c);
                        break;
                    }
                    default: {
                        buf.append(String.format("0x%04x", c));
                        break;
                    }
                }
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\\') {
                buf.append('\\');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        Attribute a = (Attribute)super.cloneDAG(map);
        a.attr = this.type == 2 ? (AttributeTable)Attribute.cloneDAG(map, (AttributeTable)this.attr) : ((Vector)this.attr).clone();
        return a;
    }
}

