/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Formatter;
import opendap.dap.ConstraintException;
import opendap.dap.DAPNode;
import opendap.dap.DArray;
import opendap.dap.InvalidDimensionException;

public final class DArrayDimension
extends DAPNode {
    private Slice decl = null;
    private Slice projection = null;
    private DArray container = null;

    public DArrayDimension(int size, String name) {
        super(name);
        this.decl = new Slice(size, 0, 1, size - 1);
    }

    public int getSize() {
        return this.projection != null ? this.projection.size : this.decl.size;
    }

    public void setSize(int size) {
        this.decl.size = size;
    }

    public int getStart() {
        return this.projection != null ? this.projection.start : this.decl.start;
    }

    public int getStride() {
        return this.projection != null ? this.projection.stride : this.decl.stride;
    }

    public int getStop() {
        return this.projection != null ? this.projection.stop : this.decl.stop;
    }

    public void setContainer(DArray da) {
        this.container = da;
    }

    public DArray getContainer() {
        return this.container;
    }

    public void printConstraint(PrintWriter os) {
        String buf = "[";
        buf = this.getSize() == 1 && this.getStart() == this.getStop() ? buf + "" + this.getStart() : (this.getStride() == 1 ? buf + this.getStart() + ":" + this.getStop() : buf + this.getStart() + ":" + this.getStride() + ":" + this.getStop());
        buf = buf + "]";
        os.print(buf);
    }

    public void setProjection(int start, int stride, int stop) throws InvalidDimensionException {
        if (this.projection != null && (this.getSize() != start || this.getStride() != stride || this.getStop() != stop)) {
            Formatter f = new Formatter();
            f.format(" [%d:%d:%d (%d)] != [%d:%d:%d (%d)]", start, stride, stop, this.projection.size, this.projection.start, this.projection.stride, this.projection.stop, this.projection.size);
            throw new ConstraintException("Implementation limitation: muliple references to same variable in single constraint: " + this.container.getLongName() + f.toString());
        }
        String msg = "DArrayDimension.setProjection: Bad Projection Request: ";
        if (start < 0) {
            throw new InvalidDimensionException(msg + "start < 0");
        }
        if (stride <= 0) {
            throw new InvalidDimensionException(msg + "stride <= 0");
        }
        if (stop < 0) {
            throw new InvalidDimensionException(msg + "stop < 0");
        }
        if (start < this.decl.start) {
            throw new InvalidDimensionException(msg + "start (" + start + ") < size (" + this.decl.size + ") for " + this._name);
        }
        if (stop >= this.decl.size) {
            throw new InvalidDimensionException(msg + "stop >= size: " + stop + ":" + this.decl.size);
        }
        if (stop < start) {
            throw new InvalidDimensionException(msg + "stop < start");
        }
        this.projection = new Slice(start, stride, stop);
    }

    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DArrayDimension d = (DArrayDimension)super.cloneDAG(map);
        if (this.container != null) {
            d.container = (DArray)DArrayDimension.cloneDAG(map, this.container);
        }
        return d;
    }

    public static class Slice {
        public int size;
        public int start;
        public int stride;
        public int stop;

        public Slice(int size, int start, int stride, int stop) {
            this.size = size;
            this.start = start;
            this.stride = stride;
            this.stop = stop;
        }

        public Slice(int start, int stride, int stop) {
            this(0, start, stride, stop);
            this.size = 1 + (stop - start) / stride;
        }
    }
}

