/*
 * Decompiled with CFR 0.152.
 */
package scalala.tensor.mutable;

import scala.Function1$class;
import scala.PartialFunction$class;
import scala.Serializable;
import scala.collection.mutable.Map;
import scalala.operators.MutableNumericOps$class;
import scalala.operators.NumericOps$class;
import scalala.scalar.Scalar;
import scalala.tensor.DomainFunction$class;
import scalala.tensor.domain.IterableDomain;
import scalala.tensor.mutable.TensorLike;
import scalala.tensor.mutable.TensorLike$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Tensor<K, V>
extends scalala.tensor.Tensor<K, V>,
TensorLike<K, V, IterableDomain<K>, Tensor<K, V>> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Impl<K, V>
    implements Tensor<K, V> {
        private final IterableDomain<K> domain;
        private final Map<K, V> data;
        private final Scalar<V> scalar;

        @Override
        public IterableDomain<K> domain() {
            return this.domain;
        }

        public Map<K, V> data() {
            return this.data;
        }

        @Override
        public Scalar<V> scalar() {
            return this.scalar;
        }

        @Override
        public int size() {
            return this.domain().size();
        }

        @Override
        public V apply(K key) {
            this.checkKey(key);
            return (V)this.data().getOrElse(key, new Serializable(this){
                public static final long serialVersionUID;
                private final Impl $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final V apply() {
                    return this.$outer.scalar().zero();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public void update(K key, V value) {
            this.checkKey(key);
            this.data().update(key, value);
        }

        public Impl(IterableDomain<K> domain, Map<K, V> data, Scalar<V> scalar) {
            this.domain = domain;
            this.data = data;
            this.scalar = scalar;
            Function1$class.$init$(this);
            PartialFunction$class.$init$(this);
            DomainFunction$class.$init$(this);
            NumericOps$class.$init$(this);
            scalala.tensor.TensorLike$class.$init$(this);
            MutableNumericOps$class.$init$(this);
            TensorLike$class.$init$(this);
        }
    }
}

