/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.oaiplugin.delegates;

import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.oaiplugin.GCUBEDocumentIterator;
import org.gcube.contentmanagement.contentmanager.oaiplugin.MetadataFormat;
import org.gcube.contentmanagement.contentmanager.oaiplugin.delegates.ReadManager;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import uiuc.oai.OAIRecord;
import uiuc.oai.OAIRecordList;

public class ReadManagerSet
extends ReadManager {
    static GCUBELog logger = new GCUBELog(ReadManagerSet.class);
    private static final long serialVersionUID = 1916139485852324208L;
    private String relatedSetId;

    public ReadManagerSet(String oid, String repositoryURI, MetadataFormat metadataFormat, String contentXpath, String relatedSetId, String ... alternativesXPath) {
        super(repositoryURI, metadataFormat, contentXpath, alternativesXPath);
        this.relatedSetId = relatedSetId;
    }

    @Override
    public RemoteIterator<GDoc> get(Predicate projection) throws Exception, GCUBEException {
        long start = System.currentTimeMillis();
        OAIRecordList recordList = this.getOAIHarvester().listRecords(this.getDefaultMdFormat().getPrefix(), null, null, this.relatedSetId);
        logger.trace((Object)("the time to get the list of records is " + (System.currentTimeMillis() - start) / 1000L + "secs"));
        return new GCUBEDocumentIterator(recordList, this, projection);
    }

    @Override
    public GDoc internalGet(String id) throws Exception {
        OAIRecord record = this.getOAIHarvester().getRecord(id, this.getDefaultMdFormat().getPrefix());
        boolean containsSet = false;
        for (int i = 0; i < record.getSetSpecCount(); ++i) {
            if (!record.getSetSpec(i).equals(this.relatedSetId)) continue;
            containsSet = true;
            break;
        }
        if (!containsSet) {
            throw new Exception("the object is not in this collection");
        }
        return this.extractDoc(record, null);
    }

    @Override
    protected Iterator<OAIRecord> getList() throws Exception {
        return new Iterator<OAIRecord>(){
            OAIRecordList listRecord = null;

            @Override
            public boolean hasNext() {
                try {
                    if (this.listRecord == null) {
                        this.listRecord = ReadManagerSet.this.getOAIHarvester().listIdentifiers(null, null, ReadManagerSet.this.relatedSetId, ReadManagerSet.this.getDefaultMdFormat().getPrefix());
                    }
                    if (this.listRecord.moreItems()) {
                        this.listRecord.moveNext();
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)"error getting the list of records", (Throwable)e);
                    return false;
                }
            }

            @Override
            public OAIRecord next() {
                return this.listRecord.getCurrentItem();
            }

            @Override
            public void remove() {
            }
        };
    }
}

