/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model;

import java.util.List;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.CreateReferenceCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.DeleteInfoObjectCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.SMSCommand;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.UpdateInfoObjectCommand;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceDescription;

public class WriteUtil {
    public static void printCreationParameters(CreateInfoObjectCommand parameters) {
        WriteUtil.printCreationParameters("", parameters);
    }

    public static void printCreationParameters(String indentation, CreateInfoObjectCommand parameters) {
        CreateInfoObjectReferencesProperties createParams = parameters.getParameters();
        System.out.println(indentation + createParams.getName() + " " + createParams.getType() + " " + createParams.getFileLocation());
        System.out.println(indentation + "\tProperties:");
        for (CreatePropertyDescription property : createParams.getProperties()) {
            System.out.println(indentation + "\t\t" + property.getName() + " " + property.getType() + " " + property.getValue());
        }
        System.out.println(indentation + "\tReferences:");
        for (CreateReferenceCommand reference : parameters.getReferences()) {
            CreateReferenceDescription referenceDescription = reference.getCreateReferenceDescription();
            System.out.println(indentation + "\t\t" + referenceDescription.getRole() + " " + referenceDescription.getSecondaryRole());
            if (parameters.equals(reference.getTargetCreationCommand())) continue;
            WriteUtil.printCreationParameters(indentation + "\t\t\t", reference.getTargetCreationCommand());
        }
    }

    public static void printDeleteParameters(String indentation, DeleteInfoObjectCommand command) {
        System.out.println(indentation + "oid: " + command.getOid());
    }

    public static void printUpdateParameters(String indentation, UpdateInfoObjectCommand command) {
        System.out.println(indentation + "oid: " + command.getOid());
        System.out.println(indentation + "PropertiesToDelete:");
        for (String propertyToDelete : command.getPropertiesToDelete()) {
            System.out.println(indentation + "\t" + propertyToDelete);
        }
        System.out.println(indentation + "PropertiesToUpdate or Add:");
        for (CreatePropertyDescription propertyDescription : command.getPropertiesToUpdateAdd()) {
            System.out.println(indentation + "\tName: " + propertyDescription.getName() + ", Type: " + propertyDescription.getType() + ", Value: " + propertyDescription.getValue());
        }
        System.out.println(indentation + "NewRawContentUrl:");
        System.out.println(indentation + "\t" + command.getNewRawContentUrl());
    }

    public static void printSMSCommands(List<SMSCommand> commands) {
        String indentation = "";
        for (SMSCommand command : commands) {
            if (command instanceof CreateInfoObjectCommand) {
                System.out.println(indentation + "CreateInfoObjectCommand");
                WriteUtil.printCreationParameters(indentation + "\t", (CreateInfoObjectCommand)command);
            }
            if (command instanceof DeleteInfoObjectCommand) {
                System.out.println(indentation + "DeleteInfoObjectCommand");
                WriteUtil.printDeleteParameters(indentation + "\t", (DeleteInfoObjectCommand)command);
            }
            if (!(command instanceof UpdateInfoObjectCommand)) continue;
            System.out.println(indentation + "UpdateInfoObjectCommand");
            WriteUtil.printUpdateParameters(indentation + "\t", (UpdateInfoObjectCommand)command);
        }
    }

    public static String toString(CreateInfoObjectCommand parameters) {
        StringBuilder sb = new StringBuilder("CreateInfoObjectCommand [Parameters=");
        sb.append(WriteUtil.toString(parameters.getParameters()));
        sb.append(", References=[");
        for (CreateReferenceCommand reference : parameters.getReferences()) {
            if (reference.getTargetCreationCommand().equals(parameters)) continue;
            sb.append(WriteUtil.toString(reference));
            sb.append(", ");
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    public static String toString(CreateInfoObjectReferencesProperties createInfoObjectReferencesProperties) {
        StringBuilder sb = new StringBuilder("CreateInfoObjectReferencesProperties [Name=");
        sb.append(createInfoObjectReferencesProperties.getName());
        sb.append(", Type=");
        sb.append(createInfoObjectReferencesProperties.getType());
        sb.append(", FileLocation=");
        sb.append(createInfoObjectReferencesProperties.getFileLocation());
        if (createInfoObjectReferencesProperties.getProperties() != null) {
            sb.append(", Properties=[");
            for (CreatePropertyDescription createPropertyDescription : createInfoObjectReferencesProperties.getProperties()) {
                sb.append(WriteUtil.toString(createPropertyDescription));
                sb.append(", ");
            }
            sb.append("]");
        }
        if (createInfoObjectReferencesProperties.getReferences() != null) {
            sb.append(", References=[");
            for (CreatePropertyDescription createPropertyDescription : createInfoObjectReferencesProperties.getReferences()) {
                sb.append(WriteUtil.toString((CreateReferenceDescription)createPropertyDescription));
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(CreatePropertyDescription createPropertyDescription) {
        StringBuilder sb = new StringBuilder("CreatePropertyDescription [Name=");
        sb.append(createPropertyDescription.getName());
        sb.append(", Type=");
        sb.append(createPropertyDescription.getType());
        sb.append(", Value=");
        sb.append(createPropertyDescription.getValue());
        sb.append("]");
        return sb.toString();
    }

    public static String toString(CreateReferenceCommand createReferenceCommand) {
        StringBuilder sb = new StringBuilder("CreateReferenceCommand [ReferenceDescription=");
        sb.append(WriteUtil.toString(createReferenceCommand.getCreateReferenceDescription()));
        sb.append(", Target=");
        sb.append(WriteUtil.toString(createReferenceCommand.getTargetCreationCommand()));
        sb.append("]");
        return sb.toString();
    }

    public static String toString(ReferenceDescription referenceDescription) {
        StringBuilder sb = new StringBuilder("ReferenceDescription [");
        if (referenceDescription.getPosition() != null) {
            sb.append("Position=");
            sb.append(referenceDescription.getPosition());
        }
        if (referenceDescription.getPropagationRule() != null) {
            sb.append(", PropagationRule=");
            sb.append(referenceDescription.getPropagationRule());
        }
        if (referenceDescription.getRole() != null) {
            sb.append(", Role=");
            sb.append(referenceDescription.getRole());
        }
        if (referenceDescription.getSecondaryRole() != null) {
            sb.append(", SecondaryRole=");
            sb.append(referenceDescription.getSecondaryRole());
        }
        if (referenceDescription.getSourceObjectID() != null) {
            sb.append(", SourceObjectID=");
            sb.append(referenceDescription.getSourceObjectID());
        }
        if (referenceDescription.getTargetObjectID() != null) {
            sb.append(", TargetObjectID=");
            sb.append(referenceDescription.getTargetObjectID());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(CreateReferenceDescription createReferenceDescription) {
        StringBuilder sb = new StringBuilder("CreateReferenceDescription [");
        if (createReferenceDescription.getPosition() != null) {
            sb.append("Position=");
            sb.append(createReferenceDescription.getPosition());
        }
        if (createReferenceDescription.getPropagationRule() != null) {
            sb.append(", PropagationRule=");
            sb.append(createReferenceDescription.getPropagationRule());
        }
        if (createReferenceDescription.getRole() != null) {
            sb.append(", Role=");
            sb.append(createReferenceDescription.getRole());
        }
        if (createReferenceDescription.getSecondaryRole() != null) {
            sb.append(", SecondaryRole=");
            sb.append(createReferenceDescription.getSecondaryRole());
        }
        if (createReferenceDescription.getOtherObjectID() != null) {
            sb.append(", OtherObjectID=");
            sb.append(createReferenceDescription.getOtherObjectID());
        }
        sb.append(", isNewObjectSource=");
        sb.append(createReferenceDescription.isNewObjectSource());
        sb.append("]");
        return sb.toString();
    }

    public static String toString(DeleteInfoObjectCommand command) {
        StringBuilder sb = new StringBuilder("DeleteInfoObjectCommand [oid=");
        sb.append(command.getOid());
        sb.append("]");
        return sb.toString();
    }

    public static String toString(UpdateInfoObjectCommand command) {
        StringBuilder sb = new StringBuilder("UpdateInfoObjectCommand [oid=");
        sb.append(command.getOid());
        sb.append(", PropertiesToDelete=");
        sb.append(command.getPropertiesToDelete());
        sb.append(", PropertiesToUpdateAdd=[");
        for (CreatePropertyDescription propertyDescription : command.getPropertiesToUpdateAdd()) {
            sb.append(WriteUtil.toString(propertyDescription));
            sb.append(", ");
        }
        sb.append("]");
        sb.append(", NewRawContentUrl=");
        sb.append(command.getNewRawContentUrl());
        sb.append("]");
        return sb.toString();
    }

    public static String toString(SMSCommand command) {
        if (command instanceof CreateInfoObjectCommand) {
            return WriteUtil.toString((CreateInfoObjectCommand)command);
        }
        if (command instanceof DeleteInfoObjectCommand) {
            return WriteUtil.toString((DeleteInfoObjectCommand)command);
        }
        if (command instanceof UpdateInfoObjectCommand) {
            return WriteUtil.toString((UpdateInfoObjectCommand)command);
        }
        return null;
    }

    protected static interface Printer {
        public void println(String var1);
    }
}

