/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.accounting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAccountingImpl
implements Report {
    final Logger logger = LoggerFactory.getLogger(ReportAccountingImpl.class);
    public RawUsageRecord ur;
    public ResourceAccounting raFactory;

    @Override
    public void init() {
        this.raFactory = null;
        try {
            this.raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(String consumerId, String resourceScope, String creationTime) {
        this.logger.info("set accounting properties: consumerId " + consumerId + " scope: " + resourceScope + " creationTime " + creationTime);
        if (this.raFactory == null) {
            this.init();
        }
        this.ur = new RawUsageRecord();
        this.ur.setResourceType("storage-usage");
        if (consumerId != null) {
            this.ur.setConsumerId(consumerId);
        }
        if (resourceScope != null) {
            this.ur.setResourceScope(resourceScope);
        }
        if (creationTime != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd MM yyyy 'at' hh:mm:ss z");
            Date date = null;
            try {
                date = formatter.parse(creationTime);
            }
            catch (ParseException e) {
                this.logger.error("Error in parsing date: " + creationTime + " exc msg: " + e.getMessage());
            }
            this.ur.setCreateTime(date);
        }
    }

    @Override
    public void timeUpdate() {
        this.setStartTime();
    }

    @Override
    public void ultimate(String owner, String operation, String size, String filePath, String id, String callerIP, String lastAccess) {
        this.logger.info("set accounting properties: owner " + owner + " operation: " + operation + " size: " + size + " remotePath: " + filePath + " id: " + id + "callerIP " + callerIP + " lastAccess" + lastAccess);
        if (this.ur == null) {
            this.ur = new RawUsageRecord();
        }
        if (owner != null) {
            this.ur.setResourceOwner(owner);
        }
        if (operation != null) {
            this.ur.setResourceSpecificProperty("operationType", operation);
        }
        if (size != null) {
            this.ur.setResourceSpecificProperty("dataVolume", size);
        }
        if (filePath != null) {
            this.ur.setResourceSpecificProperty("remotePath", filePath);
        }
        if (id != null) {
            this.ur.setResourceSpecificProperty("id", id);
        }
        if (callerIP != null) {
            this.ur.setResourceSpecificProperty("callerIP", "etics.eng.it");
        }
        if (lastAccess != null) {
            this.ur.setResourceSpecificProperty("lastAccess", lastAccess);
        }
        this.ur.setResourceSpecificProperty("dataType", "STORAGE");
        this.ur.setResourceSpecificProperty("dataCount", "1");
    }

    @Override
    public void send() {
        this.logger.info("report sending...");
        if (this.raFactory != null) {
            this.raFactory.sendAccountingMessage(this.ur);
        } else {
            this.logger.error("Problem on building accounting record: Factory Object is null ");
        }
    }

    @Deprecated
    private void setIpAddress() {
        String address = null;
        try {
            address = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.logger.info("caller ip: " + address);
        if (address != null) {
            this.ur.setResourceSpecificProperty("callerIP", address);
        }
    }

    private void setStartTime() {
        GregorianCalendar startTime = new GregorianCalendar();
        Date time = startTime.getTime();
        this.logger.info("set start time: " + time);
        try {
            this.ur.setStartTime(time);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }

    private void setEndTime() {
        GregorianCalendar endTime = new GregorianCalendar();
        Date time = endTime.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("dd MM yyyy 'at' hh:mm:ss z");
        sdf.format(time);
        this.logger.info("set end time: " + time);
        try {
            this.ur.setEndTime(time);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }
}

