/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.startup;

import java.util.Arrays;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.data.ReadingMongoOplog;
import org.gcube.contentmanager.storageserver.parse.JsonParser;
import org.gcube.contentmanager.storageserver.startup.Configuration;

public class Startup {
    private static String user;
    private static String password;
    private static String scope;

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 4) {
            System.out.println("Usage:");
            System.out.println("\tjava  Startup scope ip user password\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  Startup /gcube/devsec localhost pippo pluT0\n");
            System.out.println("or ");
            System.out.println("Usage:");
            System.out.println("\tjava  Startup scope ip\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  Startup /gcube  localhost\n\n");
            return;
        }
        scope = args[0];
        String oplogServer = args[1];
        if (args.length == 4) {
            user = args[2];
            password = args[3];
        }
        String[] server = Startup.retrieveConfiguration();
        CubbyHole c = new CubbyHole();
        ReadingMongoOplog producer = null;
        producer = args.length == 3 ? new ReadingMongoOplog(Arrays.asList(oplogServer), args[1], args[2], c, 1) : new ReadingMongoOplog(Arrays.asList(server), c, 1);
        JsonParser consumer = null;
        consumer = args.length == 3 ? new JsonParser(server, c, 1) : new JsonParser(server, args[1], args[2], c, 1);
        producer.start();
        consumer.start();
    }

    private static String[] retrieveConfiguration() {
        Configuration c = new Configuration(scope, user, password);
        return c.getServerAccess();
    }
}

