package org.gcube.contentmanager.storageserver.startup;

import java.util.Arrays;
import java.util.HashMap;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.data.ReadingMongoOplog;
import org.gcube.contentmanager.storageserver.parse.JsonParser;
//ClaSSPATH
import java.net.URL;
import java.net.URLClassLoader;

public class Startup {
    
	private static String user;
	private static String password;
	private static String scope;
	
	
	public static void main(String[] args) {
		if(args.length != 2 && args.length != 4){
			System.out.println("Usage:");
			System.out.println("\tjava  Startup scope ip user password\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  Startup /gcube/devsec localhost pippo pluT0\n");
			System.out.println("or ");
			System.out.println("Usage:");
			System.out.println("\tjava  Startup scope ip\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  Startup /gcube  localhost\n\n");

			return;
		}
		scope=args[0];
		String oplogServer= args[1];
		if(args.length == 4){
			user=args[2];
			password=args[3];
		}
		String[] server=retrieveConfiguration();
        CubbyHole c = new CubbyHole();
        ReadingMongoOplog producer=null;
        if(args.length == 3)
        	producer=new ReadingMongoOplog( Arrays.asList(oplogServer), args[1], args[2], c, 1 );
        else
        	producer=new ReadingMongoOplog( Arrays.asList(server), c, 1 );
        JsonParser consumer=null;
        if(args.length == 3)
        	consumer=new JsonParser(server, c, 1);
        else
        	consumer=new JsonParser(server, args[1], args[2], c, 1);
        producer.start();
        consumer.start();
    }

	private static String[] retrieveConfiguration() {
		Configuration c=new Configuration(scope, user, password);
		return c.getServerAccess();
	}

}
