package org.gcube.contentmanager.storageserver.accounting;

import org.gcube.accounting.datamodel.RawUsageRecord;

public interface Report {	
	
	public void init();
	/**
	 * Set generic properties of report
	 * @param resourceType
	 * @param consumerId
	 * @param resourceOwner
	 * @param resourceScope
	 * @return
	 */
	public RawUsageRecord setGenericProperties(String resourceType, String consumerId, String resourceScope, String creationTime, String lastAccess, String owner);
	
	/**
	 * Set end time of operation and other specific properties
	 * @return
	 */
	public RawUsageRecord setSpecificProperties(RawUsageRecord sur, String owner, String operation, String size, String filePath,  String dataType, String dataCount);
	
	/**
	 * send report
	 * @return
	 */
	public void send(RawUsageRecord sur);
	
	/**
	 * 
	 */

	public abstract void printRecord(RawUsageRecord record);
}
