/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.gcube.documentstore.records.implementation.AggregatedField;

@JsonTypeName(value="StorageUsageRecord")
public class AggregatedStorageUsageRecord
extends AbstractStorageUsageRecord
implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {
    private static final long serialVersionUID = 1082525518686785682L;
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";

    public AggregatedStorageUsageRecord() {
    }

    public AggregatedStorageUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedStorageUsageRecord(StorageUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    @Override
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @Override
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @Override
    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    @Override
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    @Override
    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    @Override
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    @Override
    public void setAggregated(Boolean aggregate) throws InvalidValueException {
        super.setAggregated(aggregate);
    }

    @Override
    public Boolean isAggregated() {
        return super.isAggregated();
    }

    @Override
    public AggregatedStorageUsageRecord aggregate(AggregatedStorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            AggregationUtility<AggregatedStorageUsageRecord> aggregationUtility = new AggregationUtility<AggregatedStorageUsageRecord>(this);
            aggregationUtility.aggregate(record);
            this.setDataVolume(this.getDataVolume() + record.getDataVolume());
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
        return this;
    }

    @Override
    public AggregatedStorageUsageRecord aggregate(StorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedStorageUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
    }

    @Override
    public boolean isAggregable(AggregatedStorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility<AggregatedStorageUsageRecord> aggregationUtility = new AggregationUtility<AggregatedStorageUsageRecord>(this);
        return aggregationUtility.isAggregable(record);
    }

    @Override
    public boolean isAggregable(StorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedStorageUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
    }

    @Override
    public Class<StorageUsageRecord> getAggregable() {
        return StorageUsageRecord.class;
    }
}

