/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.icclient;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.resources.gcore.Software;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.impl.DelegateClient;
import org.gcube.resources.discovery.client.impl.JAXBParser;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICFactory {
    private static Logger logger = LoggerFactory.getLogger(ICFactory.class);
    private static Map<Class<?>, Map<String, String>> registry = new HashMap();
    public static final String nsDeclaration = "declare namespace ic = 'http://gcube-system.org/namespaces/informationsystem/registry';";
    public static final String instancesNSDeclaration = "declare namespace ic = 'http://gcube-system.org/namespaces/informationsystem/registry';declare namespace gcube = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';";
    private static final String profile_range = "collection('/db/Profiles/%1$s')//Document/Data/ic:Profile/Resource";

    private static void register(Class<?> type, Map<String, String> parameters) throws IllegalStateException {
        if (registry.containsKey(type)) {
            throw new IllegalStateException("a query is already registered for type" + type);
        }
        registry.put(type, parameters);
    }

    public static XQuery queryFor(Class<?> type) throws IllegalStateException {
        if (registry.containsKey(type)) {
            return new XQuery(registry.get(type));
        }
        throw new IllegalStateException("no query registered for " + type);
    }

    public static <R> DiscoveryClient<R> clientFor(Class<R> type) {
        return new DelegateClient<R>(new JAXBParser<R>(type), ICFactory.client());
    }

    public static DiscoveryClient<String> client() {
        try {
            Class<?> localClientclass = Class.forName("org.gcube.informationsystem.collector.client.LocalDiscoveryClient", true, Thread.currentThread().getContextClassLoader());
            logger.info("using LocalDiscoveryClient");
            return (DiscoveryClient)localClientclass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return new ICClient();
        }
    }

    public static <R> DiscoveryClient<R> clientWith(ResultParser<R> parser) {
        return new DelegateClient<R>(parser, ICFactory.client());
    }

    public static ParameterBuilder params() {
        return new ParameterBuilder();
    }

    static {
        ICFactory.register(Resource.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "")).build());
        ICFactory.register(GenericResource.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "GenericResource")).build());
        ICFactory.register(ServiceEndpoint.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "RuntimeResource")).build());
        ICFactory.register(ServiceInstance.class, ICFactory.params().add("ns", instancesNSDeclaration).add("range", "collection('/db/Properties')//Document").build());
        ICFactory.register(GCoreEndpoint.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "RunningInstance")).build());
        ICFactory.register(Software.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "Service")).build());
        ICFactory.register(HostingNode.class, ICFactory.params().add("ns", nsDeclaration).add("range", String.format(profile_range, "GHN")).build());
    }

    public static class ParameterBuilder {
        private Map<String, String> params = new HashMap<String, String>();

        public ParameterBuilder add(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public Map<String, String> build() {
            return this.params;
        }
    }
}

