/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.data;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.util.Arrays;
import java.util.List;
import org.bson.types.BSONTimestamp;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingMongoOplog
extends Thread {
    public static final String DBNAME = "remotefs";
    public static final String LOCAL_COLLECTION = "oplog.rs";
    public static final String LOCAL_DB = "local";
    protected static ReadPreference READ_PREFERENCE = ReadPreference.secondaryPreferred();
    static final Logger logger = LoggerFactory.getLogger(ReadingMongoOplog.class);
    private ServerAddress[] server;
    private MongoClient mongoClient;
    private DB local;
    private DBCollection oplog;
    private CubbyHole c1;
    private CubbyHole c2;
    private String user;
    private String password;
    private int number;
    private List<String> srvs;

    public ReadingMongoOplog(List<String> srvs, CubbyHole c1, CubbyHole c2, int numberT) {
        this.c1 = c1;
        this.c2 = c2;
        this.number = numberT;
        this.srvs = srvs;
        this.setupServerAddress(srvs);
        this.initBackend();
    }

    public ReadingMongoOplog(List<String> srvs, String user, String password, CubbyHole c1, CubbyHole c2, int numberT) {
        this.c1 = c1;
        this.c2 = c2;
        this.number = numberT;
        this.user = user;
        this.password = password;
        this.setupServerAddress(srvs);
        this.initBackend();
    }

    @Override
    public void run() {
        DBCursor lastCursor = this.oplog.find().sort(new BasicDBObject("$natural", (Object)-1)).limit(1);
        if (!lastCursor.hasNext()) {
            logger.error("no oplog!");
            return;
        }
        DBObject last = lastCursor.next();
        BSONTimestamp ts = (BSONTimestamp)last.get("ts");
        while (true) {
            logger.debug("Sniffing is starting at ts: " + ts);
            DBCursor cursor = this.oplog.find(new BasicDBObject("ts", new BasicDBObject("$gt", ts)));
            cursor.addOption(2);
            cursor.addOption(32);
            cursor.addOption(16);
            while (cursor.hasNext()) {
                try {
                    DBObject x = cursor.next();
                    logger.trace("oplog current object: " + x);
                    ts = (BSONTimestamp)x.get("ts");
                    String ns = (String)x.get("ns");
                    if (x.get("o2") != null || ns.equalsIgnoreCase("remotefs.fs.files")) {
                        if (x.containsField("o")) {
                            this.c1.put(x);
                            if (this.c2 != null) {
                                this.c2.put(x);
                            }
                        } else {
                            logger.debug("operation is not accounted");
                        }
                    } else {
                        logger.debug("object discarded ");
                    }
                }
                catch (Exception e) {
                    logger.error("Exception throws: " + e.getMessage());
                    e.printStackTrace();
                }
                logger.debug("...waiting new object... ");
            }
            logger.warn("out of the cycle ");
        }
    }

    private void initBackend() {
        MongoClientOptions options = MongoClientOptions.builder().readPreference(READ_PREFERENCE).build();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean auth = false;
        logger.info("try to auth ");
        if (this.user != null && this.password != null) {
            MongoCredential credential = MongoCredential.createCredential(this.user, "admin", this.password.toCharArray());
            logger.debug("try to connect to mongo with authentication... ");
            this.mongoClient = new MongoClient(Arrays.asList(this.server), Arrays.asList(credential), options);
        } else {
            logger.debug("try to connect to mongo... ");
            this.mongoClient = new MongoClient(Arrays.asList(this.server));
        }
        logger.debug("authenticated. ");
        logger.debug("try to connect to local db...");
        this.local = this.mongoClient.getDB(LOCAL_DB);
        logger.debug("db connected ");
        this.oplog = this.local.getCollection(LOCAL_COLLECTION);
    }

    private void setupServerAddress(List<String> srvs) {
        if (srvs.size() > 0) {
            this.server = new ServerAddress[srvs.size()];
            int i = 0;
            for (String s : srvs) {
                this.server[i] = new ServerAddress(s);
                ++i;
            }
        } else {
            logger.error("MongoDB server not set. Please set one or more servers");
            throw new RuntimeException("MongoDB server not set. Please set one or more servers");
        }
    }
}

