/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.common.file;

import java.io.File;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.gcube.accounting.common.file.FileChangedListener;

public class FileWatcher {
    private static Logger logger = Logger.getLogger(FileWatcher.class);
    private File file;
    private FileChangedListener listener;
    private long interval;
    private Timer timer;

    public FileWatcher(String fileName) {
        this(new File(fileName));
    }

    public FileWatcher(File file) {
        this.file = file;
        this.setInterval(10000L);
    }

    public void setListener(FileChangedListener listener) {
        this.listener = listener;
    }

    public File getFile() {
        return this.file;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        this.scheduleFileCheck();
    }

    private void scheduleFileCheck() {
        this.stop();
        CheckModificationTask task = new CheckModificationTask(this.file);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)task, new Date(), this.getInterval());
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    class CheckModificationTask
    extends TimerTask {
        private File file;
        private long timestamp;

        public CheckModificationTask(File file) {
            this.file = file;
            this.timestamp = 0L;
        }

        @Override
        public final void run() {
            logger.debug("checking file '" + this.file.getName() + "' for modifications");
            long timestamp = this.file.lastModified();
            if (this.timestamp != timestamp) {
                this.timestamp = timestamp;
                if (FileWatcher.this.listener != null) {
                    FileWatcher.this.listener.fileChanged(this.file);
                }
            }
        }
    }
}

