/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.messaging.consumer;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer
extends Thread
implements ExceptionListener {
    private static Consumer singleton;
    protected static boolean transacted;
    protected static int ackMode;
    private static String subject;
    private static Logger logger;
    protected ArrayList<Connection> connections = new ArrayList();
    protected QueueCouple queueCouple;

    private Consumer() {
    }

    public static Consumer getSingleton() {
        return singleton;
    }

    public RawUsageRecord receiveMessageFromQueue(QueueCouple queueCouple) {
        this.queueCouple = queueCouple;
        RawUsageRecord p = null;
        logger.debug("Receiving message from queue");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(queueCouple.getBroker());
        Connection connection = null;
        while (connection == null) {
            try {
                connection = connectionFactory.createConnection();
            }
            catch (JMSException e) {
                System.out.println("Error on subscription");
                try {
                    Thread.sleep(12000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        logger.debug("Creating a new Connection");
        try {
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(queueCouple.getScope() + "." + subject);
            MessageConsumer consumer = session.createConsumer(queue);
            logger.debug("Consumer waiting...");
            Message message = consumer.receive();
            logger.debug("new Message");
            if (message instanceof ObjectMessage) {
                ObjectMessage obj = (ObjectMessage)message;
                p = (RawUsageRecord)obj.getObject();
                logger.debug("Received" + p.getId());
            } else {
                logger.debug("Received message of unknown type");
            }
            consumer.close();
            session.close();
            connection.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return p;
    }

    @Override
    public void run() {
        try {
            for (Connection connection : this.connections) {
                connection.stop();
                connection.close();
            }
            this.connections.clear();
        }
        catch (JMSException e) {
            logger.debug("Exception stopping the connection", e);
            this.connections.clear();
        }
        while (true) {
            try {
                this.subscribe();
                return;
            }
            catch (InvalidClientIDException ex) {
                logger.error("Subscription has not been reset", ex);
                return;
            }
            catch (Exception e) {
                logger.error("Error on subscription", e);
                try {
                    Thread.sleep(12000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public void subscribe() throws Exception {
        this.receiveMessageFromQueue(this.queueCouple);
    }

    @Override
    public void onException(JMSException exce) {
        logger.error(exce.getMessage());
        this.run();
    }

    static {
        transacted = false;
        ackMode = 1;
        subject = "resource-accounting";
        logger = LoggerFactory.getLogger(Consumer.class);
        singleton = new Consumer();
    }
}

