/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Diagnostics {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Diagnostics.class);
    public static final java.lang.management.OperatingSystemMXBean OS_BEAN = ManagementFactory.getOperatingSystemMXBean();
    public static final MemoryMXBean MEM_BEAN = ManagementFactory.getMemoryMXBean();
    public static final RuntimeMXBean RUNTIME_BEAN = ManagementFactory.getRuntimeMXBean();
    public static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();

    public static void systemInfo(Map<String, Object> infos) {
        infos.put("sys.os.name", OS_BEAN.getName());
        infos.put("sys.os.version", OS_BEAN.getVersion());
        infos.put("sys.os.arch", OS_BEAN.getArch());
        infos.put("sys.cpu.num", OS_BEAN.getAvailableProcessors());
        infos.put("sys.cpu.loadAvg", OS_BEAN.getSystemLoadAverage());
        try {
            if (OS_BEAN instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean sunBean = (OperatingSystemMXBean)OS_BEAN;
                infos.put("proc.cpu.time", sunBean.getProcessCpuTime());
                infos.put("mem.physical.total", sunBean.getTotalPhysicalMemorySize());
                infos.put("mem.physical.free", sunBean.getFreePhysicalMemorySize());
                infos.put("mem.virtual.comitted", sunBean.getCommittedVirtualMemorySize());
                infos.put("mem.swap.total", sunBean.getTotalSwapSpaceSize());
                infos.put("mem.swap.free", sunBean.getFreeSwapSpaceSize());
            }
        }
        catch (Throwable err) {
            LOGGER.debug("com.sun.management.OperatingSystemMXBean not available, skipping extended system info.");
        }
    }

    public static void gcInfo(Map<String, Object> infos) {
        List<GarbageCollectorMXBean> mxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean mxBean : mxBeans) {
            infos.put("gc." + mxBean.getName().toLowerCase() + ".collectionCount", mxBean.getCollectionCount());
            infos.put("gc." + mxBean.getName().toLowerCase() + ".collectionTime", mxBean.getCollectionTime());
        }
    }

    public static void memInfo(Map<String, Object> infos) {
        infos.put("heap.used", MEM_BEAN.getHeapMemoryUsage());
        infos.put("offHeap.used", MEM_BEAN.getNonHeapMemoryUsage());
        infos.put("heap.pendingFinalize", MEM_BEAN.getObjectPendingFinalizationCount());
    }

    public static void runtimeInfo(Map<String, Object> infos) {
        infos.put("runtime.vm", RUNTIME_BEAN.getVmVendor() + "/" + RUNTIME_BEAN.getVmName() + ": " + RUNTIME_BEAN.getVmVersion());
        infos.put("runtime.startTime", RUNTIME_BEAN.getStartTime());
        infos.put("runtime.uptime", RUNTIME_BEAN.getUptime());
        infos.put("runtime.name", RUNTIME_BEAN.getName());
        infos.put("runtime.spec", RUNTIME_BEAN.getSpecVendor() + "/" + RUNTIME_BEAN.getSpecName() + ": " + RUNTIME_BEAN.getSpecVersion());
        infos.put("runtime.sysProperties", RUNTIME_BEAN.getSystemProperties());
    }

    public static void threadInfo(Map<String, Object> infos) {
        infos.put("thread.count", THREAD_BEAN.getThreadCount());
        infos.put("thread.peakCount", THREAD_BEAN.getPeakThreadCount());
        infos.put("thread.startedCount", THREAD_BEAN.getTotalStartedThreadCount());
    }

    public static Map<String, Object> collect() {
        TreeMap<String, Object> infos = new TreeMap<String, Object>();
        Diagnostics.systemInfo(infos);
        Diagnostics.memInfo(infos);
        Diagnostics.threadInfo(infos);
        Diagnostics.gcInfo(infos);
        Diagnostics.runtimeInfo(infos);
        return infos;
    }

    public static String collectAndFormat() {
        Map<String, Object> infos = Diagnostics.collect();
        StringBuilder sb = new StringBuilder();
        sb.append("Diagnostics {\n");
        int count = 0;
        for (Map.Entry<String, Object> info : infos.entrySet()) {
            if (count++ > 0) {
                sb.append(",\n");
            }
            sb.append("  ").append(info.getKey()).append("=").append(info.getValue());
        }
        sb.append("\n}");
        return sb.toString();
    }
}

