/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;

public class PartitionSelectionStrategy
implements SelectionStrategy {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Endpoint select(CouchbaseRequest request, Endpoint[] endpoints) {
        int numEndpoints = endpoints.length;
        if (numEndpoints == 0) {
            return null;
        }
        if (!(request instanceof BinaryRequest)) throw new IllegalStateException("The PartitionSelectionStrategy does not understand: " + request);
        if (request instanceof GetBucketConfigRequest) {
            return PartitionSelectionStrategy.selectFirstConnected(endpoints);
        }
        BinaryRequest binaryRequest = (BinaryRequest)request;
        short partition = binaryRequest.partition();
        if (partition <= 0) return PartitionSelectionStrategy.selectFirstConnected(endpoints);
        int id = partition % numEndpoints;
        Endpoint endpoint = endpoints[id];
        if (endpoint == null || !endpoint.isState(LifecycleState.CONNECTED)) return null;
        return endpoint;
    }

    private static final Endpoint selectFirstConnected(Endpoint[] endpoints) {
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.isState(LifecycleState.CONNECTED)) continue;
            return endpoint;
        }
        return null;
    }
}

